(*  :Title:	Initialization for Analog Signal Processing Package  *)

(*  :Authors:	Brian Evans, James McClellan  *)

(*  :Summary:	This is an initialization file only  *)

(*  :Context:	Global`  *)

(*  :PackageVersion:  2.4	*)

(*
    :Copyright:	Copyright 1989, 1990 by
		the Digital Signal Processing Group
		at the Georgia Institute of Technology

	Permission to use, copy, modify, and distribute this software
	and its documentation for any purpose and without fee is
	hereby granted, provided that the above copyright notice
	appear in all copies and that both that copyright notice and
	this permission notice appear in supporting documentation,
	and that the name of Georgia Tech or Georgia Institute of
	Technology not be used in advertising or publicity pertaining
	to distribution of the software without specific, written prior
	permission.  Georgia Tech makes no representations about the
	suitability of this software for any purpose.  It is provided
	"as is" without express or implied warranty.
 *)

(*  :History:	*)

(*  :Keywords:	*)

(*  :Source:	*)

(*  :Warning:	*)

(*  :Mathematica Version:  1.2 or 2.0  *)

(*  :Limitation:  *)

(*
    :Discussion:	Hierarchy of analog signal processing packages:

				       
(d)		     ASPAnalyze.m      
		    |		 |     
(c)		    |	     Fourier.m	   LSolve.m			 A
		    |		 |	       |			 N
		    |        ----+-------------+----			 A
		    |	    |			    |			 L
(b)		    LaPlace.m			InvLaPlace.m		 O
			|			    |			 G
			 --------+------------------
				 |
(a)	FilterDesign.m	      LSupport.m
	      |			 |

 *)


(*  B E G I N     I N I T I A L I Z A T I O N  *)

(*  Load in those on which the analog sp packages rely  *)

Needs[ "SignalProcessing`Support`"]



Which [ 


(*  Check to make sure that these have not already been loaded in  *)

MemberQ[ $ContextPath, "SignalProcessing`Analog`" ],

  Print["Version 2.4 of the analog signal processing packages has \
	already been loaded."],


(*  For Mathematica 2.0, we only define the stubs  *)

TrueQ[ $VersionNumber >= 2.0 ],

  Print["Defining stubs for objects in version 2.4 of the \
	 analog signal processing packages ..."];

  DeclarePackage[ "SignalProcessing`Analog`ASPAnalyze`", { "ASPAnalyze" } ];

  DeclarePackage[ "SignalProcessing`Analog`FilterDesign`", { 
			"AnalogFilter", "BesselPolynomial",
			"FilterTransform", "RationalChebyshev" } ];

  DeclarePackage[ "SignalProcessing`Analog`Fourier`", { 
			"CTFTData", "CTFTransform", "InvCTFTransform" } ];

  DeclarePackage[ "SignalProcessing`Analog`InvLaPlace`", { "InvLaPlace" } ];

  DeclarePackage[ "SignalProcessing`Analog`LSolve`", { "LSolve" } ];

  DeclarePackage[ "SignalProcessing`Analog`LSupport`", { 
			"InvalidLTransformQ", "InvalidInvLTransformQ",
			"LForm", "LMultiDROC", "LTransformQ", "MakeLObject" } ];

  DeclarePackage[ "SignalProcessing`Analog`LaPlace`", { 
			"LaPlace", "LaPlaceTransform" } ];

  AppendTo[$ContextPath, "SignalProcessing`Analog`" ],


 (*  Load in the packages manually under Mathematica 1.2  *)

True,

  Print["Loading version 2.4 of the analog signal processing packages ..."];

  Needs[ "SignalProcessing`Analog`FilterDesign`" ];		(* level a *)
  Needs[ "SignalProcessing`Analog`LSupport`" ];

  Needs[ "SignalProcessing`Analog`LaPlace`" ];		(* level b *)
  Needs[ "SignalProcessing`Analog`InvLaPlace`" ];

  Needs[ "SignalProcessing`Analog`Fourier`" ];		(* level c *)
  Needs[ "SignalProcessing`Analog`LSolve`" ];

  Needs[ "SignalProcessing`Analog`ASPAnalyze`" ];		(* level d *)

  AppendTo[$ContextPath, "SignalProcessing`Analog`" ]

]


(*  Temporary messages  *)

analog::error = "The current context should be Global` and it is not."
analog::loaded =
	"Routines, objects, and rules for the analog signal \
	processing packages have been loaded successfully."

(*  Error checking  *)

If [ SameQ[$Context, "Global`"],
     Message[ analog::loaded ],
     Message[ analog::error ] ]

(*  Remove temporary messages  *)

analog::error = .
analog::loaded = .


(*  Inform the user about the analog signal processing  *)

Print[" "]
Print["Analog signal processing extensions have been loaded."]
Print["Good starting points are the objects ASPAnalyze and LaPlace."]
Print["Active packages are maintained in $Packages."]
Print["  New signals (functions) are in SPsignals."]
Print["  New systems (operators) are in SPoperators."]
Print["  New Mathematica routines are in SPfunctions."]
Print["Note that all signal processing expressions will"];
Print["be automatically simplified."]
Print[" "]

(*  E N D     I N I T I A L I Z A T I O N  *)

Null
