//$$ controlw.hxx              Control word class

#ifndef CONTROL_WORD_LIB
#define CONTROL_WORD_LIB 0

// for organising an int as a series of bits which indicate whether an
// option is on or off.

class ControlWord
{
   unsigned int cw;                             // the control word
public:
   ControlWord() {}                             // do nothing
   ControlWord(unsigned int i) : cw(i) {}       // load an integer

      // select specific bits (for testing at least one set)
   ControlWord operator*(ControlWord i)  { return cw & i.cw; }
   ControlWord operator*(unsigned int i) { return cw & i; }

      // set bits
   ControlWord operator+(ControlWord i)  { return cw | i.cw; }
   ControlWord operator+(unsigned int i) { return cw | i; }
   void operator+=(ControlWord i)  { cw |= i.cw; }
   void operator+=(unsigned int i) { cw |= i; }

      // reset bits
   ControlWord operator-(ControlWord i)  { return cw - (cw & i.cw); }
   ControlWord operator-(unsigned int i) { return cw - (cw & i); }
   void operator-=(ControlWord i)  { cw -= (cw & i.cw); }
   void operator-=(unsigned int i) { cw -= (cw & i); }

      // check if all of selected bits set or reset
   BOOL operator>=(ControlWord i)  { return (cw & i.cw) == i.cw; }
   BOOL operator>=(unsigned int i) { return (cw & i) == i; }
   BOOL operator<=(ControlWord i)  { return (cw & i.cw) == cw; }
   BOOL operator<=(unsigned int i) { return (cw & i) == cw; }

      // flip selected bits
   ControlWord operator^(ControlWord i)  { return cw ^ i.cw; }
   ControlWord operator^(unsigned int i) { return cw ^ i; }
   ControlWord operator~() { return ~cw; }

   operator int() { return cw; }
};


#endif
