/*
 *	Definitions for the double precision Complex FFT server
 *
 *	Copyright (C) 1988, 1989.
 *
 *	Dr. Thomas Keffer
 *	Rogue Wave Associates
 *	P.O. Box 85341
 *	Seattle WA 98145-1341
 *
 *	Permission to use, copy, modify, and distribute this
 *	software and its documentation for any purpose and
 *	without fee is hereby granted, provided that the
 *	above copyright notice appear in all copies and that
 *	both that copyright notice and this permission notice
 *	appear in supporting documentation.
 *	
 *	This software is provided "as is" without any
 *	expressed or implied warranty.
 *
 *
 *	@(#)cfft.cc	2.2	9/18/89
 */



#include "rw/DComplexFFT.h"
#include "rw/mathpack.h"

static const char SCCSid[] = "@(#)cfft.cc	2.2 9/18/89";

DComplexFFTServer::DComplexFFTServer()
{
  server_N = 0;
}

DComplexFFTServer::DComplexFFTServer(unsigned N)
{
  setOrder(N);
}

DComplexFFTServer::DComplexFFTServer(const DComplexFFTServer& s)
     : the_weights(s.the_weights)
{
  server_N = s.server_N;
}

void
DComplexFFTServer::operator=(const DComplexFFTServer& s)
{
  server_N = s.server_N;
  the_weights.reference(s.the_weights);
}

void
DComplexFFTServer::setOrder(unsigned N)
{
  the_weights.resize(4*N+15);
  fortran_int local = server_N = N;	// Local copy, converted to int
  DCffti_(&local, the_weights.data());	// Call the NCAR weight routine
}

/*
Use the NCAR FFT routines.  See notes in class description header. 
*/

DComplexVec
DComplexFFTServer::fourier(const DComplexVec& v)
{
  unsigned N = v.length();
  if( N != server_N )setOrder(N);

  fortran_int temp_length = N;

#if COMPLEX_PACKS
  /* Make a copy to be transformed: */
  DComplexVec inverse = v.copy();
  DCfftf_(&temp_length, inverse.data(), the_weights.data());
#else
You lose.	Code requires that sizeof(complex)==2*sizeof(double)
#endif

  return inverse;
}

/* Inverse transform */

DComplexVec
DComplexFFTServer::ifourier(const DComplexVec& v)
{
  unsigned N = v.length();
  if( N != server_N )setOrder(N);

  fortran_int temp_length = N;

#if COMPLEX_PACKS
  /* Make a copy to be transformed: */
  DComplexVec inverse = v.copy();
  DCfftb_(&temp_length, inverse.data(), the_weights.data());
#else
You lose.	Code requires that sizeof(complex)==2*sizeof(double)
#endif

  return inverse;
}

/************  Useful utilities **************/

double
spectralVariance(const DComplexVec& v)
{
  // Do not count the mean v(0):
  return sum(norm(v.slice(1,v.length()-1,1)));
}
