#ifndef DCOMPLEXFFT_H
#define DCOMPLEXFFT_H
#pragma once

/*
 *	Double Precision Complex FFT server
 *
 *	Copyright (C) 1988, 1989.
 *
 *	Dr. Thomas Keffer
 *	Rogue Wave Associates
 *	P.O. Box 85341
 *	Seattle WA 98145-1341
 *
 *	Permission to use, copy, modify, and distribute this
 *	software and its documentation for any purpose and
 *	without fee is hereby granted, provided that the
 *	above copyright notice appear in all copies and that
 *	both that copyright notice and this permission notice
 *	appear in supporting documentation.
 *	
 *	This software is provided "as is" without any
 *	expressed or implied warranty.
 *
 *
 *	@(#)DComplexFFT.h	2.2	9/18/89
 */

#include "DComplexVec.h"
     
/*

This class does complex fourier transforms of a series of a specified
length.  It can serve as the nucleus by which to do a wide variety of
transforms and, indeed, is inherited by several other servers.  The
NCAR FFT routines are used to perform the actual calculations.  This
can easily be replaced by specialized hardware or another algorithm.

The DFT calculated is:

               N-1
        A(n) = sum X(j) exp(-2 * pi * n * j * I / N);      n=0,...,N-1
               j=0

The IDFT calculated is similar:

               N-1
        X(j) = sum A(n) exp( 2 * pi * n * j * I / N);      j=0,...,N-1
               n=0

where A and X are complex.  Note that the sum is NOT normalized: a
call to fourier(), followed by a call to ifourier() will result in the
original series multiplied by N.

It precalculates the weights necessary to do the transform.  If it is
handed a series of a different length, it will reconfigure, an
expensive calculation.  Hence, it is most efficient to call it
repeatedly for series of the same length.  Construct several servers
to handle a variety of lengths.

*/

class DComplexFFTServer {
  unsigned		server_N;
protected:
  DoubleVec		the_weights;
public:
  DComplexFFTServer();
  DComplexFFTServer(unsigned oforder);
  DComplexFFTServer(const DComplexFFTServer&);

  void			operator=(const DComplexFFTServer&);

  unsigned		order()	{return server_N;}
  void			setOrder(unsigned); // Set new N

  /***********  TRANSFORMS ***********/
  // Returns DFT of a complex sequence:
  DComplexVec		fourier(const DComplexVec&);
  // Returns IDFT of a complex sequence:
  DComplexVec		ifourier(const DComplexVec&);
};

// Other useful functions:
  double		spectralVariance(const DComplexVec&);
#endif
