
#include <LEDA/bb_tree.h>
#include <LEDA/window.h>

window W(1150,900);

void draw_node(double x, double y, void* i)
{ W.draw_text_node(x,y,string("%d",i)); }

void draw_edge(double x0, double y0, double x1, double y1)
{ W.draw_edge(x0,y0,x1,y1,blue); }

void main()
{
  bb_tree T;

  int n = W.read_int("n = ");

  init_random();

  if (W.confirm("random"))
    while (n--) T.insert((void*)random(0,100),0);
  else
    for(int i=0;i<n;i++) T.insert((void*)i,0);

  double dy = (W.ymax()-W.ymin())/10;

  T.draw(draw_node,draw_edge, W.xmin(),W.xmax(),W.ymax()-dy,dy);

  W.read_mouse();

}
