/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  segment.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/




#ifndef SEGMENTH
#define SEGMENTH

#include <LEDA/point.h>

//------------------------------------------------------------------------------
// segments
//------------------------------------------------------------------------------


struct segment_rep {
   
   point start;
   point end;
   
   int count;
   
   segment_rep(point p, point q);
   segment_rep();  
   
   
   
   LEDA_MEMORY(segment_rep)
   
};


class segment  : public LEDA_SIMPLE 
{

friend class line;
friend class circle;


/* segment_rep* ptr(); */

segment_rep* ptr() const { return (segment_rep*)PTR; }

public:

segment();                 
segment(point x, point y); 
segment(double x1, double y1, double x2, double y2) ;
segment(point p, double length, double alpha);
segment(const segment&);      
void clear();           

~segment()                { clear(); }


/* cfront 3.0   bug ????
operator vector()  { return vector(xcoord2()-xcoord1(), ycoord2()-ycoord1()); }
*/

bool intersection(segment s, point& inter);

point start()  const      { return ptr()->start; }
point end()    const      { return ptr()->end; }

double xcoord1()          { return ptr()->start.ptr()->x; }
double xcoord2()          { return ptr()->end.ptr()->x;   }
double ycoord1()          { return ptr()->start.ptr()->y; }
double ycoord2()          { return ptr()->end.ptr()->y;   }

segment translate(double,double);
segment translate(const vector&);

double  angle(segment);
double  angle();
double  direction()       { return angle();}
double  distance(segment);
double  distance(point);
double  distance();
double  slope();
double  x_proj(double);
double  y_proj(double);
double  y_abs();
double  length();

segment rotate(double);
segment rotate(point,double);

bool  vertical();
bool  horizontal();

bool  right()            { return ptr()->start.ptr()->x < ptr()->end.ptr()->x; }
bool  left()             { return ptr()->start.ptr()->x > ptr()->end.ptr()->x; }
bool  up()               { return ptr()->start.ptr()->y < ptr()->end.ptr()->y; }
bool  down()             { return ptr()->start.ptr()->y > ptr()->end.ptr()->y; }

segment& operator=(const segment& s);

segment operator+(const vector& v) { return translate(v); }

int operator==(const segment& s) 
{ return (ptr()->start == s.ptr()->start && ptr()->end == s.ptr()->end); }

int operator!=(const segment& s) { return !operator==(s);}

friend ostream& operator<<(ostream& out, const segment& s);
friend istream& operator>>(istream& in, segment& s);

friend void Print(const segment& s, ostream& out = cout) { out << s; } 
friend void Read(segment& s,  istream& in = cin)   { in >> s; }

friend void   Clear(segment& s) { s.clear(); }
friend GenPtr Copy(segment& s)  { s.ptr()->count++; return s.PTR; }
friend segment& Access(const segment&, const GenPtr& p){ return *(segment*)&p; }

};

declare(list,segment)


//------------------------------------------------------------------------------
// SEGMENT(cmp): segments with user defined linear order cmp
//------------------------------------------------------------------------------

#define SEGMENT(cmp) name2(segment_,cmp)

#define SEGMENTdeclare(cmp)\
struct SEGMENT(cmp) : public point \
{  SEGMENT(cmp)(segment  p )         : segment(p)   {}\
   SEGMENT(cmp)(SEGMENT(cmp)& p)     : segment(p)   {}\
   SEGMENT(cmp)() {}\
 ~ SEGMENT(cmp)() {}\
};\
\
int compare(SEGMENT(cmp)& x, SEGMENT(cmp)& y) { return cmp(x,y); }

#endif
