/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  range_tree.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/



//------------------------------------------------------------------
//
// d-dimensional Range Trees
//
// Michael Wenzel     (1990)
//
// Implementation  follows
// Kurt Mehlhorn: Data Structures and Algorithms, Vol.3
//
//------------------------------------------------------------------


#ifndef RANGETREEH
#define RANGETREEH


#include <LEDA/list.h>
#include <LEDA/bb_tree.h>


//------------------------------------------------------------------
// class tuple for range trees
//
// Michael Wenzel          (1990)
//------------------------------------------------------------------


//------------------------------------------------------------------
// class tuple
//------------------------------------------------------------------

class tuple {

friend class range_tree;
friend class rm_tree;

  int d;                              // dimension of tuple
  int vergl_dim;                      // comparision dimension

  GenPtr* t;
  GenPtr  inf;


 void init(int );


 public:

 GenPtr& operator[](int i)  { return t[i];   }
 GenPtr& info()             { return inf; }
 int  dimension()        { return d; }

 int  cmp_dim()      { return vergl_dim;    }
 void set_cmp(int i) { if ((1<=i) && (i<=d)) vergl_dim=i;     }

 tuple();
 tuple(int );
 tuple(GenPtr,GenPtr);
 tuple(GenPtr,GenPtr,GenPtr);
 ~tuple();

 LEDA_MEMORY(tuple)

friend GenPtr Copy(tuple& x) { tuple* y=new tuple; *y=x; return y; }
friend void Clear(tuple& x)  { for (int i=0; i<x.d; i++) Clear(x.t[i]); }

};

typedef tuple* tuplep;
typedef tuple* range_tree_item;
typedef int (*TCMP)(tuplep,tuplep);


// ------------------------------------------------------------------
//  RANGE TREE
// ----------------------------------------------------------------- 

class range_tree;

typedef range_tree* range_p;

//------------------------------------------------------------------------------
// rm_tree = dictionary(tuplep,range_p)  (data structure: bb-alpha tree)
//------------------------------------------------------------------------------


declare(list,range_tree_item);


struct rm_tree : public bb_tree {



int              defined(tuplep y)   { return bb_tree::member(Convert(y)); }
bb_tree_item     lookup(tuplep y)    { return bb_tree::lookup(Convert(y)); }
bb_tree_item     ord(int y)          { return bb_tree::ord(int(y)); }
void             change_inf(bb_tree_item it, range_p i) 
                                     { info(it) = i; }
bb_tree_item     insert(tuplep y,range_p x)
                                       { return bb_tree::insert(Convert(y),Convert(x)); } 
void      del(tuplep y)                { delete bb_tree::del(Convert(y)); } 
void      del_item(range_tree_item it) { del(it); } 
range_p&  info(bb_tree_item it)        { return (range_p&)(bb_tree::info(it)); } 
range_p&  inf(bb_tree_item it)         { return (range_p&)(bb_tree::info(it)); } 

} ;


//------------------------------------------------------------------
// class range_tree
//------------------------------------------------------------------

class range_tree : public rm_tree {

  friend class bb_tree;
  friend class bb_node;

  int     dim;                  // dimension 

  void lrot(bb_item , bb_item);
  void rrot(bb_item , bb_item);
  void ldrot(bb_item , bb_item);
  void rdrot(bb_item , bb_item);
  bool check(tuplep , tuplep , tuplep);

virtual void copy_key(GenPtr& x)  const { x=x; }
virtual void copy_inf(GenPtr& x)  const { x=x; }
virtual void clear_key(GenPtr& x) const { x=0; }
virtual void clear_inf(GenPtr& x) const { x=0; }

virtual int  cmp_tuple_entry(int, tuplep, tuplep) const
{ cout << "error: virtual cmp_tuple_entry\n"; return 0; }

virtual range_tree* new_range_tree(int i) 
{ cout << "error: virtual new_range_tree\n"; i=0; return 0; }

int tuple_cmp(tuplep x, tuplep y) const;

int cmp(GenPtr x, GenPtr y) const { return tuple_cmp(*(tuplep*)&x,*(tuplep*)&y); }

public :

  range_tree_item insert_tuple(tuplep);
  void       del(tuplep);
  tuplep     del_tuple(tuplep);
  void       del_item(range_tree_item it)  { del_tuple(it); } 
  void       query_tuples(tuplep,tuplep,list(range_tree_item)&);

  int dimension()                      { return dim;                 }
  int dimension(bb_tree_item x)        { return key(x)->dimension(); }

  list(range_tree_item) all_tuples();

  tuplep            key(bb_tree_item p)  { return  tuplep(p->key()); }

  range_tree_item   min(int i);
  range_tree_item   max(int i);
				      
  void              init_iterator()    { rm_tree::init_iterator(); }
  bb_tree_item      move_iterator()    { return rm_tree::move_iterator(); }

  void              clear_tuple(tuplep& );
  void              clear();
  void              del_tree(bb_tree_item);

  range_tree(int i)               { dim = i; } 
  ~range_tree();                 


};

#endif

