/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  matrix.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/




//------------------------------------------------------------------------------
//  matrices
//------------------------------------------------------------------------------

#ifndef MATRIXH
#define MATRIXH

#include <LEDA/basic.h>
#include <LEDA/vector.h>


class matrix
{
  vector** v;
  int  d1;
  int  d2;
    
public:

  matrix(int=0, int=0);
  matrix(const matrix&);
  matrix(int,int,double**);

 ~matrix();

  LEDA_MEMORY(matrix)

void check_dimensions(const matrix&) const; 

void flip_rows(int,int);

double& elem(int i, int j) const { return v[i]->v[j]; }

double** triang(const matrix&, int&) const;

public:


matrix(const vector&);

int     dim1()  const  {  return d1; }
int     dim2()  const  {  return d2; }

vector& row(int) const;
vector  col(int i) const;
matrix  trans() const;

matrix  inv()   const;
double  det()   const;

matrix solve(const matrix&) const;
vector solve(const vector& b) const { return solve(matrix(b)); }

operator vector() const; 

matrix& operator=(const matrix&);

int     operator==(const matrix&)    const;
int     operator!=(const matrix& x)  const { return !(*this == x); }

vector& operator[](int i)    const { return row(i); }
double& operator()(int, int);

//double  operator()(int i, int j) const { return operator()(i,j); };

matrix operator+(const matrix&);
matrix operator-(const matrix&);

matrix operator*(double);
matrix operator*(const matrix&);
vector operator*(const vector& v) { return vector(*this * matrix(v)); }

friend ostream& operator<<(ostream&, const matrix&);
friend istream& operator>>(istream&, matrix&);

friend void Print(const matrix& M, ostream& out=cout) { out << M; } 
friend void Read(matrix& M, istream& in=cin)  { in >> M; }

friend void   Init(matrix& M)  { M = matrix(0,0); }
friend void   Clear(matrix& M) { delete (matrix*)&M; }
friend GenPtr Copy(matrix& M)  { return new matrix(M); }
friend GenPtr Convert(matrix& x) { return &x; }
friend matrix& Access(const matrix&, GenPtr p) { return *(matrix*)p; }
friend int compare(const matrix&, const matrix&) { return 0; }

};


//------------------------------------------------------------------------------
// MATRIX(cmp): vector with user defined linear order cmp
//------------------------------------------------------------------------------

#define MATRIX(cmp) name2(matrix_,cmp)

#define MATRIXdeclare(cmp)\
struct MATRIX(cmp) : public matrix \
{  MATRIX(cmp)(int d1, int d2) :(d1,d2) {}\
   MATRIX(cmp)(matrix  m )     :(m)     {}\
   MATRIX(cmp)(MATRIX(cmp)& m) :(m)     {}\
   MATRIX(cmp)() {}\
 ~ MATRIX(cmp)() {}\
};\
\
int compare(const MATRIX(cmp)& x, const MATRIX(cmp)& y) { return cmp(x,y); }

#endif
