/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  hash.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/




//------------------------------------------------------------------------------
// hash dictionary (data structure: hashing with chaining)
//------------------------------------------------------------------------------

#ifndef HASHH
#define HASHH

#include <LEDA/ch_hashing.h>

typedef ch_hashing_el* hash_item;

#define HFCT(keytype,inftype)  name3(keytype,inftype,_hashfct)
#define HFCTC(keytype,inftype)  name3(keytype,inftype,c_hashfct)


#define hash_body(keytype,inftype): public ch_hashing {\
\
typedef int (*HFCT(keytype,inftype))(keytype&);\
typedef int (*HFCTC(keytype,inftype))(const keytype&);\
\
\
keytype name2(keytype,X1);\
inftype name2(inftype,X2);\
\
HFCT(keytype,inftype) hash_ptr;\
\
int  hash_fct(GenPtr x) const\
{ return (hash_ptr) ? (*hash_ptr)(ACCESS1(keytype,x)) : int(x); }\
\
int  cmp(GenPtr x, GenPtr y) const\
                    { return compare(ACCESS1(keytype,x),ACCESS1(keytype,y)); }\
void clear_key(GenPtr& x)   const { Clear(ACCESS1(keytype,x)); }\
void clear_inf(GenPtr& x)   const { Clear(ACCESS2(inftype,x)); }\
void copy_key(GenPtr& x)    const { x=Copy(ACCESS1(keytype,x)); }\
void copy_inf(GenPtr& x)    const { x=Copy(ACCESS2(inftype,x)); }\
void print_key(GenPtr& x)   const { Print(ACCESS1(keytype,x),cout); }\
\
public:\
\
int        defined(keytype y) const { return ch_hashing::member(Convert(y)); }\
hash_item  lookup(keytype y)  const { return ch_hashing::lookup(Convert(y)); }\
void       change_inf(hash_item it, inftype i)\
                                    { ch_hashing::change_inf(it,Convert(i)); }\
hash_item  insert(keytype y,inftype x)\
                                    { return ch_hashing::insert(Convert(y),Convert(x));}\
void      del(keytype y)            { ch_hashing::del(Convert(y)); } \
void      del_item(hash_item it)    { del(key(it)); } \
keytype   key(hash_item it)   const { return ACCESS1(keytype,ch_hashing::key(it)); }\
inftype  inf(hash_item it)   const { return ACCESS2(inftype,ch_hashing::inf(it)); } \
inftype  info(hash_item it)  const { return ACCESS2(inftype,ch_hashing::inf(it)); } \
\
_hash(keytype,inftype)()                          { hash_ptr=0;}\
_hash(keytype,inftype)(HFCT(keytype,inftype) f)   { hash_ptr=f;}\
_hash(keytype,inftype)(HFCTC(keytype,inftype) f)\
{ hash_ptr=(HFCT(keytype,inftype))f;}\
_hash(keytype,inftype)(int s)                     :ch_hashing(s) { hash_ptr=0;}\
_hash(keytype,inftype)(int s, HFCT(keytype,inftype) f) :ch_hashing(s){ hash_ptr=f;}\
_hash(keytype,inftype)(int s, HFCTC(keytype,inftype) f) :ch_hashing(s) \
{ hash_ptr=(HFCT(keytype,inftype))f;}\
~_hash(keytype,inftype)()   { remove(); }\
} ;


#ifdef __TEMPLATES__
#define _hash(K,I) hash
template<class K, class I> class hash hash_body(K,I)

#else
#define _hash(K,I) name3(K,I,hash)
#define hash(K,I) name3(K,I,hash)
#define hashdeclare2(K,I) class hash(K,I) hash_body(K,I)

#endif

// ----------------------------------------------------------------
// iteration
// ----------------------------------------------------------------

#define forall_hash_items(i,D) for((D).init_iterator(); i=(D).move_iterator();)

#endif
