/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  dictionary.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/





//------------------------------------------------------------------------------
// Dictionary  (data structure: red black trees)
//------------------------------------------------------------------------------

#ifndef DICTIONARYH
#define DICTIONARYH

#include <LEDA/rb_tree.h>

typedef rb_tree_node* dic_item;

#define dictionary_body(keytype,inftype) : public rb_tree {\
\
keytype name2(keytype,X1);\
inftype name2(inftype,X2);\
\
int  cmp(GenPtr x, GenPtr y) const\
                     { return compare(ACCESS1(keytype,x),ACCESS1(keytype,y)); }\
void clear_key(GenPtr& x)   const { Clear(ACCESS1(keytype,x)); }\
void clear_inf(GenPtr& x)   const { Clear(ACCESS2(inftype,x)); }\
void copy_key(GenPtr& x)    const { x = Copy(ACCESS1(keytype,x)); }\
void copy_inf(GenPtr& x)    const { x = Copy(ACCESS2(inftype,x)); }\
\
public:\
\
keytype   key(dic_item it)  const { return ACCESS1(keytype,rb_tree::key(it)); }\
inftype   inf(dic_item it)  const { return ACCESS2(inftype,rb_tree::info(it));}\
inftype   access(keytype k) const { return inf(lookup(k));}\
\
dic_item  lookup(keytype y)  const { return rb_tree::lookup(Convert(y)); }\
bool      defined(keytype y) const { return (lookup(y)==nil) ? false : true; }\
void      change_inf(dic_item it, inftype i) { ACCESS2(inftype,info(it)) = i; }\
\
dic_item  insert(keytype x, inftype y)\
                             { return rb_tree::insert(Convert(x),Convert(y)); }\
\
void      del(keytype y)         { rb_tree::del(Convert(y)); } \
void      del_item(dic_item it)  { del(key(it)); } \
int       size()            const { return rb_tree::size(); }\
bool      empty()           const { return (size()==0) ? true : false; }\
\
_dictionary(keytype,inftype)& operator =(const _dictionary(keytype,inftype)& D)\
{ return (_dictionary(keytype,inftype)&)rb_tree::operator=(rb_tree((rb_tree&) D)); }\
\
 _dictionary(keytype,inftype)()   {}\
 _dictionary(keytype,inftype)(const _dictionary(keytype,inftype)& D) :\
  rb_tree((rb_tree&) D)   {}\
~_dictionary(keytype,inftype)()   { clear(); }\
} ;


#ifdef __TEMPLATES__

#define _dictionary(K,I) dictionary
template<class K, class I> class dictionary dictionary_body(K,I)

#else

#define _dictionary(K,I) name3(K,I,dictionary)
#define dictionary(K,I) name3(K,I,dictionary)
#define dictionarydeclare2(K,I) class dictionary(K,I) dictionary_body(K,I)\

#endif



// ----------------------------------------------------------------
// iteration
// ----------------------------------------------------------------

#define forall_dic_items(i,D) for(i = (D).first_item(); i; i=(D).next_item(i))

#endif
