#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine LineTp (term, NumCrv)

*************************************************************
*                                                           *
*  User_defined_Line_types                                  *
*                                                           *
*     This subroutine allows the user to define the         *
*     plot by setting the line type.  The user may choose   *
*     between a solid, dash, dot, or dash-dot line.  This   *
*     option allows the user to distinguish between         *
*     multiple plots.                                       *
*                                                           *
*************************************************************

        Integer term, NumCrv, I

        Integer        CType(3)
        Common /lntyp/ CType
        Save   /lntyp/

        DO 100 I = 1, NumCrv
    1     Call clear(term)
          Write (*,10) I
   10     Format(/,15x,'Specify Line Types',///
     +             , 5x,'The following line types are available:',//
     +             ,10x,'1.  Solid              ',//
     +             ,10x,'2.  Dot                ',//
     +             ,10x,'3.  Dot - Dash         ',//
     +             ,10x,'4.  Short - Dash       ',//
     +             ,10x,'5.  Long - Dash        ',//
     +             , 5x,'Enter option (1 - 5) for curve ',i1,' ...')
          Read(*,'(i3)',err=1) CType(I)

  200     IF (CType(I) .LT. 1 .OR. CType(I) .GT. 5) THEN
    2       Call clear(term)
            Write (*,'(a1)') Char(7)
            Write (*,10) I
            Read(*,'(i3)',err=2) CType(I)
            GOTO 200
          ENDIF
  100   Continue

        RETURN
        END
