 /*
  * Khoros: $Id: vgauss.h,v 1.2 1991/12/18 09:41:43 dkhoros Exp $
  */

 /*
  * $Log: vgauss.h,v $
 * Revision 1.2  1991/12/18  09:41:43  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vgauss.h
 >>>>            Author: Scott Wilson
 >>>> Date Last Updated: Mon Dec  9 23:22:22 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vgauss_h_
#define _vgauss_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    vgauss Argument Structure
*
****************************************************************/

typedef struct _vgauss  {

/*
 *  output image (Required outfile)
 */
char	*o_file;	/* output image FILENAME */
int	 o_flag;	/* output image FLAG */

/*
 *  trigger input (Optional infile)
 */
char	*trigger_file;	/* trigger input FILENAME */
int	 trigger_flag;	/* trigger input FLAG */

/*
 *  Number of Columns (Optional integer)
 */
int	 c_int; 	/* Number of Columns INT */
int	 c_flag;	/* Number of Columns FLAG */

/*
 *  Number of rows (Optional integer)
 */
int	 r_int; 	/* Number of rows INT */
int	 r_flag;	/* Number of rows FLAG */

/*
 *  X peak location (Optional float)
 */
float	 x_float;	/* X peak location FLOAT */
int	 x_flag;   	/* X peak location FLAG */

/*
 *  Y peak location (Optional float)
 */
float	 y_float;	/* Y peak location FLOAT */
int	 y_flag;   	/* Y peak location FLAG */

/*
 *  X variance (Optional float)
 */
float	 vx_float;	/* X variance FLOAT */
int	 vx_flag;   	/* X variance FLAG */

/*
 *  Y variance (Optional float)
 */
float	 vy_float;	/* Y variance FLOAT */
int	 vy_flag;   	/* Y variance FLAG */

/*
 *  Rotation angle (Optional float)
 */
float	 ra_float;	/* Rotation angle FLOAT */
int	 ra_flag;   	/* Rotation angle FLAG */

/*
 *  Peak Amplitude (Optional float)
 */
float	 amp_float;	/* Peak Amplitude FLOAT */
int	 amp_flag;   	/* Peak Amplitude FLAG */

/*
 *  Parameters input image (Optional infile)
 */
char	*p_file;	/* Parameters input image FILENAME */
int	 p_flag;	/* Parameters input image FLAG */

/*
 *  Normalize Gaussian(s) (Optional logical)
 */
int	 n_logic;	/* Normalize Gaussian(s) LOGIC */
int	 n_flag;  	/* Normalize Gaussian(s) FLAG */

}  vgauss_struct;

vgauss_struct *vgauss;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
