 /*
  * Khoros: $Id: lvlayer.c,v 1.1 1991/05/10 15:43:20 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvlayer.c,v 1.1 1991/05/10 15:43:20 khoros Exp $";
#endif

 /*
  * $Log: lvlayer.c,v $
 * Revision 1.1  1991/05/10  15:43:20  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvlayer.c
 >>>>
 >>>>      Program Name: vlayer
 >>>>
 >>>> Date Last Updated: Sun Mar  3 14:15:21 1991 
 >>>>
 >>>>          Routines: lvlayer - the library call for vlayer
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvlayer - library call for vlayer
*
* Purpose:
*    
*    Converts a multiband BIT image to a single band byte image.
*    
*    
* Input:
*    
*    image          the input xvimage structure to the  multiband  BIT
*                   image.
*    
*    img_list       a list of images for conversion to a BYTE image.
*    
*    
* Output:
*    
*    newimage       the resulting xvimage structure to the BYTE image.
*    
*    
*
* Written By: Charlie Gage
*    
*    
****************************************************************/


/* -library_def */
int
lvlayer(image, newimage, img_list)
struct xvimage  *image, **newimage;
int  *img_list;
/* -library_def_end */

/* -library_code */
{
  struct xvimage *tmpimage, *createimage();

  int i,                       /* counters */
      j,
      k,
      p,
      r,
      index,
      num_bytes,               /* number of Bytes per row of input image */
      num_bands,               /* number of bands in input BIT image */
      nc,                      /* number of columns in image */
      nr,                      /* number of rows in image */
      band_num,                /* current band number */
      map_rows,                /* number of ROWS in map */
      map_cols;                /* number of COLS in map */


  unsigned char  *c1,          /* pointer to input image data */
                 *c2,          /* pointer to output image data */
                 *result,      /* pointer to resulting image char */
                 *result_map,  /* pointer to output image map data */
                 *m1,          /* pointer to input image map data */
                 x,            /* used for shifting bits */
                 mask;         /* mask to test leftmost bit of a byte */

  char  *malloc(),             /* function definition */
        *program = "lvlayer";  /* contains the library name */

  /* Check for proper input image */
  if (!propertype (program, image, VFF_TYP_BIT, FALSE))
  {
     (void) fprintf (stderr,
     "lvlayer: ERROR, Input image must be of data type BIT\n");
     return(0);
  }

  /* Check for proper map types */
  if ( (!proper_map_scheme(program, image, VFF_MS_ONEPERBAND, FALSE)) && (!proper_map_scheme(program, image, VFF_MS_SHARED, FALSE)) && (!proper_map_scheme(program, image, VFF_MS_NONE, FALSE)) )
    {
     (void) fprintf(stderr, "lvlayer: ERROR Can only work on map scheme ONEPERBAND,\n");
     (void) fprintf(stderr, "         SHARED, or NONE.\n");
      return(0);
    }

  /* Check to make sure that number of bands doesn't exceed 256,
     since there are only 256 different colors in X11 */
  num_bands = image->num_data_bands;
  if (num_bands > 256)
  {
     fprintf(stderr,"lvlayer: Number of bands (colors) exceeds 256\n");
     return(0);
  }
  
  /* Check to make sure row size of input image falls on a BYTE boundary */
  if ((image->row_size % 8) != 0)
  {
    (void) fprintf(stderr, "\nlvlayer: ERROR Number of columns in input image");
    (void) fprintf(stderr, "\ndoes not fall on a BYTE boundary!");
    return(0);
  }

  mask = 1;                      /* mask = 00000001 - only test first bit */
                              /* Note: Bytes are packed in reverse order. */
  nc = image->row_size;          /* number of cols in image */
  nr = image->col_size;          /* number of rows in image */
  band_num = 1;
  num_bytes = (image->row_size + 7)/8;  /* find number of bytes in each row */
  map_rows = num_bands + 1;  /* number of rows in map (ie. number of colors) */
  map_cols = image->map_row_size;  /* number of cols (ie. 3 - r g b) */

                    /* Create a VIFF image */
  tmpimage = createimage(nr,                    /* number of rows in image */
                         nc,                    /* number of cols in image */
                         VFF_TYP_1_BYTE,        /* data_storage_type */
                         (unsigned long) 1,     /* num_of_images */
                         (unsigned long) 1,     /* num_data_bands */
                         "created by vlayer",   /* comment */
                         (unsigned long) map_cols, /* map_row_size */
                         (unsigned long) map_rows, /* map_col_size */
                         VFF_MS_ONEPERBAND,     /* map_scheme */
                         image->map_storage_type,
                         image->location_type,
                         image->location_dim);
 
  if (tmpimage == NULL)
  {
    (void) fprintf(stderr,"lvlayer: insufficient memory available for newimage\n");
    return(0);
  }

                    /* Assign pointers to image and map data areas */
  result = (unsigned char *) tmpimage->imagedata;
  result_map = (unsigned char *) tmpimage->maps;

                    /* Set output image to all zeros */
  bzero((unsigned char *) result, nr * nc * sizeof(char));
  
                    /* Set output map to all zeros */
                    /* Note that this sets the first entry (BIT 0) of 
                       the output color map to all zeros or black.  */
  bzero((unsigned char *) result_map, map_rows * map_cols * sizeof(char));

                    /* Copy map data from input image to output image */
                    /* Only need to copy map data corresponding to BIT 1 */
  m1 = (unsigned char *)(image->maps);
  if (image->map_scheme == VFF_MS_SHARED)
  {
    for (i=0; i < num_bands; i++)
    {
      p = 1;        /* initialize loop counter */
      for (j=0; j < map_cols; j++)
      {
        m1++;       /* Skip first entry of color map corresponding to BIT 0 */
                    /* Copy color attribute corresponding to binary 1 */
        index = i + (j*num_bands) + p;
        result_map[index] = *m1;
        m1++;       /* increment pointer to map data */
        p++;
      }
    m1 = (unsigned char *)(image->maps);  /* reset pointer to start of input map */
    }
  }
  else if (image->map_scheme == VFF_MS_ONEPERBAND)
  {
    for (i=0; i < num_bands; i++)
    {
      p = 1;        /* initialize loop counter */
      for (j=0; j < map_cols; j++)
      {
        m1++;       /* Skip first entry of color map corresponding to BIT 0 */
                    /* Copy color attribute corresponding to binary 1 */
        index = i + (j*num_bands) + p;
        result_map[index] = *m1;
        m1++;       /* always increment pointer to next map data */
        p++;
      }
    }
  }
  else              /* map_scheme VFF_MS_NONE */
  {
    for (j=0; j < map_cols; j++)     /* Loop thru each col of map */
    {
      result_map++;   /* Skip first entry of color map corresponding to BIT 0 */
      for (i=0; i < num_bands; i++)  /* Loop thru each row of map */
      {
                    /* Compute color attribute for each band */
        *result_map = ((i+1)/(num_bands-1)) * 255;
        result_map++;       /* increment pointer to map data */
      }
    }
  }

                    /* Set char pointer to first byte in input image */
  c1 = (unsigned char *)(image->imagedata);
                  
  c2 = &result[0];  /* Set char pointer to first byte of output image */

                    /* Loop thru each BAND of input image */
  for (i=0; i < num_bands; i++)
  {
     if (img_list != NULL)
     {
        if (img_list[i] == 0)
        {
           band_num++;               /* Increment band counter */
           c2 = &result[0];          /* reset pointer to beginning of output image */
           c1 += num_bytes*image->col_size;
           continue;
        }
     }
                    /* Loop thru each ROW of input image */
     for (r=0; r < image->col_size; r++)
     {
                    /* Loop thru each BYTE of row (ie. each COL) input image */
      for (j=0; j < num_bytes; j++)
      {
        x = *c1;
        for (k=0; k < 8; k++)   /* Cycle thru each BIT of input Byte */
        {
           if ((x & mask) != 0)  /* Assign data if bit is not 0 */
           {
             *c2 = band_num;    /* Assign current band_num to output image */
           }
           x >>= 1;             /* Right shift each bit of input Byte */
           c2++;                /* Increment char pointer to output image */
        }
        c1++;                   /* Increment pointer to next Byte of input image */
      }
     }
     band_num++;               /* Increment band counter */
     c2 = &result[0];          /* reset pointer to beginning of output image */
  }
 
  *newimage = tmpimage;      /* Assign new data to new image pointer */

  return(1);

}  /*** End of lvlayer ***/
/* -library_code_end */
