 /*
  * Khoros: $Id: vll2utm.c,v 1.1 1991/05/10 15:52:51 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vll2utm.c,v 1.1 1991/05/10 15:52:51 khoros Exp $";
#endif

 /*
  * $Log: vll2utm.c,v $
 * Revision 1.1  1991/05/10  15:52:51  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vll2utm.c
 >>>>
 >>>>      Program Name: vll2utm
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Convert explicit location data from geographical coordinates
 >>>>	to utm.
 >>>>	
 >>>>	
 >>>>            Author: Per Lysne
 >>>>
 >>>> Date Last Updated: Thu Mar  7 13:32:29 1991
 >>>>
 >>>>          Routines: main- the main program for vll2utm
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vll2utm.h"


/****************************************************************
 *
 * Routine Name:  main program for vll2utm
 *
 *       Input:  
 *         -i  input file 
 *         -o  output file 
 *
 *
 *         [-s] Locations in seconds or degrees (1=seconds)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *img, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);

    img = readimage(vll2utm->i_file);
    if (img == NULL) {
        fprintf (stderr, "error in vll2utm: could not read image from %s\n",
                 vll2utm->i_file);
        exit (1);
    }

    CHECKINPUT (program, img);
/* -main_before_lib_call_end */

/* -main_library_call */
    if (!lvll2utm (img, vll2utm->s_logic)) {
        fprintf (stderr, "error in vll2utm: call to lvll2utm failed\n");
        exit (1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    if (!writeimage (vll2utm->o_file, img)) {
        fprintf (stderr,"error in vll2utm: could not write output image to: ");
        fprintf (stderr, " %s\n", vll2utm->o_file);
        exit (1);
    }
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vll2utm 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vll2utm :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tConvert explicit location data from geographical coordinates\n");
	fprintf(stderr, "\tto utm.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input file  (infile)\n");
	fprintf(stderr,"\t-o  output file  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-s]  Locations in seconds or degrees (1=seconds) (boolean) [true]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vll2utm\n");
	fprintf(stderr, "\t[-U] Gives the usage for vll2utm\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vll2utm.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vll2utm.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vll2utm
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input file \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output file \n        {outfile}: "; 
char	*s_pstr = 
	"\nEnter: (s) Locations in seconds or degrees (1=seconds) \n        {boolean, (y/n)  [yes] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vll2utm", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vll2utm.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vll2utm: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vll2utm.ans");
		}

	     }

	}

	/*
	 * allocate the vll2utm structure
	 */
	vll2utm = (vll2utm_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vll2utm_struct));

	/*
	 * get required arguments for vll2utm
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vll2utm->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vll2utm->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vll2utm->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vll2utm->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vll2utm->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vll2utm->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vll2utm->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vll2utm->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vll2utm->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vll2utm->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vll2utm
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vll2utm->s_flag = vget_logic(fid, prompt_flag,
	"-s", s_pstr, &(vll2utm->s_logic), 1);


}



