 /*
  * Khoros: $Id: ltga2viff.c,v 1.2 1991/10/02 00:29:50 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: ltga2viff.c,v 1.2 1991/10/02 00:29:50 khoros Exp $";
#endif

 /*
  * $Log: ltga2viff.c,v $
 * Revision 1.2  1991/10/02  00:29:50  khoros
 * HellPatch2
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: ltga2viff.c
 >>>>
 >>>>      Program Name: tga2viff
 >>>>
 >>>> Date Last Updated: Thu Aug 22 13:20:59 1991 
 >>>>
 >>>>          Routines: ltga2viff - the library call for tga2viff
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
#include "file_formats/tga.h"
/* -library_includes_end */


/****************************************************************
*
* Routine Name: ltga2viff - library call for tga2viff
*
* Purpose:
*    
*    Takes  a  tga  structure  an  convert  it  into  a   xvimage
*    structure.   Only  the  tga  image  type  1,  2  and  3  are
*    converted.
*    
*    

* Input:
*    
*         *tga_image _ a tga structure
*    
*         **image    _ a pointer on a xvimage
*    
*    

* Output:
*    
*         returns FALSE upon failure and TRUE upon sucess.
*    
*    

*
* Written By: Pascal ADAM
*    
*    

****************************************************************/


/* -library_def */
int
ltga2viff(tga_image,image)
tga *tga_image;
struct xvimage **image;
/* -library_def_end */

/* -library_code */
{
#define TGA_H         tga_image -> tgaheader
#define TGA_F         tga_image -> tgafooter
#define TGA_ID        tga_image -> imageidentifier
#define TGA_MAP       tga_image -> colormapdata
#define TGA_IMA       tga_image -> imagedata
#define TGA_DEVF      tga_image -> dev_fields
#define TGA_DEVD      tga_image -> dev_dir
#define TGA_EXT       tga_image -> tgafixedextarea
#define TGA_SCAN      tga_image -> scan_line_table
#define TGA_COL       tga_image -> col_corr_table

#define WIDTH         TGA_H . width 
#define HEIGHT        TGA_H . height
#define PIX_TYP       TGA_H . pix_size
#define IMA_DESC      TGA_H . ima_descript

#define TGA_1_BYTE      8
#define TGA_2_BYTE     16
#define TGA_3_BYTE     24
#define TGA_4_BYTE     32 

#define IMA_ORI_MASK   0x30   
#define ALP_CHA_MASK   0x0F

#define NO_COL_MAP    0
#define COL_MAP       1

/*
** The way the image is stored (bottom-left ....
** ...top-right) is not carried here............
#define BOTTOM_LEFT    0x00
#define BOTTOM_RIGHT   0x10
#define TOP_LEFT       0x20
#define TOP_RIGHT      0x30
**
*/

struct xvimage  *createimage();

unsigned char *c_viff, *c_tga;
short         *s_viff, *s_tga;
long          *l_viff, *l_tga;

int i,j,k;

unsigned
long    col_size,
        row_size,
        data_storage_type,
        num_of_images,
        num_data_bands,
        map_row_size,
        map_col_size,
        map_scheme,
        map_storage_type,
        color_space_model,
        location_type,
        location_dim,
        pix_depth;
char    *comment;

        /* checks the type of image data */
        switch (TGA_H . ima_typ_code) {

           case UNCOMP_RGB:
/*
              if (TGA_H . col_map_typ != NO_COL_MAP) {
                 (void) fprintf(stderr,
                 "An Uncompressed B&W Image Color Map Should Be Set To 0 !\n");
                 return(FALSE);
                 }
*/
              map_row_size = map_col_size = 0;
              map_scheme   = VFF_MS_NONE;
              num_of_images = 1;
              map_storage_type = VFF_MAPTYP_NONE;
              color_space_model= VFF_CM_ntscRGB;
              num_data_bands= 3;
             
              break;

           case UNCOMP_B_W:
 /*         
              if (TGA_H . col_map_typ != NO_COL_MAP) {
                 (void) fprintf(stderr,
                 "An Uncompressed B&W Image Color Map Should Be Set To 0 !\n");
                 return(FALSE);
                 }
*/
              map_row_size = map_col_size = 0;
              map_scheme   = VFF_MS_NONE;
              map_storage_type = VFF_MAPTYP_NONE;
              color_space_model = VFF_CM_NONE;
              break;

           case UNCOMP_COL_MAP:
           case NODATA :
           case R_L_ENCODED_COL_MAP :
           case R_L_ENCODED_RGB :
           case COMP_B_W :
           case COMP_COL_MAP :
           case COMP_COL_MAP_4 :
           default :
              (void) fprintf(stderr,
              "Tga2viff doesn't know this tga image data type !\n");
              return(FALSE);
              break;
           }

        /* fills basic viff image field before create image */ 
        col_size = HEIGHT;
        row_size = WIDTH ;
        comment  = TGA_ID;


        /* checks the number of Alpha-channel bits per pixel 
         * Has to be 0, Not processed yet !
         */
        if ((IMA_DESC & ALP_CHA_MASK) != 0) {
           (void) fprintf(stderr,
           "Tga2viff doesn't know how to process Alpha Chanel bits !\n");
           return(FALSE);
           }
 
        /* processes the pixel size. !!!!!!!!!!!!!!!
         * ATTENTION If someone implement the ALPHA CHANNEL bits
         * This part will have to be re-analysed.
         */
        if (color_space_model == VFF_CM_NONE) {
           switch (PIX_TYP) {
              case TGA_1_BYTE : 
                 data_storage_type = VFF_TYP_1_BYTE;
                 break;
              case TGA_2_BYTE :
                 data_storage_type = VFF_TYP_2_BYTE;
                 break;
              case TGA_4_BYTE :
                 data_storage_type = VFF_TYP_4_BYTE;
                 break;
              default:         
                 (void) fprintf(stderr,
                 "Tga2viff doesn't handle this Pixel Depth !\n");
                 return(FALSE);
              }
           }
        
        if (color_space_model == VFF_CM_ntscRGB) {
           switch (PIX_TYP) {
              case TGA_1_BYTE :
                 data_storage_type = VFF_TYP_1_BYTE;
                 break;
              case TGA_2_BYTE :
                 data_storage_type = VFF_TYP_1_BYTE;
                 break;
              case TGA_3_BYTE :
                 data_storage_type = VFF_TYP_1_BYTE;
                 break;
              case TGA_4_BYTE :
                 data_storage_type = VFF_TYP_1_BYTE;
                 break;
              default:
                 (void) fprintf(stderr,
                 "Tga2viff doesn't handle this Pixel Depth !\n");
                 return(FALSE);
              }
           }

        location_type = VFF_LOC_IMPLICIT;
  
        location_dim  = 0;

        *image = createimage(col_size, 
                             row_size, 
                             data_storage_type, 
                             num_of_images, 
                             num_data_bands,
                             comment,
                             map_row_size,
                             map_col_size,
                             map_scheme,
                             map_storage_type,
                             location_type,
                             location_dim);
        if (*image == NULL) {
           (void) fprintf(stderr,
           "ltga2viff: createimage failed !\n");
           return(FALSE);
           }
         
        /* attach the color space model if it exists */
        (*image) -> color_space_model = color_space_model; 

        /* the viff header and the structure has been created
         * now we have to copy the image data................
         */
        
        if (color_space_model == VFF_CM_NONE) {
           switch (PIX_TYP) {
              case TGA_1_BYTE:
                 c_viff = (unsigned char *) (*image)->imagedata;
                 c_tga  = (unsigned char *) TGA_IMA;

                 for (i=0;i < row_size*col_size;i++) c_viff[i] = c_tga[i];

                 break;

              case TGA_2_BYTE:
                 s_viff = (short *) (*image)->imagedata;
                 s_tga  = (short *) TGA_IMA;

                 for (i=0;i < row_size*col_size; i++) s_viff[i] = s_tga[i];

                 break;

              case TGA_4_BYTE:
                 l_viff = (long  *) (*image)->imagedata;
                 l_tga  = (long  *) TGA_IMA;

                 for (i=0;i < row_size*col_size; i++) l_viff[i] = l_tga[i];

                 break;
              }
           }
  
        else if (color_space_model == VFF_CM_ntscRGB) {

           c_viff = (unsigned char *) (*image)->imagedata;
           c_tga  = (unsigned char *) TGA_IMA;

           k = row_size*col_size; j = 2*k;

           switch(PIX_TYP) {
              case 24: 
                 if ((IMA_DESC & ALP_CHA_MASK) != 0) {
                    (void) fprintf(stderr,
                    "ltga2viff: Don't know how to convert this RGB image!\n");
                    return(FALSE);
                    }
                 else {
                    for (i=0;i < row_size*col_size;i++) {
                        c_viff[i] = *(c_tga++);
                        c_viff[i+k] = *(c_tga++);
                        c_viff[i+j] = *(c_tga++);
                        }
                    }
                 break;
 
              case 32:
/*
                 if ((IMA_DESC & ALP_CHA_MASK) != 8) {
                    (void) fprintf(stderr,
                    "ltga2viff: Don't know how to convert this RGB image!\n");
                    return(FALSE);
                    }
                 else {
*/ 
                    for (i=0;i < row_size*col_size;i++) {
                        c_viff[i] = *(c_tga++);
                        c_viff[i+k] = *(c_tga++);
                        c_viff[i+j] = *(c_tga++);
                        c_tga++;
                        }
/*
                     }
*/
                  break;
              default:
                 (void) fprintf(stderr,
                    "ltga2viff: Don't know how to convert this RGB image!\n");
                    return(FALSE);
              } 
           }
        return(TRUE);
}
/* -library_code_end */
