 /*
  * Khoros: $Id: texted.c,v 1.3 1991/12/18 09:58:32 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: texted.c,v 1.3 1991/12/18 09:58:32 dkhoros Exp $";
#endif

 /*
  * $Log: texted.c,v $
 * Revision 1.3  1991/12/18  09:58:32  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "ghost.h"
#include "vinclude.h"

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>      Ghostwriter Text Editing Routines       	      <<<<
   >>>>                                                       <<<<
   >>>>  File Name: texted.c				      <<<<
   >>>>                                                       <<<<
   >>>>          get_text_lines()                             <<<<
   >>>>          add_gw_format()                              <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/************************************************************
*
*  Routine Name: get_text_lines()
*
*      Purpose:  This routine takes a text block, and 
*		 returns a pointer to an array of strings. 
*		 If (text_formatter) is specified as NROFF, the
*		 original text is formatted by nroff, and outputted
*		 as a formatted array of strings without the nroff commands.
*		 If (text_formatter) is specified as NONE, the original
*		 text is simply broken into it's separate lines.
*		 
*
*	  Input:  text_block - the original text block 
*
*        Output:  text_strings - array of strings, either formatted with
*		                 nroff, or not, according to (text_formatter).
*
*   Written By:  Danielle Argiro 
*
*************************************************************/

char **get_text_lines(text_block, text_formatter)
char *text_block;
int  text_formatter;
{
    int  i;
    FILE *file;
    char *tmpfile1, *tmpfile2;
    char cmd[512], temp[512]; 
    char **textlines;

    textlines = (char **) calloc(1,sizeof(char *)*MaxTextBlock);
    for (i=0; i< MaxTextBlock; i++) textlines[i] = NULL;

    /* open temp file & write out original text block */
    tmpfile1 = vtempnam("original");
    if (!(file = fopen(tmpfile1, "w")))
    {
        fprintf(stderr, "\nget_text_lines: \n");
        fprintf(stderr, "Error: unable to write temp file\n");
        return(NULL);
    }
    if (text_formatter == NROFF_FORMATTER)
        fprintf(file, ".ND\n.nr LL 6.5i\n");
    fprintf(file, "%s", text_block);
    fclose(file);

    /* format text block in temp file with nroff back into temp file */
    tmpfile2 = vtempnam("formatted");
    if (text_formatter == NROFF_FORMATTER)
    {
        if (tmpfile2 != NULL)
        {
            sprintf(cmd, "nroff -ms %s | sed -e s/.\\^H//g | cat -s > %s", 
		     tmpfile1, tmpfile2);
           system(cmd);
        }
        if (!(file = fopen(tmpfile2, "r")))
        {
           fprintf(stderr, "\nget_text_lines: \n");
           fprintf(stderr, "Error: unable to open temp file \n");
           return(NULL);
        }
    }
    else if (text_formatter == NO_TEXT_FORMATTER)
    {
        if (!(file = fopen(tmpfile1, "r")))
        {
           fprintf(stderr, "\nget_text_lines: \n");
           fprintf(stderr, "Error: unable to open temp file \n");
           return(NULL);
        }
    }

    i = 0;
    while (!(feof(file)))
    {
	fgets(temp, MaxLineLength, file);
        if (VStrlen(temp) > 0)
            textlines[i++] = VStrcpy(temp);
    }
    fclose(file);

    sprintf(cmd, "/bin/rm %s", tmpfile1);
    system(cmd);

    if (text_formatter == NROFF_FORMATTER)
    {
        sprintf(cmd, "/bin/rm %s", tmpfile2);
        system(cmd);
    }
    return(textlines);
    
}

    

/************************************************************
*
*  Routine Name: add_gw_format()
*
*      Purpose:  This routine takes an array of strings (output by
*		 get_text_lines()) and adds appropriate formatting as
*		 specified by append_string.  It returns a pointer to 
*		 a solid text block. 
*
*        Input:  text_strings - array of strings produced by get_text_lines()
*
*	Output:  text_block -  a solid text block with header formatting
*
*   Written By:  Danielle Argiro 
*
*************************************************************/

char *add_gw_format(textlines, append_string)
char **textlines;
char *append_string;
{
     int  i;
     char *text_block;
     char temp1[MaxTextBlock*MaxLineLength], temp2[MaxTextBlock];

     i = 0;
     temp1[0] = '\0';
     while (textlines[i] != NULL)
     {
         if (append_string != NULL)
            sprintf(temp2, "%s%s", append_string, textlines[i]);
	 else 
            sprintf(temp2, "%s", textlines[i]);
         strcat(temp1, temp2);
         i++;
     }
     text_block = VStrcpy(temp1);
     return(text_block);
}

/************************************************************
*
*  Routine Name: delete_gw_format()
*
*      Purpose:  This routine takes an array of strings (output by
*		 get_text_lines()) and deletes any formatting as
*		 specified by append_string.  It returns a pointer to 
*		 a solid text block. 
*
*        Input:  text_strings - array of strings produced by get_text_lines()
*
*	Output:  text_block -  a solid text block with header formatting
*
*   Written By:  Danielle Argiro 
*
*************************************************************/

char *delete_gw_format(textlines, delete_string, num_chars)
char **textlines;
char *delete_string;
int   num_chars;
{
     int  i;
     char *text_block;
     char temp1[MaxTextBlock*MaxLineLength], temp2[MaxTextBlock];

     i = 0;
     temp1[0] = '\0';
     while (textlines[i] != NULL)
     {
	     if (VStrncmp(textlines[i], delete_string, num_chars) == 0)
	     {
		textlines[i] = &textlines[i][num_chars];
		if (VStrcmp(textlines[i], "\n") != 0)
		{
	           sprintf(temp2, "%s", textlines[i]);
                   strcat(temp1, temp2);
		}
		i++;
	     }
	     else if (VStrcmp(textlines[i], "*\n") == 0) i++;
	     else
	     {
	        sprintf(temp2, "%s", textlines[i]);
                strcat(temp1, temp2);
		i++;
             }
     }
     text_block = VStrcpy(temp1);
     return(text_block);
}

 

