#! /bin/csh -f

# 
#  Khoros: $Id: makemake.csh,v 1.2 1991/07/15 06:10:40 khoros Exp $
#

#
# $Log: makemake.csh,v $
# Revision 1.2  1991/07/15  06:10:40  khoros
# HellPatch1
#
# 

#
#*----------------------------------------------------------------------
#*
#* Copyright 1990, University of New Mexico.  All rights reserved.
#*
#* Permission to copy and modify this software and its documen-
#* tation only for internal use in your organization is hereby
#* granted, provided that this notice is retained thereon and
#* on all copies.  UNM makes no representations as too the sui-
#* tability and operability of this software for any purpose.
#* It is provided "as is" without express or implied warranty.
#* 
#* UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
#* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
#* NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
#* INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
#* SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
#* IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
#* ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
#* FORMANCE OF THIS SOFTWARE.
#* 
#* No other rights, including for example, the right to redis-
#* tribute this software and its documentation or the right to
#* prepare derivative works, are granted unless specifically
#* provided in a separate license agreement.
#*---------------------------------------------------------------------
#

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#  >>>>                                                       <<<<
#  >>>>	    file name: makemake.csh                          <<<<
#  >>>>                                                       <<<<
#  >>>>   description: utility for khoros help system
#  >>>>                                                       <<<<
#  >>>> modifications:					      <<<<
#  >>>>                                                       <<<<
#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< 

#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< 

#
# ROUTINE NAME:	makemake.csh
# 
# AUTHORS:	W. Tait Cyrus
# 
# DATE:		4/17/90
# 
# DESCRIPTION:	This script "intelligently" makes files by calling
#		Makefile.  If we are called directly by the user, i.e.
#		no arguments passed, then we either call 'make Makefile'
#		if the Makefile already exists, thus updating the Makefile,
#		or we call imake with a bunch of complicated arguments to
#		create the Makefile.  If we ARE called with args, then
#		it is assumed that the 'make Makefile' called us so again
#		we call imake with a bunch of complicated arguments.
# 
# MODIFICATIONS:  Changed makemake so that imake will first search config
#		  files in KHOROS_HOME/config before /usr/lib/X11
#				(Mark Young Sun Sep  9 03:52:05 MDT 1990)
# 
# ROUTINES:	makemake.csh
#		

##### initialize variables #####

if (! $?KHOROS_HOME ) then
   echo ""
   echo "Error KHOROS_HOME environment variable is not set"
   echo ""
   exit 0
endif

##### get arguments off the command line #####

if ($#argv > 0) then
   if ("$argv[1]" == "-U") then
     goto usage
   else if ("$argv[1]" == "-V") then
     goto version
   endif
endif

#   end of command line stuff
#   Start of the real code

if ( $#argv == 0 ) then
# 	To preserve TOPDIR & CURDIR, let a `make Makefile' do it.
   if ( -e Makefile ) then
      make Makefile
   else
      imake \
	-DKHOROS_TEMPLATE=\"Khoros.tmpl\" \
	-DKHOROS_HOME=$KHOROS_HOME \
	-T$KHOROS_HOME/repos/config/imake_conf/Khoros.tmpl \
	-I$KHOROS_HOME/repos/config/imake_conf \
        -I$KHOROS_HOME/repos/config/imake_tmpls \
	-DUseInstalled \
	-DTOPDIR=$KHOROS_HOME/src
   endif
   make depend
# Mostly likely called from a `make Makefile'
else
   imake \
	-DKHOROS_TEMPLATE=\"Khoros.tmpl\" \
	-DKHOROS_HOME=$KHOROS_HOME \
	-T$KHOROS_HOME/repos/config/imake_conf/Khoros.tmpl \
	-I$KHOROS_HOME/repos/config/imake_conf \
        -I$KHOROS_HOME/repos/config/imake_tmpls \
	$*
endif
exit 0

###
###    the usage statement 
###

usage:
    echo ""
    echo "makemake: [any valid imake options]"
    echo ""
    echo "   Update or Create Makefiles from Imakefiles. "
    echo ""
    echo ""
    echo "where: "
    echo "       [-V]   gives the version for makemake"
    echo "	 [-U]   gives the usage for makemake"
    echo ""
    exit 0

version:
    source $KHOROS_HOME/repos/config/scripts/script_version
    set VERSION = $KHOROS_VERSION
    set RELEASE = $KHOROS_RELEASE
    echo ""
    echo "makemake:  Khoros Release: Version $VERSION.$RELEASE"
    echo ""
    unset KHOROS_VERSION
    unset KHOROS_RELEASE
    exit 0

