

/*******************************************************************88
*
*  File:  irisgraph.c
*
*  Contents:  Device-specific routines for graphing facets 
*             with iris.
*/


#include "include.h"
#include <gl.h>

#ifdef FM
#include <fmclient.h>
static fmfonthandle fh_scaled,fh;
#endif

/* translate my colors to Iris colors */
int icolor[16] = { 0, 4, 2, 6, 1, 5, 7, 7, 7, 7, 7, 7, 7, 7, 3, 7};

/* screen corners */
static REAL scrx[4],scry[4];

static int xbase=10,winwidth=640,ybase=10,winheight=480;


void init_iris()
{
#ifdef FM
  /* font setup for time labels */
  fh = fmfindfont("Helvetica");
  if ( fh == NULL )
    error("inti_iris(): Cannot find font.\n",RECOVERABLE);
  fh_scaled = fmscalefont(fh,24.0);
  fmsetfont(fh_scaled);
#endif

  foreground();
  prefposition(xbase,xbase+winwidth,ybase,ybase+winheight);
  winopen("evolver");
 
  /* screen corners */
  scrx[0] = scrx[1] = -1.4*winwidth/(double)winheight;
  scrx[2] = scrx[3] =  1.4*winwidth/(double)winheight;
  scry[0] = scry[3] = -1.4;
  scry[1] = scry[2] =  1.4;
  ortho2(1.01*scrx[0],1.01*scrx[2],1.01*scry[0],1.01*scry[2]);
  init_flag = 1;
}    

void iris_init()
{
  if ( init_flag == 0 ) init_iris();
  /* clear screen */

  color(WHITE);
  clear();
  if ( web.area_norm_flag )
    { char tstr[30];
      int wide;
      sprintf(tstr,"T = %f",total_time);
      color(BLACK); 
#ifdef FM
      wide = fmgetstrwidth(fh_scaled,tstr); /* width in pixels */
      cmov2(scrx[0]*wide/(double)winwidth,-1.1); 
      fmprstr(tstr);
#else
      wide = strwidth(tstr); /* width in pixels */
      cmov2(scrx[0]*wide/(double)winwidth,-1.1); 
      charstr(tstr);
#endif
    }
}     


void iris_edge(g)
struct graphdata *g;
{  
  int i,j,k;
  REAL a[4],b[2][4];

  /* transform */
  a[0] = a[1] = a[2] = 0.0;
  a[3] = 1.0;
  for ( i = 0 ; i < 2 ; i++ )
    {
      for ( j = 0 ; j < web.sdim ; j++ ) a[j] = g[i].x[j];
      matvec_mul(view,a,b[i],4,4);  /* transform */
    } 

   /* display */
   color(g[0].color);
   bgnline();
   for ( k = 0 ; k < 2 ; k++ )
     v3d(b[k]);
   endline();

}


void iris_facet(t)
struct tsort *t;
{  
   int k;

   /* display */
   if ( web.hide_flag && (get_facet_color(t->f_id) != CLEAR) )
     {
/*         color(WHITE); */
        color(icolor[get_facet_color(t->f_id)]);
       bgnpolygon();
       for ( k = 0 ; k < 3 ; k++ )
         v2f(t->x[k]);
       endpolygon();
     }

  if ( edgeshow_flag )
    {
      color(RED);
      bgnclosedline();
      for ( k = 0 ; k < 3 ; k++ )
        v2f(t->x[k]);
      endclosedline();
    }

}

void iris_finish()
{
}

int iris_end()
{
}

torclose()
{
}


void display()
{
  init_graphics = iris_init;
  finish_graphics = iris_finish;
  graph_edge = iris_edge;
  graph_start = painter_start;
  graph_facet = painter_facet;
  graph_end = painter_end;
  display_facet = iris_facet;
  
  graphgen();
}

