* **********************************************************************
* ** NOAA/USGS GENERAL MAP PROJECTION PACKAGE ..... DR. A. A. ELASSAL **
* **          MATHEMATICAL ANALYSIS BY JOHN SNYDER                    **
* ** GCTP/II                 VERSION 1.0.2           SEPTEMBER 1,1986 **
* **********************************************************************
*                        *  EQUIRECTANGULAR   *
* **********************************************************************
*
      SUBROUTINE PJ17Z0
*
      IMPLICIT REAL*8 (A-Z)
      INTEGER*4 SWITCH,I,ZONE,IPFILE,IFLG
      CHARACTER*16 ANGS(2)
      COMMON /SPHRZ0/ AZZ
* **** PARAMETERS **** A,LON0,X0,Y0,LAT1 *******************************
      DIMENSION DATA(1),GEOG(1),PROJ(1)
      DATA HALFPI /1.57079632679489661923D0/
      DATA ZERO /0.0D0/
      DATA SWITCH /0/
*
* ......................................................................
*      .  INITIALIZATION OF PROJECTION PARAMETERS (ENTRY INPUT)  .
* ......................................................................
*
      ENTRY IS17Z0 (ZONE,DATA,IPFILE,IFLG)
*
      IFLG = 0
      IF (SWITCH.NE.0 .AND. SWITCH.EQ.ZONE) RETURN
      A = DATA(1)
      IF (A .LE. ZERO) A = AZZ
      CALL UNITZ0 (DATA(5),5,LON0,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      CALL UNITZ0 (DATA(6),5,LAT1,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      X0 = DATA(7)
      Y0 = DATA(8)
*
* LIST RESULTS OF PARAMETER INITIALIZATION.
*
      CALL DMSLZ0 (LAT1,0,ANGS(1),IPFILE,IFLG)
      CALL DMSLZ0 (LON0,0,ANGS(2),IPFILE,IFLG)
      IF (IPFILE .NE. 0) WRITE (IPFILE,2000) A,ANGS,X0,Y0
 2000 FORMAT (' INITIALIZATION PARAMETERS (EQUIRECTANGULAR PROJECTION)'/
     .        ' RADIUS OF SPHERE             =',F16.4,' METERS'/
     .        ' LATITUDE OF TRUE SCALE       =',A16/
     .        ' LONGITUDE OF C. MERIDIAN     =',A16/
     .        ' FALSE EASTING                =',F16.4,' METERS'/
     .        ' FALSE NORTHING               =',F16.4,' METERS')
      SWITCH = ZONE
      RETURN
*
* ......................................................................
*                      .  FORWARD TRANSFORMATION  .
* ......................................................................
*
      ENTRY PF17Z0 (GEOG,PROJ,IFLG)
*
      IFLG = 0
      IF (SWITCH .NE. 0) GO TO 120
      IF (IPFILE .NE. 0) WRITE (IPFILE,2010)
 2010 FORMAT (' UNINITIALIZED TRANSFORMATION')
      IFLG = 1700
      RETURN
  120 LON = ADJLZ0 (GEOG(1) - LON0)
      PROJ(1) = X0 + A * LON * DCOS(LAT1)
      PROJ(2) = Y0 + A * GEOG(2)
      RETURN
*
* ......................................................................
*                      .  INVERSE TRANSFORMATION  .
* ......................................................................
*
      ENTRY PI17Z0 (PROJ,GEOG,IFLG)
*
      IFLG = 0
      IF (SWITCH .NE. 0) GO TO 220
      IF (IPFILE .NE. 0) WRITE (IPFILE,2010)
      IFLG = 1700
      RETURN
  220 X = PROJ(1) - X0
      Y = PROJ(2) - Y0
      GEOG(2) = Y / A
      IF (DABS(GEOG(2)) .LE. HALFPI) GO TO 240
      IF (IPFILE .NE. 0) WRITE (IPFILE,2020)
 2020 FORMAT (' IMPROPER PARAMETER')
      IFLG = 1701
      RETURN
  240 GEOG(1) = ADJLZ0 (LON0 + X / (A * DCOS(LAT1) ))
      RETURN
*
      END
