{$i-}
unit dialog;

interface

         uses convert,
              dos,
              strings,
              crt,
              objects,
              dialogs,
              drivers,
              views,
              stddlg,
              app,
              menus,
              msgbox;

         var
            files: text;
            w, h: string [4];
            gra, pal: string[1];
            current_dir: pathstr;
            pov, inc, dats, awk, dv, chemview, mv, jmr, jmr_bs, editor,
                 awk_exe, cascade, picview, command, def,
                 jjv: string[79];

         procedure phys_error;
         procedure ini_error;
         procedure change_opt;
         procedure set_pov_params;
         procedure write_ini;
         procedure set_paths;
         procedure dia_mol2pov;
         procedure set_jmr_params;
         procedure dia_mol2mov;
         procedure get_xyz (var rot_angle: string);

implementation

procedure phys_error;

var
   result: word;

begin
     result := messagebox ('Error in file', nil, mfcancelbutton);
end;

procedure ini_error;

begin
     writeln ('Error in CASCADE.INI or BSP.OPT!');
     halt (0);
end;

{Writes the complete cascade.ini}
procedure write_ini;
begin
     assign (files, cascade + 'cascade.ini');
     delay (100);
     rewrite (files);
     delay (100);
     if ioresult <> 0 then phys_error;
     writeln (files, dats);
     if ioresult <> 0 then phys_error;
     writeln (files, awk);
     if ioresult <> 0 then phys_error;
     writeln (files, dv);
     if ioresult <> 0 then phys_error;
     writeln (files, chemview);
     if ioresult <> 0 then phys_error;
     writeln (files, mv);
     if ioresult <> 0 then phys_error;
     writeln (files, jmr);
     if ioresult <> 0 then phys_error;
     writeln (files, jmr_bs);
     if ioresult <> 0 then phys_error;
     writeln (files, editor);
     if ioresult <> 0 then phys_error;
     writeln (files, awk_exe);
     if ioresult <> 0 then phys_error;
     writeln (files, pov);
     if ioresult <> 0 then phys_error;
     writeln (files, inc);
     if ioresult <> 0 then phys_error;
     writeln (files, w);
     if ioresult <> 0 then phys_error;
     writeln (files, h);
     if ioresult <> 0 then phys_error;
     writeln (files, gra);
     if ioresult <> 0 then phys_error;
     writeln (files, pal);
     if ioresult <> 0 then phys_error;
     writeln (files, picview);
     if ioresult <> 0 then phys_error;
     writeln (files, scaling);
     if ioresult <> 0 then phys_error;
     writeln (files, def);
     if ioresult <> 0 then phys_error;
     writeln (files, jjv);
     if ioresult <> 0 then phys_error;
     close (files);
     if ioresult <> 0 then phys_error;
end;

{The dialogs for starting the routine mol2pov}
procedure dia_mol2pov;

var
   result: integer;
   path_buffer: pathstr;
   buffer_1, buffer_2: string;
   fehler: integer;
   filedialog: pfiledialog;
   dir: dirstr;
   name: namestr;
   ext: extstr;
   radius: string;

begin
     swapxy := false;
     chdir (current_dir);
     filedialog := new (pfiledialog, init ('*.mol', 'Input-file', '~F~ile:',
                fdopenbutton, 103));
     if desktop^.execview (filedialog) <> cmcancel then
        filedialog^.getfilename (path_buffer)
     else path_buffer := '';
     dispose (filedialog, done);
     if path_buffer = '' then exit;
     buffer_1 := path_buffer;
     fsplit (path_buffer, dir, name, ext);
     current_dir := dir;
     delete (current_dir, length (current_dir), 1);
     buffer_2 := dir + name + '.POV';
     result := InputBox ('Output-file', 'POV-file:',
            buffer_2, 79);
     if (result = cmcancel) or (buffer_2 = '') then exit;
     radius := '0.3';
     result := inputbox ('Ball-and_Stick',
            'Radius of the sticks (Cancel for none):', radius, 5);
     if result = cmcancel then radius := '0';
     result := messagebox ('Include shadows?', nil, mfconfirmation + mfyesbutton + mfnobutton);
     if result = cmyes then shadows := true else shadows := false;
     mol2pov (buffer_1, buffer_2, dats, radius, fehler);
     if fehler <> 0 then
        result := messagebox (fehler_text[fehler], nil, mfcancelbutton);
end;

{Set the parameters for the commandline of Povray}
procedure set_pov_params;

var
   r: trect;
   dialog: pdialog;
   result: word;
   buffer: pointer;
   datarec: record
            pov, inc: string [79];
            w, h: string [4];
            scaling: string[5];
            gra, pal: word;
   end;

begin
     datarec.pov := pov;
     datarec.inc := inc;
     datarec.w := w;
     datarec.h := h;
     datarec.scaling := scaling;
     if gra = '0' then datarec.gra := 0;
     if gra = 'G' then datarec.gra := 1;
     if gra = 'C' then datarec.gra := 2;
     if pal = '3' then datarec.pal := 0;
     if pal = 'h' then datarec.pal := 1;
     if pal = 'T' then datarec.pal := 2;

     r.assign (0, 0, 70, 17);
     r.move ((desktop^.size.x-r.b.x) div 2, (desktop^.size.y - r.b.y) div 2);
     dialog := new (pdialog, init (r, 'Set parameters for Povray'));

     r.assign (26, 2, 67, 3);
     buffer := new (pinputline, init (r, 79));
     dialog^.insert (buffer);
     r.assign (2, 2, 25, 3);
     dialog^.insert (new (plabel, init (r, 'Path to Povray:', buffer)));

     r.assign (26, 4, 67, 5);
     buffer := new (pinputline, init (r, 79));
     dialog^.insert (buffer);
     r.assign (2, 4, 25, 5);
     dialog^.insert (new (plabel, init (r, 'Path to Include-files:',
                    buffer)));

     r.assign (10, 6, 16, 7);
     buffer := new (pinputline, init (r, 4));
     dialog^.insert (buffer);
     r.assign (2, 6, 10, 7);
     dialog^.insert (new (plabel, init (r, 'Width:', buffer)));

     r.assign (29, 6, 35, 7);
     buffer := new (pinputline, init (r, 4));
     dialog^.insert (buffer);
     r.assign (20, 6, 29, 7);
     dialog^.insert (new (plabel, init (r, 'Height:', buffer)));

     r.assign (27, 8, 34, 9);
     buffer := new (pinputline, init (r, 5));
     dialog^.insert (buffer);
     r.assign (2, 8, 27, 9);
     dialog^.insert (new (plabel, init (r, 'Scaling of atom-radius:', buffer)));

     r.assign (3, 10, 19, 13);
     buffer := new (pradiobuttons, init (r,
                   newsitem ('VGA',
                   newsitem ('VESA SVGA',
                   newsitem ('C & T SVGA', nil)))));
     dialog^.insert (buffer);

     r.assign (22, 10, 41, 13);
     buffer := new (pradiobuttons, init (r,
                   newsitem ('VGA dithering',
                   newsitem ('Hicolor',
                   newsitem ('Truecolor', nil)))));
     dialog^.insert (buffer);

     r.assign (13, 14, 21, 16);
     dialog^.insert (new (pbutton, init (r, '~O~k', cmok, bfnormal)));
     r.assign (45, 14, 57, 16);
     dialog^.insert (new (pbutton, init (r, '~C~ancel', cmcancel, bfdefault)));

     dialog^.setdata (datarec);
     result := desktop^.execview (dialog);
     if result = cmok then begin
        dialog^.getdata (datarec);
        pov := datarec.pov;
        inc := datarec.inc;
        w := datarec.w;
        h := datarec.h;
        scaling := datarec.scaling;
        case datarec.gra of
             0: gra := '0';
             1: gra := 'G';
             2: gra := 'C';
        end;
        case datarec.pal of
             0: pal := '3';
             1: pal := 'h';
             2: pal := 'T';
        end;
        write_ini;
     end;
     dispose (dialog, done);
end;

{Dialog for the paths of extern programms and files}
procedure set_paths;

var
   r: trect;
   dialog: pdialog;
   result: word;
   buffer: pointer;
   datarec: record
            dats, awk, dv, chemview, mv, jmr, jmr_bs, editor, awk_exe,
            picview: string[79];
   end;

begin
     datarec.dats := dats;
     datarec.awk := awk;
     datarec.dv := dv;
     datarec.chemview := chemview;
     datarec.mv := mv;
     datarec.jmr := jmr;
     datarec.jmr_bs := jmr_bs;
     datarec.editor := editor;
     datarec.awk_exe := awk_exe;
     datarec.picview := picview;

     r.assign (0, 0, 70, 16);
     r.move ((desktop^.size.x-r.b.x) div 2, (desktop^.size.y - r.b.y) div 2);
     dialog := new (pdialog, init (r, 'Set paths'));

     r.assign (25, 2, 67, 3);
     buffer := new (pinputline, init (r, 79));
     dialog^.insert (buffer);
     r.assign (2, 2, 24, 3);
     dialog^.insert (new (plabel, init (r, 'Atomdeclaration-file:', buffer)));

     r.assign (25, 3, 67, 4);
     buffer := new (pinputline, init (r, 79));
     dialog^.insert (buffer);
     r.assign (2, 3, 24, 4);
     dialog^.insert (new (plabel, init (r, 'AWK-Scipts:', buffer)));

     r.assign (25, 4, 67, 5);
     buffer := new (pinputline, init (r, 79));
     dialog^.insert (buffer);
     r.assign (2, 4, 24, 5);
     dialog^.insert (new (plabel, init (r, '3DV.EXE:', buffer)));

     r.assign (25, 5, 67, 6);
     buffer := new (pinputline, init (r, 79));
     dialog^.insert (buffer);
     r.assign (2, 5, 24, 6);
     dialog^.insert (new (plabel, init (r, 'CHEMVIEW.EXE:', buffer)));

     r.assign (25, 6, 67, 7);
     buffer := new (pinputline, init (r, 79));
     dialog^.insert (buffer);
     r.assign (2, 6, 24, 7);
     dialog^.insert (new (plabel, init (r, 'MV.EXE:', buffer)));

     r.assign (25, 7, 67, 8);
     buffer := new (pinputline, init (r, 79));
     dialog^.insert (buffer);
     r.assign (2, 7, 24, 8);
     dialog^.insert (new (plabel, init (r, 'JMR.EXE:', buffer)));

     r.assign (25, 8, 67, 9);
     buffer := new (pinputline, init (r, 79));
     dialog^.insert (buffer);
     r.assign (2, 8, 24, 9);
     dialog^.insert (new (plabel, init (r, 'JMR_BS.EXE:', buffer)));

     r.assign (25, 9, 67, 10);
     buffer := new (pinputline, init (r, 79));
     dialog^.insert (buffer);
     r.assign (2, 9, 24, 10);
     dialog^.insert (new (plabel, init (r, 'Editor:', buffer)));

     r.assign (25, 10, 67, 11);
     buffer := new (pinputline, init (r, 79));
     dialog^.insert (buffer);
     r.assign (2, 10, 24, 11);
     dialog^.insert (new (plabel, init (r, 'AWK.EXE:', buffer)));

     r.assign (25, 11, 67, 12);
     buffer := new (pinputline, init (r, 79));
     dialog^.insert (buffer);
     r.assign (2, 11, 24, 12);
     dialog^.insert (new (plabel, init (r, 'Picture-Viewer:', buffer)));

     r.assign (13, 13, 21, 15);
     dialog^.insert (new (pbutton, init (r, '~O~k', cmok, bfnormal)));
     r.assign (45, 13, 57, 15);
     dialog^.insert (new (pbutton, init (r, '~C~ancel', cmcancel, bfdefault)));

     dialog^.setdata (datarec);
     result := desktop^.execview (dialog);
     if result = cmok then begin
        if awk[length (awk)] <> '\' then awk := awk + '\';
        dialog^.getdata (datarec);
        dats := datarec.dats;
        awk := datarec.awk;
        dv := datarec.dv;
        chemview := datarec.chemview;
        mv := datarec.mv;
        jmr := datarec.jmr;
        jmr_bs := datarec.jmr_bs;
        editor := datarec.editor;
        awk_exe := datarec.awk_exe;
        picview := datarec.picview;
        write_ini;
     end;
     dispose (dialog, done);
end;

procedure get_xyz (var rot_angle: string);

var
   r: trect;
   result: word;
   dialog: pdialog;
   buffer: pointer;
   datarec: record
            angle: xyz;
   end;

begin
     datarec.angle.x := '0';
     datarec.angle.y := '0';
     datarec.angle.z := '0';

     r.assign (0, 0, 57, 8);
     r.move ((desktop^.size.x-r.b.x) div 2, (desktop^.size.y - r.b.y) div 2);
     dialog := new (pdialog, init (r, 'Enter rotation-angle for JMR'));

     r.assign (3, 2, 50, 3);
     dialog^.insert (new (pstatictext, init (r, 'Angle in degrees:')));

     r.assign (6, 3, 18, 4);
     buffer := new (pinputline, init (r, 10));
     dialog^.insert (buffer);
     r.assign (2, 3, 5, 4);
     dialog^.insert (new (plabel, init (r, 'x:', buffer)));

     r.assign (24, 3, 36, 4);
     buffer := new (pinputline, init (r, 10));
     dialog^.insert (buffer);
     r.assign (20, 3, 23, 4);
     dialog^.insert (new (plabel, init (r, 'y:', buffer)));

     r.assign (42, 3, 54, 4);
     buffer := new (pinputline, init (r, 10));
     dialog^.insert (buffer);
     r.assign (38, 3, 41, 4);
     dialog^.insert (new (plabel, init (r, 'z:', buffer)));

     r.assign (10, 5, 18, 7);
     dialog^.insert (new (pbutton, init (r, '~O~k', cmok, bfnormal)));
     r.assign (35, 5, 47, 7);
     dialog^.insert (new (pbutton, init (r, '~C~ancel', cmcancel, bfdefault)));

     dialog^.setdata (datarec);
     result := desktop^.execview (dialog);
     if result = cmok then begin
        dialog^.getdata (datarec);
        rot_angle := ' /x' + datarec.angle.x +
                  ' /y' + datarec.angle.y +
                  ' /z' + datarec.angle.z;
     end;
end;

{Changing of the include-parameters of Povray
(Position of camera, lightsource, color of background}
procedure change_opt;

var
   r: trect;
   result: word;
   dialog: pdialog;
   buffer: pointer;
   datarec: record
            camera: xyz;
            look_at: xyz;
            light_source: xyz;
            light_color: string[30];
            back_color: string[30];
            stick_color: string[30];
            include_file: string[79];
   end;

begin
     datarec.camera := camera;
     datarec.look_at := look_at;
     datarec.light_source := light_source;
     datarec.light_color := light_color;
     datarec.back_color := back_color;
     datarec.include_file := include_file;
     datarec.stick_color := stick_color;

     r.assign (0, 0, 57, 19);
     r.move ((desktop^.size.x-r.b.x) div 2, (desktop^.size.y - r.b.y) div 2);
     dialog := new (pdialog, init (r, 'Edit include-file for Povray'));

     r.assign (3, 2, 50, 3);
     dialog^.insert (new (pstatictext, init (r, 'Position of camera:')));

     r.assign (6, 3, 18, 4);
     buffer := new (pinputline, init (r, 10));
     dialog^.insert (buffer);
     r.assign (2, 3, 5, 4);
     dialog^.insert (new (plabel, init (r, 'x:', buffer)));

     r.assign (24, 3, 36, 4);
     buffer := new (pinputline, init (r, 10));
     dialog^.insert (buffer);
     r.assign (20, 3, 23, 4);
     dialog^.insert (new (plabel, init (r, 'y:', buffer)));

     r.assign (42, 3, 54, 4);
     buffer := new (pinputline, init (r, 10));
     dialog^.insert (buffer);
     r.assign (38, 3, 41, 4);
     dialog^.insert (new (plabel, init (r, 'z:', buffer)));

     r.assign (3, 5, 50, 6);
     dialog^.insert (new (pstatictext, init (r, 'Direction to:')));

     r.assign (6, 6, 18, 7);
     buffer := new (pinputline, init (r, 10));
     dialog^.insert (buffer);
     r.assign (2, 6, 5, 7);
     dialog^.insert (new (plabel, init (r, 'x:', buffer)));

     r.assign (24, 6, 36, 7);
     buffer := new (pinputline, init (r, 10));
     dialog^.insert (buffer);
     r.assign (20, 6, 23, 7);
     dialog^.insert (new (plabel, init (r, 'y:', buffer)));

     r.assign (42, 6, 54, 7);
     buffer := new (pinputline, init (r, 10));
     dialog^.insert (buffer);
     r.assign (38, 6, 41, 7);
     dialog^.insert (new (plabel, init (r, 'z:', buffer)));

     r.assign (3, 8, 50, 9);
     dialog^.insert (new (pstatictext, init (r, 'Position of lightsource:')));

     r.assign (6, 9, 18, 10);
     buffer := new (pinputline, init (r, 10));
     dialog^.insert (buffer);
     r.assign (2, 9, 5, 10);
     dialog^.insert (new (plabel, init (r, 'x:', buffer)));

     r.assign (24, 9, 36, 10);
     buffer := new (pinputline, init (r, 10));
     dialog^.insert (buffer);
     r.assign (20, 9, 23, 10);
     dialog^.insert (new (plabel, init (r, 'y:', buffer)));

     r.assign (42, 9, 54, 10);
     buffer := new (pinputline, init (r, 10));
     dialog^.insert (buffer);
     r.assign (38, 9, 41, 10);
     dialog^.insert (new (plabel, init (r, 'z:', buffer)));

     r.assign (24, 11, 54, 12);
     buffer := new (pinputline, init (r, 30));
     dialog^.insert (buffer);
     r.assign (2, 11, 23, 12);
     dialog^.insert (new (plabel, init (r, 'Color of light:', buffer)));

     r.assign (24, 12, 54, 13);
     buffer := new (pinputline, init (r, 30));
     dialog^.insert (buffer);
     r.assign (2, 12, 23, 13);
     dialog^.insert (new (plabel, init (r, 'Color of background:', buffer)));

     r.assign (24, 13, 54, 14);
     buffer := new (pinputline, init (r, 30));
     dialog^.insert (buffer);
     r.assign (2, 13, 23, 14);
     dialog^.insert (new (plabel, init (r, 'Color of sticks:', buffer)));

     r.assign (24, 14, 54, 15);
     buffer := new (pinputline, init (r, 79));
     dialog^.insert (buffer);
     r.assign (2, 14, 23, 15);
     dialog^.insert (new (plabel, init (r, 'Add. include-file:', buffer)));

     r.assign (10, 16, 18, 18);
     dialog^.insert (new (pbutton, init (r, '~O~k', cmok, bfnormal)));
     r.assign (35, 16, 47, 18);
     dialog^.insert (new (pbutton, init (r, '~C~ancel', cmcancel, bfdefault)));

     dialog^.setdata (datarec);
     result := desktop^.execview (dialog);
     if result = cmok then begin
        dialog^.getdata (datarec);
        camera := datarec.camera;
        light_source := datarec.light_source;
        look_at := datarec.look_at;
        light_color := datarec.light_color;
        back_color := datarec.back_color;
        include_file := datarec.include_file;
        stick_color := datarec.stick_color;

        assign (files, cascade + 'bsp.opt');
        delay (100);
        rewrite (files);
        delay (100);
        if ioresult <> 0 then phys_error;
        writeln (files, camera.x);
        if ioresult <> 0 then phys_error;
        writeln (files, camera.y);
        if ioresult <> 0 then phys_error;
        writeln (files, camera.z);
        if ioresult <> 0 then phys_error;
        writeln (files, look_at.x);
        if ioresult <> 0 then phys_error;
        writeln (files, look_at.y);
        if ioresult <> 0 then phys_error;
        writeln (files, look_at.z);
        if ioresult <> 0 then phys_error;
        writeln (files, light_source.x);
        if ioresult <> 0 then phys_error;
        writeln (files, light_source.y);
        if ioresult <> 0 then phys_error;
        writeln (files, light_source.z);
        if ioresult <> 0 then phys_error;
        writeln (files, light_color);
        if ioresult <> 0 then phys_error;
        writeln (files, back_color);
        if ioresult <> 0 then phys_error;
        writeln (files, stick_color);
        if ioresult <> 0 then phys_error;
        writeln (files, include_file);
        if ioresult <> 0 then phys_error;
        close (files);
        if ioresult <> 0 then phys_error;
     end;
     dispose (dialog, done);
end;

procedure set_jmr_params;

var
   result: word;
   filedialog: pfiledialog;
   path_buffer: pathstr;

begin
     if notexist (def) then def := '*.def';
     filedialog := new (pfiledialog, init (def, 'Atomdeclaration for JMR',
                 '~F~ile:', fdopenbutton, 106));
     if desktop^.execview (filedialog) <> cmcancel then
        filedialog^.getfilename (path_buffer)
     else path_buffer := '';
     dispose (filedialog, done);
     if path_buffer = '' then exit;
     def := path_buffer;
     if notexist (jjv) then jjv := '*.jjv';
     filedialog := new (pfiledialog, init (jjv, 'Include-file for JMR',
                '~F~ile:', fdopenbutton, 107));
     if desktop^.execview (filedialog) <> cmcancel then
        filedialog^.getfilename (path_buffer)
     else path_buffer := '';
     dispose (filedialog, done);
     if path_buffer = '' then exit;
     jjv := path_buffer;
     write_ini;
end;

procedure dia_mol2mov;

type rxyz = record
     x, y, z: real;
end;

var
   result: integer;
   path_buffer: pathstr;
   buffer, buffer_1, buffer_2: string;
   fehler: integer;
   filedialog: pfiledialog;
   dir: dirstr;
   name: namestr;
   ext: extstr;
   radius: string;
   rotrad: real;
   grad: integer;
   rcamera, rlook_at, rlight_source: rxyz;
   number: integer;

begin
     val (camera.x, rcamera.x, fehler);
     val (camera.z, rcamera.z, fehler);
     val (look_at.x, rlook_at.x, fehler);
     val (look_at.z, rlook_at.z, fehler);
     chdir (current_dir);
     filedialog := new (pfiledialog, init ('*.mol', 'Input-file', '~F~ile:',
                fdopenbutton, 103));
     if desktop^.execview (filedialog) <> cmcancel then
        filedialog^.getfilename (path_buffer)
     else path_buffer := '';
     dispose (filedialog, done);
     if path_buffer = '' then exit;
     buffer_1 := path_buffer;
     fsplit (path_buffer, dir, name, ext);
     current_dir := dir;
     delete (current_dir, length (current_dir), 1);
     buffer_2 := dir;
     result := InputBox ('Output-directory', 'Directory:',
            buffer_2, 79);
     if (result = cmcancel) or (buffer_2 = '') then exit;
     if copy (buffer_2, length (buffer_2), 1) <> '\' then buffer_2 :=
        buffer_2 + '\';
     buffer := '5';
     result := InputBox ('Rotation-step', 'Angle:',
            buffer, 3);
     if (result = cmcancel) or (buffer = '') then exit;
     val (buffer, grad, fehler);
     result := messagebox ('Do you want to swap'#13 +
            'the x- and y-coordinates?', nil, mfconfirmation + mfyesbutton +
            mfnobutton);
     if result = cmyes then swapxy := true else swapxy := false;
     result := messagebox ('Include shadows?', nil, mfconfirmation + mfyesbutton + mfnobutton);
     if result = cmyes then shadows := true else shadows := false;
     radius := '0.3';
     result := inputbox ('Ball-and_Stick',
            'Radius of the sticks (Cancel for none):', radius, 5);
     if result = cmcancel then radius := '0';
     rcamera.x := rcamera.x - rlook_at.x;
     rcamera.z := rcamera.z - rlook_at.z;
     rotrad := sqrt (rcamera.x * rcamera.x + rcamera.z * rcamera.z);
     number := 0;
     assign (files, buffer_2 + 'render.bat');
     rewrite (files);
     repeat
           number := number + 1;
           rcamera.x := rotrad * cos ((grad * number * pi) / 180)
                     + rlook_at.x;
           rcamera.z := rotrad * sin ((grad * number * pi) /180)
                     + rlook_at.z;
           rlight_source.x := 2.5 * rotrad * cos (((grad * number + 30) * pi) / 180) + rlook_at.x;
           rlight_source.z := 2.5 * rotrad * sin (((grad * number + 30) * pi) / 180) + rlook_at.z;
           str (rcamera.x:0:5, camera.x);
           str (rcamera.z:0:5, camera.z);
           str (rlight_source.x:0:5, light_source.x);
           str (rlight_source.z:0:5, light_source.z);
           str (number, buffer);
           if length (buffer) < 3 then buffer := '0' + buffer;
           if length (buffer) < 3 then buffer := '0' + buffer;
           mol2pov (buffer_1, buffer_2 + 'movie' + buffer + '.pov', dats,
                   radius, fehler);
           if fehler <> 0 then
              result := messagebox (fehler_text[fehler], nil, mfcancelbutton);
           if fehler = 0 then
           writeln (files, pov + ' +l' + inc + ' +imovie' + buffer +
                   '.pov +omovie' + buffer + '.tga +a -p' + ' -v +x +w' + w +
                   ' +h' + h + ' +d' + gra + pal);
     until ((grad * number) >= 360) or ((grad * number) <= -360);
     close (files);
     result := messagebox ('Quit CASCADE and run '#13 +
            'the file render.bat!', nil, mfinformation);
end;

end.