{CASCADE 2}
{(c) 1995 by Andreas Dosche}
{This program is a part of the package CASCADE 2}
{See FAQ and COPYING more information}

{$i-}
{$m 60000, 0, 10000}
uses convert,
     dialog,
     dialogs,
     dos,
     strings,
     crt,
     stddlg,
     objects,
     drivers,
     views,
     app,
     menus,
     histlist,
     msgbox;

type
    tappl = object (tapplication)
          constructor return;
          procedure initmenubar; virtual;
          procedure initstatusline; virtual;
          procedure handleevent (var event: tevent); virtual;
    end;
    pappl = ^tappl;

const
     cmparpov = 100;
     cmrenpov = 101;
     cmlismol = 102;
     cmmolstr = 103;
     cmmolcoo = 104;
     cmmoldat = 105;
     cmmolpdb = 106;
     cmmolplu = 107;
     cmsetpath = 108;
     cmmolpov = 109;
     cmeditopt = 110;
     cmeditdat = 111;
     cmeditany = 112;
     cmmol3dv = 113;
     cm3dv = 114;
     cmchem = 115;
     cmabout = 116;
     cmpicview = 117;
     cmoutmol = 118;
     cmmv = 119;
     cmparjmr = 120;
     cmrenjmr = 121;
     cmrenmov = 122;
     cmmolxyz = 123;
     cmcopying = 124;
     cmpreview = 125;
     cmxyzmol = 126;
     cmpdbmol = 127;
     cmmoldt3 = 128;
     cmbugs = 129;
     cmfaq = 130;
     cmviewme = 131;

var
   fehler: integer;
   f: text;
   appl: pappl;
   input_file, output_file, path_buffer: string;
   path: pathstr;
   dir: dirstr;
   name: namestr;
   ext: extstr;

procedure enable_commands;
var
   buffer: string;

begin
     if  not (notexist (command)) then appl^.enablecommands ([cmrenpov,
         cmlismol, cmmolstr, cmmolcoo, cmmoldat, cmmolpdb, cmmolplu, cmmol3dv,
         cmoutmol, cmrenjmr, cmmolxyz, cmxyzmol, cmpdbmol, cmmoldt3])
     else appl^.disablecommands ([cmrenpov, cmlismol, cmmolstr, cmmolcoo,
          cmmoldat, cmmolpdb, cmmolplu, cmmol3dv, cmoutmol, cmrenjmr,
          cmmolxyz, cmxyzmol, cmpdbmol, cmmoldt3]);
     if notexist (awk_exe) then appl^.disablecommands ([cmlismol, cmmolstr,
        cmmolcoo, cmmoldat, cmmolpdb, cmmolplu, cmmol3dv, cmoutmol, cmmolxyz,
        cmxyzmol, cmpdbmol, cmmoldt3]);
     if notexist (awk + 'pac2mol.awk') then appl^.disablecommands ([cmlismol]);
     if notexist (awk + 'mol2str.awk') then appl^.disablecommands ([cmmolstr]);
     if notexist (awk + 'mol2coo.awk') then appl^.disablecommands ([cmmolcoo]);
     if notexist (awk + 'mol2dat.awk') then appl^.disablecommands ([cmmoldat]);
     if notexist (awk + 'mol2pdb.awk') then appl^.disablecommands ([cmmolpdb]);
     if notexist (awk + 'mol2spf.awk') then appl^.disablecommands ([cmmolplu]);
     if notexist (awk + 'mol23dv.awk') then appl^.disablecommands ([cmmol3dv]);
     if notexist (awk + 'vamp2mol.awk') then appl^.disablecommands ([cmoutmol]);
     if notexist (awk + 'mol2xyz.awk') then appl^.disablecommands ([cmmolxyz]);
     if notexist (awk + 'xyz2mol.awk') then appl^.disablecommands ([cmxyzmol]);
     if notexist (awk + 'pdb2mol.awk') then appl^.disablecommands ([cmpdbmol]);
     if notexist (awk + 'mol2dt3.awk') then appl^.disablecommands ([cmmoldt3]);
     if notexist (cascade + 'preview.exe') then appl^.disablecommands ([cmpreview])
        else appl^.enablecommands ([cmpreview]);
     if notexist (pov) then appl^.disablecommands ([cmrenpov]);
     if notexist (dv) then appl^.disablecommands ([cm3dv])
        else appl^.enablecommands ([cm3dv]);
     if notexist (mv) then appl^.disablecommands ([cmmv])
        else appl^.enablecommands ([cmmv]);
     if notexist (editor) then appl^.disablecommands ([cmeditdat, cmeditany,
        cmcopying, cmabout, cmbugs, cmfaq, cmviewme])
     else appl^.enablecommands ([cmeditdat, cmeditany, cmcopying,
          cmabout, cmbugs, cmfaq, cmviewme]);
     if notexist (chemview) then appl^.disablecommands ([cmchem])
        else appl^.enablecommands ([cmchem]);
     if notexist (picview) then appl^.disablecommands ([cmpicview])
        else appl^.enablecommands ([cmpicview]);
     if notexist (jmr) and notexist (jmr_bs) then appl^.disablecommands ([cmrenjmr]);
     buffer := cascade;
     delete (buffer, length (buffer), 1);
     chdir (buffer);
end;

procedure call_awk (script: string);
begin
     assign (output, cascade + 'temp.bat');
     rewrite (output);
     writeln ('@echo off');
     writeln ('echo Converting ...');
     writeln ('copy ' + input_file + ' temp.001 >nul:');
     writeln (awk_exe + ' -f' + awk + script + ' temp.001 ' + dats +
             ' >temp.002');
     writeln ('copy temp.002 ' + output_file + ' >nul:');
     writeln ('erase temp.00?');
     close (output);
     exec (command, '/c ' + cascade + 'temp.bat');
     erase (output);
end;

procedure tappl.initmenubar;

var
   r: trect;

begin
     getextent (r);
     r.b.y := r.a.y + 1;
     menubar := new (pmenubar, init (r, newmenu (
             newsubmenu ('~C~onvert', hcnocontext, newmenu (
                        newitem ('~L~is/Out (Mopac/Ampac) -> Mol', '', kbnokey, cmlismol, hcnocontext,
                        newitem ('~O~ut (Vamp) -> Mol', '', kbnokey, cmoutmol, hcnocontext,
                        newitem ('~P~db (Raswin) -> Mol', '', kbnokey, cmpdbmol, hcnocontext,
                        newitem ('X~Y~Z (Molwin) -> Mol', '', kbnokey, cmxyzmol, hcnocontext,
                        newline (
                        newitem ('Mol -> ~3~dv (3dv)', '', kbnokey, cmmol3dv, hcnocontext,
                        newitem ('Mol -> ~C~oo (JMR)', '', kbnokey, cmmolcoo, hcnocontext,
                        newitem ('Mol -> ~D~at (Chemview)', '', kbnokey, cmmoldat, hcnocontext,
                        newitem ('Mol -> D~T~3 (PcModel)', '', kbnokey, cmmoldt3, hcnocontext,
                        newitem ('Mol -> Pd~b~ (Raswin)', '', kbnokey, cmmolpdb, hcnocontext,
                        newitem ('Mol -> Po~v~ (Povray)', '', kbnokey, cmmolpov, hcnocontext,
                        newitem ('Mol -> Sp~f~ (Pluton)', '', kbnokey, cmmolplu, hcnocontext,
                        newitem ('Mol -> ~S~tr (MV)', '', kbnokey, cmmolstr, hcnocontext,
                        newitem ('Mol -> ~X~YZ (Molwin)', '', kbnokey, cmmolxyz, hcnocontext,nil))))))))))))))),
             newsubmenu ('~O~ptions', hcnocontext, newmenu (
                        newitem ('Set parameters for ~P~ovray', '', kbnokey, cmparpov, hcnocontext,
                        newitem ('Set parameters for ~J~MR', '', kbnokey, cmparjmr, hcnocontext,
                        newitem ('~S~et paths', '', kbnokey, cmsetpath, hcnocontext,nil)))),
             newsubmenu ('~R~ender', hcnocontext, newmenu (
                        newitem ('Pre~v~iew', '', kbnokey, cmpreview, hcnocontext,
                        newitem ('~P~ovray', '', kbnokey, cmrenpov, hcnocontext,
                        newitem ('~3~dv', '', kbnokey, cm3dv, hcnocontext,
                        newitem ('~C~hemview', '', kbnokey, cmchem, hcnocontext,
                        newitem ('~M~V', '', kbnokey, cmmv, hcnocontext,
                        newitem ('~J~MR', '', kbnokey, cmrenjmr, hcnocontext,
                        newitem ('~R~ender movie', '', kbnokey, cmrenmov, hcnocontext, nil)))))))),
             newsubmenu ('~E~dit', hcnocontext, newmenu (
                        newitem ('Include-file for ~P~ovray', '', kbnokey, cmeditopt, hcnocontext,
                        newitem ('~A~tomdeclaration-file', '', kbnokey, cmeditdat, hcnocontext,
                        newitem ('~E~dit files', '', kbnokey, cmeditany, hcnocontext,
                        newitem ('Picture-~V~iewer', '', kbnokey, cmpicview, hcnocontext,nil))))),nil)))))));
     enable_commands;
end;

procedure tappl.initstatusline;

var
   r: trect;

begin
     getextent (r);
     r.a.y := r.b.y - 1;
     statusline := new (pstatusline, init (r, newstatusdef (0, $ffff,
                newstatuskey ('~Alt-F4~ Exit', kbaltf4, cmquit,
                newstatuskey ('~A~bout', kbalta, cmabout,
                newstatuskey ('~G~NU-License', kbaltg, cmcopying,
                newstatuskey ('~K~nown Bugs', kbaltk, cmbugs,
                newstatuskey ('~F~AQ', kbaltf, cmfaq,
                newstatuskey ('~V~iewme', kbaltv, cmviewme, nil)))))),nil)));
end;

constructor tappl.return;
begin
     tapplication.init;
end;

procedure render_pov;

var
   result: integer;
   path_buffer: pathstr;
   buffer_1, buffer_2: string;
   key: char;
   filedialog: pfiledialog;

begin
     chdir (current_dir);
     filedialog := new (pfiledialog, init ('*.pov', 'Input-file', '~F~ile:',
                fdopenbutton, 100));
     if desktop^.execview (filedialog) <> cmcancel then
        filedialog^.getfilename (path_buffer)
     else path_buffer := '';
     dispose (filedialog, done);
     if path_buffer = '' then exit;
     buffer_1 := path_buffer;
     fsplit (path_buffer, dir, name, ext);
     current_dir := dir;
     delete (current_dir, length (current_dir), 1);
     buffer_2 := dir + name + '.TGA';
     result := InputBox ('Output-file', 'TGA-file:',
            buffer_2, 79);
     if (result = cmcancel) or (buffer_2 = '') then exit;
     dispose (appl, done);
     assign (files, 'temp.bat');
     rewrite (files);
     writeln (files, '@echo off');
     writeln (files, 'copy ' + buffer_1 + ' temp.001 >nul:');
     writeln (files, pov + ' +l' + inc + ' +itemp.001 +otemp.002 +a +p'
             + ' -v +x +w' + w + ' +h' + h + ' +d' + gra + pal);
     writeln (files, 'copy temp.002 ' + buffer_2 + ' >nul:');
     writeln (files, 'erase temp.00?');
     close (files);
     exec (command, '/c temp.bat');
     erase (files);
     write ('Press any key to return');
     repeat until keypressed;
     key := readkey;
     appl := new (pappl, return);
     appl^.run;
end;

procedure render_jmr;

var
   result: integer;
   path_buffer: pathstr;
   buffer_1, buffer_2: string;
   key: char;
   filedialog: pfiledialog;
   rot_angle: string;

begin
     chdir (current_dir);
     filedialog := new (pfiledialog, init ('*.coo', 'Input-file', '~F~ile:',
                fdopenbutton, 108));
     if desktop^.execview (filedialog) <> cmcancel then
        filedialog^.getfilename (path_buffer)
     else path_buffer := '';
     dispose (filedialog, done);
     if path_buffer = '' then exit;
     buffer_1 := path_buffer;
     fsplit (path_buffer, dir, name, ext);
     current_dir := dir;
     delete (current_dir, length (current_dir), 1);
     buffer_2 := dir + name + '.TGA';
     result := InputBox ('Output-file', 'TGA-file:',
            buffer_2, 79);
     if (result = cmcancel) or (buffer_2 = '') then exit;
     get_xyz (rot_angle);
     result := messagebox ('Do you want a ball-and-stick model?'#13 +
            '(For space-filling model: No)', nil, mfyesnocancel +
            mfconfirmation);
     if result = cmcancel then exit;
     dispose (appl, done);
     assign (files, 'temp.bat');
     rewrite (files);
     writeln (files, '@echo off');
     writeln (files, 'copy ' + buffer_1 + ' temp.001 >nul:');
     writeln (files, 'copy ' + def + ' temp.003 >nul:');
     writeln (files, 'copy ' + jjv + ' temp.004 >nul:');
     if result = cmyes then writeln (files, jmr_bs + ' /ftemp.003 /c' +
     'temp.004 /itemp.001 /ttemp.002' + rot_angle)
     else writeln (files, jmr + ' /ftemp.003 /ctemp.004' +
          ' /itemp.001 /ttemp.002' + rot_angle);
     writeln (files, 'copy temp.002 ' + buffer_2 + ' >nul:');
     writeln (files, 'erase temp.00?');
     close (files);
     exec (command, '/c temp.bat');
     erase (files);
     write ('Press any key to return');
     repeat until keypressed;
     key := readkey;
     appl := new (pappl, return);
     appl^.run;
end;

procedure render_3dv;

var
   result: integer;
   path_buffer: pathstr;
   buffer_1, buffer_2: string;
   key: char;
   filedialog: pfiledialog;

begin
     chdir (current_dir);
     filedialog := new (pfiledialog, init ('*.3dv', 'Input-file', '~F~ile:',
                fdopenbutton, 101));
     if desktop^.execview (filedialog) <> cmcancel then
        filedialog^.getfilename (path_buffer)
     else path_buffer := '';
     dispose (filedialog, done);
     if path_buffer = '' then exit;
     buffer_1 := path_buffer;
     fsplit (path_buffer, dir, name, ext);
     current_dir := dir;
     delete (current_dir, length (current_dir ), 1);
     chdir (current_dir);
     dispose (appl, done);
     exec (dv, name + ext);
     appl := new (pappl, return);
     appl^.run;
end;

procedure call_cascade (what: string; var input_file:string;
          var output_file: string; id: word);

var
   result: integer;
   path_buffer: pathstr;
   fehler: integer;
   filedialog: pfiledialog;

begin
     chdir (current_dir);
     filedialog := new (pfiledialog, init ('*.' + input_file, what, '~F~ile:',
                fdopenbutton, id));
     if desktop^.execview (filedialog) <> cmcancel then
        filedialog^.getfilename (path_buffer)
     else begin
          input_file := '';
          output_file := '';
          path_buffer := '';
     end;
     dispose (filedialog, done);
     if path_buffer <> '' then begin
        fsplit (path_buffer, dir, name, ext);
        current_dir := dir;
        delete (current_dir, length (current_dir), 1);
        input_file := path_buffer;
        output_file := dir + name + '.' + output_file;
        result := InputBox ('Output-file', 'Output-file:',
               output_file, 79);
        if (result = cmcancel) or (output_file = '') then output_file := '';
     end;
     dispose (appl, done);
end;

procedure return_from_cascade;

var
   key: char;

begin
     appl := new (pappl, return);
     appl^.run;
end;

procedure editdat;
begin
     dispose (appl, done);
     exec (editor, dats);
     appl := new (pappl, return);
     appl^.run;
end;

procedure call_edit (name: string);
begin
     dispose (appl, done);
     exec (editor, name);
     appl := new (pappl, return);
     appl^.run;
end;

procedure call_mv;

var
   filedialog: pfiledialog;
   path_buffer: pathstr;
   key: char;
   dir: dirstr;
   name: namestr;
   ext: extstr;

begin
     chdir (current_dir);
     filedialog := new (pfiledialog, init ('*.str', 'Input-file', '~F~ile:',
                fdopenbutton, 100));
     if desktop^.execview (filedialog) <> cmcancel then
        filedialog^.getfilename (path_buffer)
     else path_buffer := '';
     dispose (filedialog, done);
     if path_buffer = '' then exit;
     fsplit (path_buffer, dir, name, ext);
     current_dir := dir;
     delete (current_dir, length (current_dir), 1);
     dispose (appl, done);
     exec (mv, path_buffer);
     writeln ('Press any key to return...');
     repeat until keypressed;
     key := readkey;
     appl := new (pappl, return);
     appl^.run;
end;

procedure call_chemview;

begin
     dispose (appl, done);
     exec (chemview, '');
     appl := new (pappl, return);
     appl^.run;
end;

procedure editany;

var
   result: integer;
   path_buffer: pathstr;
   buffer_1: string;
   filedialog: pfiledialog;
   dir: dirstr;
   name: namestr;
   ext: extstr;

begin
     chdir (current_dir);
     filedialog := new (pfiledialog, init ('*.*', 'Files', '~F~ile:',
                fdopenbutton, 100));
     if desktop^.execview (filedialog) <> cmcancel then
        filedialog^.getfilename (path_buffer)
     else path_buffer := '';
     dispose (filedialog, done);
     if path_buffer = '' then exit;
     fsplit (path_buffer, dir, name, ext);
     current_dir := dir;
     delete (current_dir, length (current_dir), 1);
     buffer_1 := path_buffer;
     dispose (appl, done);
     exec (editor, buffer_1);
     appl := new (pappl, return);
     appl^.run;
end;

procedure preview;

var
   result: integer;
   path_buffer: pathstr;
   buffer_1: string;
   filedialog: pfiledialog;
   dir: dirstr;
   name: namestr;
   ext: extstr;

begin
     chdir (current_dir);
     filedialog := new (pfiledialog, init ('*.mol', 'Files', '~F~ile:',
                fdopenbutton, 100));
     if desktop^.execview (filedialog) <> cmcancel then
        filedialog^.getfilename (path_buffer)
     else path_buffer := '';
     dispose (filedialog, done);
     if path_buffer = '' then exit;
     fsplit (path_buffer, dir, name, ext);
     current_dir := dir;
     delete (current_dir , length (current_dir), 1);
     buffer_1 := path_buffer;
     dispose (appl, done);
     swapvectors;
     exec (cascade + 'preview.exe', buffer_1 + ' ' + dats);
     swapvectors;
     appl := new (pappl, return);
     appl^.run;
     buffer_1 := dir;
     delete (buffer_1, length (buffer_1), 1);
     chdir (buffer_1);
end;

procedure tappl.handleevent (var event: tevent);

begin
     if event.what = evcommand then
        case event.command of
             cmparpov: begin
                       clearevent (event);
                       set_pov_params;
                       enable_commands;
             end;
             cmparjmr: begin
                       clearevent (event);
                       set_jmr_params;
                       enable_commands;
             end;
             cmrenpov: begin
                       clearevent (event);
                       render_pov;
             end;
             cmrenjmr: begin
                       clearevent (event);
                       render_jmr;
             end;
             cm3dv: begin
                    clearevent (event);
                    render_3dv;
             end;
             cmlismol: begin
                       clearevent (event);
                       input_file := 'LIS';
                       output_file := 'MOL';
                       call_cascade ('LIS2MOL', input_file, output_file, 102);
                       if (input_file <> '') and (output_file <> '') then
                          call_awk ('pac2mol.awk');
                       return_from_cascade;
             end;
             cmmolstr: begin
                       clearevent (event);
                       input_file := 'MOL';
                       output_file := 'STR';
                       call_cascade ('MOL2STR', input_file, output_file, 103);
                       if (input_file <> '') and (output_file <> '') then
                          call_awk ('mol2str.awk');
                       return_from_cascade;
             end;
             cmmolcoo: begin
                       clearevent (event);
                       input_file := 'MOL';
                       output_file := 'COO';
                       call_cascade ('MOL2COO', input_file, output_file, 103);
                       if (input_file <> '') and (output_file <> '') then
                          call_awk ('mol2coo.awk');
                       return_from_cascade;
             end;
             cmmoldat: begin
                       clearevent (event);
                       input_file := 'MOL';
                       output_file := 'DAT';
                       call_cascade ('MOL2DAT', input_file, output_file, 103);
                       if (input_file <> '') and (output_file <> '') then
                          call_awk ('mol2dat.awk');
                       return_from_cascade;
             end;
             cmmolpdb: begin
                       clearevent (event);
                       input_file := 'MOL';
                       output_file := 'PDB';
                       call_cascade ('MOL2PDB', input_file, output_file, 103);
                       if (input_file <> '') and (output_file <> '') then
                          call_awk ('mol2pdb.awk');
                       return_from_cascade;
             end;
             cmmolplu: begin
                       clearevent (event);
                       input_file := 'MOL';
                       output_file := 'SPF';
                       call_cascade ('MOL2SPF', input_file, output_file, 103);
                       if (input_file <> '') and (output_file <> '') then
                          call_awk ('mol2spf.awk');
                       return_from_cascade;
             end;
             cmsetpath: begin
                        clearevent (event);
                        set_paths;
                        enable_commands;
             end;
             cmmolpov: begin
                       clearevent (event);
                       dia_mol2pov;
             end;
             cmmol3dv: begin
                       clearevent (event);
                       input_file := 'MOL';
                       output_file := '3DV';
                       call_cascade ('MOL23DV', input_file, output_file, 103);
                       if (input_file <> '') and (output_file <> '') then
                          call_awk ('mol23dv.awk');
                       return_from_cascade;
             end;
             cmmoldt3: begin
                       clearevent (event);
                       input_file := 'MOL';
                       output_file := 'DT3';
                       call_cascade ('MOL2DT3', input_file, output_file, 103);
                       if (input_file <> '') and (output_file <> '') then
                          call_awk ('mol2dt3.awk');
                       return_from_cascade;
             end;
             cmxyzmol: begin
                       clearevent (event);
                       input_file := 'XYZ';
                       output_file := 'MOL';
                       call_cascade ('XYZ2MOL', input_file, output_file, 110);
                       if (input_file <> '') and (output_file <> '') then
                          call_awk ('xyz2mol.awk');
                       return_from_cascade;
             end;
             cmpdbmol: begin
                       clearevent (event);
                       input_file := 'PDB';
                       output_file := 'MOL';
                       call_cascade ('PDB2MOL', input_file, output_file, 109);
                       if (input_file <> '') and (output_file <> '') then
                          call_awk ('PDB2MOL.awk');
                       return_from_cascade;
             end;
             cmeditopt: begin
                        clearevent (event);
                        change_opt;
             end;
             cmeditdat: begin
                        clearevent (event);
                        editdat;
             end;
             cmcopying: begin
                        clearevent (event);
                        call_edit (cascade + 'copying');
             end;
             cmeditany: begin
                        clearevent (event);
                        editany;
             end;
             cmpreview: begin
                        clearevent (event);
                        preview;
             end;
             cmchem: begin
                     clearevent (event);
                     call_chemview;
             end;
             cmabout: begin
                      clearevent (event);
                      call_edit (cascade + 'about');
             end;
             cmpicview: begin
                        clearevent (event);
                        dispose (appl, done);
                        exec (picview, '');
                        appl := new (pappl, return);
             end;
             cmoutmol: begin
                       clearevent (event);
                       input_file := 'OUT';
                       output_file := 'MOL';
                       call_cascade ('OUT2MOL', input_file, output_file, 104);
                       if (input_file <> '') and (output_file <> '') then
                          call_awk ('vamp2mol.awk');
                       return_from_cascade;
             end;
             cmmolxyz: begin
                       clearevent (event);
                       input_file := 'MOL';
                       output_file := 'XYZ';
                       call_cascade ('MOL2XYZ', input_file, output_file, 103);
                       if (input_file <> '') and (output_file <> '') then
                          call_awk ('mol2xyz.awk');
                       return_from_cascade;
             end;
             cmmv: begin
                   clearevent (event);
                   call_mv;
             end;
             cmrenmov: begin
                       clearevent (event);
                       dia_mol2mov;
             end;
             cmfaq: begin
                    clearevent (event);
                    call_edit (cascade + 'faq');
             end;
             cmbugs: begin
                     clearevent (event);
                     call_edit (cascade + 'bugs');
             end;
             cmviewme: begin
                       clearevent (event);
                       call_edit (cascade + 'viewme');
             end;
        end;
     tapplication.handleevent (event);
end;

begin
     if paramcount = 0 then begin
        cascade := getenv ('cascade');
        command := getenv ('comspec');
        if cascade[length (cascade)] <> '\' then cascade := cascade + '\';
        current_dir := cascade;
        delete (current_dir, length (current_dir), 1);
        if notexist (cascade + 'cascade.ini') then ini_error;
        assign (files, cascade + 'cascade.ini');
        reset (files);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, dats);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, awk);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        if notexist (awk + 'pac2mol.awk') then awk := getenv ('awkdir');
        readln (files, dv);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, chemview);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, mv);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, jmr);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, jmr_bs);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, editor);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        path := getenv ('path');
        if notexist (editor) or (editor = '') then
           editor := fsearch ('edit.com', path);
        readln (files, awk_exe);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, pov);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, inc);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, w);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, h);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, gra);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, pal);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, picview);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, scaling);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, def);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, jjv);
        if ioresult <> 0 then ini_error;
        assign (files, cascade + 'bsp.opt');
        reset (files);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, camera.x);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, camera.y);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, camera.z);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, look_at.x);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, look_at.y);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, look_at.z);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, light_source.x);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, light_source.y);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, light_source.z);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, light_color);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, back_color);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, stick_color);
        if (ioresult <> 0) or (eof (files)) then ini_error;
        readln (files, include_file);
        if ioresult <> 0 then ini_error;
        close (files);
        if ioresult <> 0 then exit;

        appl := new (pappl, init);
        path_buffer := '*.out';
        historyadd (102, path_buffer);
        path_buffer := '*.def';
        historyadd (106, path_buffer);
        path_buffer := '*.jjv';
        historyadd (107, path_buffer);
        appl^.run;
        dispose (appl, done);
     end;
end.
