/* $Id: saol_macro.c,v 1.7 1997/11/20 16:40:38 eds Exp $ */
/* $Log: saol_macro.c,v $
 * Revision 1.7  1997/11/20  16:40:38  eds
 * Added ISO header.
 *
 * Revision 1.3  1997/11/15 00:43:22  luked
 * This is the result of the manual merge from the vendor branch for the
 * release tagged Fribourg_after_integration. I (brian) have probably lost
 * some history, but oh well.
 *
 * This contains the integration work by Eric Scheirer (MIT).
 *
 * Revision 1.5  1997/11/05  15:01:15  eds
 * Added vector parameters/return values/operators.
 *
 * Revision 1.4  1997/10/03  15:11:39  eds
 * Added sfsynth statement.
 *
 * Revision 1.3  1997/10/01  15:33:16  eds
 * Fixed bug in including tables in opcodes.
 *
 * Revision 1.2  1997/09/17  14:12:10  eds
 * Added spatialize statement.
 * */
/*********************************************************************

This software module was originally developed by

Eric D. Scheirer (MIT Media Laboratory)

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard.  ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation.

This software module is hereby released into the public domain.

***********************************************************************/

#include <string.h>
#include <stdlib.h>
#include "saol.h"
#include "saol_co_imp.h"
#include "y.tab.h"
#include <malloc.h>

typedef struct name_map_struct {
  char *namehead;
  struct name_map_elem_struct *names;
  int size;
} name_map;

typedef struct name_map_elem_struct {
  char *orig;
  char *new;
  expr *expr;
  int opwidth;
  long rate;
  int width;
} name_map_elem;
  
block *macro_expand_block(symtable *,instr_decl *,block *, name_map *, symtable *,
			  char *, int *, expr *, int);
expr *has_user_opcode(statement *,int);
expr *has_user_opcode_expr(expr *, int *);
void macro_expand_expr(instr_decl *, expr *, name_map *, symtable *, expr *, int);
name_map *add_name_map(symtable *,name_map *, expr *, int, int, expr *, expr **,int,int);
void replace_macro_name(expr *, symtable *, symtable *,name_map *, expr *);
expr *fake_md_array(expr *x, int xw, expr *y);
void cleanup_opcalls(instr_decl *);
void walk_block_mark_opcall(block *b, int *);
void walk_expr_mark_opcall(expr *, int *);
extern void block_rate(sa_decoder *, symtable *, block *, int, long, long);
expr *number(int);

void macro_expand(sa_decoder *sa) {
   /* put the opcodes into the instruments */
  instr_list *il;
  int ct = 0;

  for (il=sa->all->il;il;il=il->next) {
    if (sa->verbose) {
      printf("------------------------------------\n");
      print_block(il->i->code);
      printf("------------------------------------\n");
    }
    il->i->code = macro_expand_block(il->i->sym, il->i, il->i->code,
				     NULL,il->i->sym,NULL,&ct,NULL,1);
    block_rate(sa,il->i->sym, il->i->code, 0, ASIG, ASIG);
    remove_unused_symbols(sa,il->i,il->i->sym);
    cleanup_opcalls(il->i);
    if (sa->verbose) print_block(il->i->code);
    if (sa->verbose) dump_sym_table(il->i->sym);
  }
}


block *macro_expand_block(symtable *outer,
			  instr_decl *id, block *b,
			name_map *nm, symtable *t, char *lvalue,
			int *ct, expr *index, int maxindex) {

  /* the lvalue expression is a dummy lvalue needed for return */

  statement *p,*newst;
  block *last,*first,*opc,*newb,*hold;
  expr *op,*newindex,*newe,*idx,*idx2;
  char s[800];
  symbol *sym;
  int linect,newmax,i,j,pct,lastj;
  long newtype,fastest;
  symbol *newsym;
  name_map *new_nm;
  opcode_decl *decl;
  formalparam_list *fpl;
  exprlist *actl,*el,*lastel;

  first = b;
  for (last = NULL;b;last = b,b=b->next) {
    linect = 0;
    while (op = has_user_opcode(b->st,linect)) {
      linect++;
      sprintf(s,"__rtn%d",*ct);
      op->opdummy = strdup(s);

      decl = (opcode_decl *)op->defn->defn;

      sym = op->defn;

      switch (sym->type) {
      case IOPCODE: newtype = IVAR; break;
      case KOPCODE: newtype = KSIG; break;
      case AOPCODE: newtype = ASIG; break;
      case OPCODE: newtype = 0; break;   /* fix it up below */
      }
      
      newsym = add_sym_table_name(outer,s,newtype,NULL);
      newsym->imported = 0;
      newsym->exported = 0;
      newsym->glink = NULL;
      newsym->binding = LOCAL;
      newsym->mark = 1;
      newmax = maxindex;
      if (op->op == OPARRAY)
	newmax *= op->oparray_defn->width;
      newsym->width = newmax * decl->width;
      
      /* figure out the new names for symbols */
      new_nm = add_name_map(outer,nm,op,*ct,sym->width,index,&newindex,newmax,decl->width);
      hold = copy_block(decl->code);
      /* replace them in the code */
      (*ct)++;

      hold = macro_expand_block(outer,id,hold,new_nm,decl->sym,op->opdummy,ct,newindex,
				newmax);

      /* index = newindex; */
      fastest = 0;
      /* add assignments for the formal parameters */
      for (fpl=decl->params,actl=op->params;
	   fpl && fpl->fp;
	   fpl=fpl->next,actl=actl->next)
	if (fpl->fp && actl->p->op != IDENT) {  /* not call-by-ref */
	  p = new_statement(EQ,copy_expr(actl->p),NULL);
	  p->rate = fpl->fp->type != XSIG ? fpl->fp->type :
	                p->expr->rate;
	  if (p->rate > fastest) fastest = p->rate;
	  p->lvalue = new_expr(NULL,NULL,NULL,IDENT);
	  p->lvalue->d = new_terminal(IDENT,strdup(fpl->fp->n->name));
	  p->lvalue->width = fpl->fp->n->width;
	  macro_expand_expr(id,p->lvalue,new_nm,t,newindex,newmax);
	  macro_expand_expr(id,p->expr,nm,t,newindex,newmax);
	  newb = new_block();
	  add_block(newb,p);
	  if (!last) {  /* first */
	    for (opc=newb;opc;last=opc,opc=opc->next);
	    newb->next = first;
	    first = newb;
	    
	  } else {
	    newb->next = last->next;
	    last->next = newb;
	    last = newb;
	  }
	}
      if (!newsym->type) newsym->type = fastest; 

      /* paste the code in */
      for (opc=hold;opc && opc->next;opc=opc->next);
      if (opc) { /* o/w, null opcode */
	if (last) {
	  opc->next = last->next;
	  last->next = hold;
	  last = opc;
	} else {
	  opc->next = first;
	  first = hold;
	}
      }
      
    }

    p = b->st;
    switch (p->type) {
    case EQ:
      if (p->lvalue) macro_expand_expr(id,p->lvalue,nm,t,index,maxindex);
      macro_expand_expr(id,p->expr,nm,t,index,maxindex);
      break;
    case IF:
    case WHILE:
      macro_expand_expr(id,p->expr,nm,t,index,maxindex);
      p->b = macro_expand_block(outer,id,p->b,nm,t,lvalue,ct,index,maxindex);
      break;
    case ELSE:
      macro_expand_expr(id,p->expr,nm,t,index,maxindex);
      p->b = macro_expand_block(outer,id,p->b,nm,t,lvalue,ct,index,maxindex);
      p->elseb = macro_expand_block(outer,id,p->elseb,nm,t,lvalue,ct,index,maxindex);
      break;
    case OUTPUT:
    case OUTBUS:
    case INSTR:
    case SPATIALIZE:
      for (el = p->params;el && el->p;el=el->next)
	if (el->p) macro_expand_expr(id,el->p,nm,t,index,maxindex);
      break;
    case SFSYNTH:
      for (el = p->params; el && el->p; el=el->next)
	if (el->p) macro_expand_expr(id,el->p,nm,t,index,maxindex);
      for (el = p->sfextra; el && el->p; el=el->next)
	if (el->p) macro_expand_expr(id,el->p,nm,t,index,maxindex);
      break;
    case RETURN:
      for (el=p->params;el && el->p; el=el->next)
	macro_expand_expr(id,el->p,nm,t,index,maxindex);
      p->type = EQ;

      for (pct=0,el=p->params;el && el->p;pct += el->p->width,el=el->next);
      
      if (index && pct == 1) {
	p->lvalue = new_expr(index,NULL,NULL,ARRAYREF);
	p->lvalue->d = new_terminal(IDENT,lvalue);
	p->lvalue->d->sym = get_sym_decl(outer,lvalue);
	p->lvalue->width = 1;
	p->expr = p->params->p;
      }
      if (!index && pct == 1) {
        p->lvalue = new_expr(NULL,NULL,NULL,IDENT);
	p->lvalue->d = new_terminal(IDENT,lvalue);
	p->lvalue->d->sym = get_sym_decl(outer,lvalue);
	p->lvalue->width = 1;
	p->expr = p->params->p;
      }
      if (!index && pct != 1)
	for (i=0;i!=pct;i++) {
	  for (el=p->params,lastj=j=0,lastel=el;j<=i && el;lastj=j,j+=el->p->width,lastel=el,el=el->next);
	  if (lastel->p->width > 1) {
	    idx = number(i-lastj);
	    newe = new_expr(idx,NULL,NULL,ARRAYREF);
	    newe->d = copy_terminal(lastel->p->d);
	    newe->width = 1;
	  } else {
	    newe = copy_expr(lastel->p);
	  }
	  if (i==0) {
	    newst = p; p->type = EQ; p->expr = newe;
	  }
	  else newst = new_statement(EQ,newe,NULL);
	  newst->lvalue = new_expr(NULL,NULL,NULL,ARRAYREF);
	  newst->lvalue->d = new_terminal(IDENT,lvalue);
	  newst->lvalue->d->sym = get_sym_decl(outer,lvalue);
	  newst->lvalue->width = 1;
	  idx = number(i);
	  newst->lvalue->left = idx;
	  if (i) {
	    newb = new_block();
	    newb->st = newst;
	    newb->next = b->next;
	    b->next = newb;
	  }
	}
      
      if (index && pct != 1)
	for (i=0;i!=pct;i++) {
	  for (el=p->params,lastj=j=0,lastel=el;
	       j<=i && el;
	       lastj=j,j+=el->p->width,lastel=el,el=el->next);
	  if (lastel->p->width > 1) {
	    idx = number(i-lastj);
	    newe = fake_md_array(index,pct,idx);
	    newe = new_expr(newe,NULL,NULL,ARRAYREF);
	    newe->d = copy_terminal(lastel->p->d);
	    newe->width = 1;
	    
	  } else {
	    newe = copy_expr(lastel->p);
	  }
	  if (i==0) {
	    newst = p; p->type = EQ; p->expr = newe;
	  }
	  else newst = new_statement(EQ,newe,NULL);
	  newst->lvalue = new_expr(NULL,NULL,NULL,ARRAYREF);
	  newst->lvalue->d = new_terminal(IDENT,lvalue);
	  newst->lvalue->d->sym = get_sym_decl(outer,lvalue);
	  newst->lvalue->width = 1;
	  idx2 = number(i);
	  idx =  fake_md_array(index,pct,idx2); 
	  newst->lvalue->left = idx;
	  if (i) {
	    newb = new_block();
	    newb->st = newst;
	    newb->next = b->next;
	    b->next = newb;
	  }
	}
      break;      
    case EXTEND:
      macro_expand_expr(id,p->expr,nm,t,index,maxindex);
      break;
    case TURNOFF:
      break;
    }
  }
  return first; /* might have changed */
}

expr *has_user_opcode(statement *st,int ct) {
  /* if there are at least CT opcode calls embedded in this
     statement, return the CTth one */
  expr *p;
  exprlist *el;
  
  switch (st->type) {
  case EQ:
    if (st->lvalue && (p = has_user_opcode_expr(st->lvalue,&ct)))
      return p;
    if (p = has_user_opcode_expr(st->expr,&ct))
      return p;
    break;
  case IF:
  case WHILE:
  case ELSE:
  case EXTEND:
  case RETURN:
    for (el=st->params;el && el->p;el=el->next)
      if (p=has_user_opcode_expr(el->p,&ct))
	return p;
    break;
  case OUTPUT:
  case OUTBUS:
  case INSTR:
  case SPATIALIZE:
    for (el = st->params;el && el->p; el=el->next)
      if (el->p && (p=has_user_opcode_expr(el->p,&ct)))
	return p;
    break;
  case SFSYNTH:
    for (el = st->params; el && el->p; el=el->next)
      if (el->p && (p=has_user_opcode_expr(el->p,&ct)))
	return p;
    for (el = st->sfextra; el && el->p; el=el->next)
      if (el->p && (p=has_user_opcode_expr(el->p,&ct)))
	return p;
    
    break;
  }
  return NULL;
}

expr *has_user_opcode_expr(expr *p, int *ct) {
  expr *p2;
  exprlist *el;
  
  switch (p->op) {
  case IDENT:
  case NUMBER:
  case STRCONST:
    return NULL;
  case UMINUS:
  case LP:
  case NOT:
  case ARRAYREF:
    return(has_user_opcode_expr(p->left,ct));
  case Q:
    if (p2=has_user_opcode_expr(p->left,ct))
      return p2;
    if (p2=has_user_opcode_expr(p->right,ct))
      return p2;
    if (p2=has_user_opcode_expr(p->extra,ct))
      return p2;
    break;
  case LEQ:
  case GEQ:
  case EQEQ:
  case NEQ:
  case GT:
  case LT:
  case AND:
  case OR:
  case PLUS:
  case MINUS:
  case STAR:
  case SLASH:
    if (p2=has_user_opcode_expr(p->left,ct))
      return p2;
    if (p2=has_user_opcode_expr(p->right,ct))
      return p2;
    break;
  case OPCALL:
  case OPARRAY:
    if (!is_core_opcode(p->d->iname)) {
      if (!*ct)
	return p;
      (*ct)--;
    }
    for (el=p->params;el && el->p;el=el->next)
      if (el->p && (p2=has_user_opcode_expr(el->p,ct)))
	return p2;
    if (p->op == OPARRAY)
      if (p2 = has_user_opcode_expr(p->left,ct))
	return p2;
    break;
  }
  return NULL;
}
    

expr *fake_md_array(expr *x, int xw, expr *y) {
  /* return [x][y], which is really [x * xw + y], where xw is the
     width of the major dimension */
  expr *e;
  char s[200];

  if (x) {
    e = number(xw);
    e = new_expr(new_expr(copy_expr(x),e,NULL,STAR),copy_expr(y),NULL,PLUS);
    e->width = 1;
    e->left->width = 1;
  }
  else e = y;
  return e;
}

void macro_expand_expr(instr_decl *id, expr *p,
		       name_map *nm, symtable *t, expr *index, int maxwidth) {

  exprlist *el;
  expr *new;
  symbol *newsym;
  char s[800];
  
  
  switch (p->op) {
  case IDENT:
    replace_macro_name(p,id->sym,t,nm,index);
    break;
  case NUMBER:
  case STRCONST:
    break;
  case ARRAYREF:
    macro_expand_expr(id,p->left,nm,t,index,maxwidth);
    replace_macro_name(p,id->sym,t,nm,index);
    break;
  case OPARRAY:
    macro_expand_expr(id,p->left,nm,t,index,maxwidth);

    if (p->width) {
      p->left = new_expr(p->left,number(p->width),NULL,STAR);
      p->left->width = p->left->left->width;
    }
    p->left = fake_md_array(index,p->oparray_defn->width,p->left);
    
    if (!is_core_opcode(p->d->iname)) {
      p->op = ARRAYREF;
      p->d = new_terminal(IDENT,p->opdummy);
      p->d->sym = get_sym_decl(id->sym,p->opdummy);
    }
    else {
      for (el = p->params; el && el->p; el=el->next)
	macro_expand_expr(id,el->p,nm,t,index,maxwidth);

      p->oparray_defn = get_sym_decl_last(id->sym,p->d->iname);
    }
    break;
  case OPCALL:
    if (!is_core_opcode(p->d->iname)) {
      if (index) {
	p->op = ARRAYREF;
	p->left = copy_expr(index);
      } else {
	p->op = IDENT;
      }
      p->d = new_terminal(IDENT,p->opdummy);
      p->d->sym = get_sym_decl(id->sym,p->opdummy);
    }
    else
      if (index) {
	p->op = OPARRAY;
	p->left = index;
	newsym = add_sym_table_name(id->sym,p->d->iname,OPARRAY,NULL);
	newsym->width = maxwidth; 
	newsym->mark = 1;
	p->oparray_defn = newsym;
      }
      for (el = p->params;el && el->p; el=el->next)
	macro_expand_expr(id,el->p,nm,t,index,maxwidth);
    break;
  case UMINUS:
  case LP:
  case NOT:
    macro_expand_expr(id,p->left,nm,t,index,maxwidth);
    break;
  case Q:
    macro_expand_expr(id,p->left,nm,t,index,maxwidth);
    macro_expand_expr(id,p->right,nm,t,index,maxwidth);
    macro_expand_expr(id,p->extra,nm,t,index,maxwidth);
    break;
  case LEQ:
  case GEQ:
  case EQEQ:
  case NEQ:
  case GT:
  case LT:
  case AND:
  case OR:
  case PLUS:
  case MINUS:
  case STAR:
  case SLASH:
    macro_expand_expr(id,p->left,nm,t,index,maxwidth);
    macro_expand_expr(id,p->right,nm,t,index,maxwidth);
    break;
  }
}

name_map *add_name_map(symtable *outer,name_map *old,
		       expr *opexp,int opct,int opwidth,
		       expr *index, expr **newindex, int maxwidth, int declwidth) {
  name_map *new;
  int ct = 0;
  opcode_decl *decl;
  symtable *t,*t2;
  symbol *newsym;
  formalparam_list *fpl;
  exprlist *actl,*el;
  long fastest;
  char width[20];
  expr *e,*dw;

  PROT_MAL(new,name_map,addname_map);
  new->namehead = (char *)malloc(1000 * sizeof(char));

  if (opexp->op == OPARRAY) {

    if (old)
      sprintf(new->namehead,"%s_%s_arr",old->namehead,opexp->d->iname);
    else
      sprintf(new->namehead,"__%s_arr",opexp->d->iname,opct);
    
    *newindex = fake_md_array(index,opexp->oparray_defn->width,opexp->left);
    
  }
				       
  else /* OPCODE */ {
    *newindex = index;
    if (old)
      sprintf(new->namehead,"%s_%s%d",old->namehead,opexp->d->iname,opct);
    else
      sprintf(new->namehead,"__%s%d",opexp->d->iname,opct);
  }

  decl = (opcode_decl *)opexp->defn->defn;
  for (t=decl->sym;t && t->s;t=t->next) {
    if (t->s && !t->s->imported && !t->s->exported
	) /* not global */
      ct++;
  }
  for (fpl = decl->params; fpl && fpl->fp;fpl=fpl->next) ct++;

  new->size = ct;
  new->names = (name_map_elem *)calloc(ct,sizeof(name_map_elem));

  ct = 0;
  fastest = 0;
  for (t=decl->sym;t && t->s;t=t->next) { /* go through all symbols */
     if (t->s) {
       new->names[ct].orig = t->s->name;
       new->names[ct].new = NULL;
       
       if (t->s->binding == FORMALPARAM) { /* if it's a fp */
	 for (t2=decl->sym,el=opexp->params;
	      t2->s != t->s;
	      t2 = t2->next)
	   if (t2->s->binding == FORMALPARAM)
		el=el->next; /* find matching actual param */
	    if (el->p->op == IDENT) { /* call by reference */
	      e = copy_expr(el->p);
	      replace_macro_name(e,outer,decl->sym,old,index);
	      new->names[ct].new = strdup(e->d->iname);
	    }
	    /* so the replacement is the act param expression */
	  }

	  if (t->s->binding == STANDARD_NAME
	      || (t->s->binding == LOCAL &&
		  (t->s->imported || t->s->exported))){  /* leave unchanged */
            if (!get_sym_decl(outer,t->s->name)) {
	      newsym = add_sym_table_name(outer,t->s->name,t->s->type,NULL);
	      newsym->width = t->s->width * maxwidth;
	      newsym->imported = t->s->imported; 
	      newsym->exported = t->s->exported;
	      newsym->glink = t->s->glink;
	      newsym->mark = 1;
	    }
	    new->names[ct].new = strdup(t->s->name);
	  }


	  if (t->s->type == OPARRAY) {
	    newsym = add_sym_table_name(outer,t->s->name,t->s->type,NULL);
	    newsym->width = t->s->width * maxwidth;
	    newsym->imported = t->s->imported; 
	    newsym->exported = t->s->exported;
	    newsym->glink = t->s->glink;
	    newsym->mark = 1;
	    new->names[ct].new = strdup(t->s->name);
	  }

	  if (!new->names[ct].new) { /* not any of the above */
	    new->names[ct].new =
	      (char *)malloc(sizeof(char) *
			     (strlen(new->namehead) + strlen(t->s->name) +2));
	    sprintf(new->names[ct].new,"%s_%s",new->namehead,t->s->name);
	    newsym = add_sym_table_name(outer,new->names[ct].new,t->s->type,NULL);
	    
	    if (t->s->type == XSIG && t->s->binding == FORMALPARAM) {
	      for (t2=decl->sym,el=opexp->params;
		 t2->s != t->s;
		 t2 = t2->next)
		if (t2->s->binding == FORMALPARAM)
		  el=el->next; /* find matching actual param */
	      newsym->type = el->p->rate;
	      if (newsym->type > fastest)
		fastest = newsym->type;
	    }

	    if (newsym->type == XSIG) newsym->type = fastest;
	    
	    if (t->s->type == TABLE)
	      newsym->table = t->s->table; /* copy_exprlist(t->s->table->params); */
	    newsym->width = t->s->width * maxwidth;

	    if (t->s->binding != FORMALPARAM) {
	      newsym->imported = t->s->imported;
	      newsym->exported = t->s->exported;
	    }
	    newsym->glink = NULL;
	    newsym->binding = LOCAL;
	    newsym->mark = 1;

	    if (opexp->op == OPARRAY) { /* oparray */ 
	      new->names[ct].expr =
		new_expr(number(t->s->width),copy_expr(*newindex),NULL,STAR);
	      new->names[ct].expr->width = 1;
	    }
	  }
	  new->names[ct].rate = t->s->type;
	  new->names[ct].width = t->s->width;
	  ct++;
     }

     
   }
  return new;
}


void replace_macro_name(expr *p, symtable *outer, symtable *t,
			name_map *nm, expr *index) {
  /* p is an ident or an arrayref */

  expr *new;
  symbol *old;
  char s[800];
  int i;

  if (!nm) return;
  for (i=0;i!=nm->size && strcmp(nm->names[i].orig,p->d->iname);i++);
  if (i == nm->size) return; /* no replacement */

  p->d->iname = nm->names[i].new;
  p->d->sym = get_sym_decl(outer,nm->names[i].new);
  old = get_sym_decl(t,nm->names[i].orig);
  p->rate = nm->names[i].rate;
  p->width = nm->names[i].width;

  if (nm->names[i].expr) { /* oparray */
    p->op = ARRAYREF;
    if (p->left)
      p->left = fake_md_array(nm->names[i].expr,old->width,p->left);
    else
      p->left = fake_md_array(NULL,0,nm->names[i].expr);
  }

}

void cleanup_opcalls(instr_decl *id) {
  symtable *t,*first,*last;
  int ct=0;

  last=NULL; first=t=id->sym;
  while (t && t->s) {
    if (t->s->type == OPARRAY) {
      if (is_core_opcode(t->s->name)) {
	t->s->offset = ct;
	ct += t->s->width;
	last = t;
	t=t->next;
      } else { /* remove */
	first = id->sym = remove_sym_table(first,last,&t);
      }
    } else {
      last = t;
      t = t->next;
    }
  }

  walk_block_mark_opcall(id->code, &ct);
  id->opsize = ct;

}

void walk_block_mark_opcall(block *b, int *ct) {
  exprlist *el;
  
  for (b; b; b=b->next) 
    switch (b->st->type) {
    case EQ:
      if (b->st->lvalue) walk_expr_mark_opcall(b->st->lvalue,ct);
      walk_expr_mark_opcall(b->st->expr,ct);
      break;
    case IF:
    case WHILE:
      walk_expr_mark_opcall(b->st->expr,ct);
      walk_block_mark_opcall(b->st->b,ct);
      break;
    case ELSE:
      walk_expr_mark_opcall(b->st->expr,ct);
      walk_block_mark_opcall(b->st->b,ct);
      walk_block_mark_opcall(b->st->elseb,ct);
      break;
    case EXTEND:
      walk_expr_mark_opcall(b->st->expr,ct);
      break;
    case RETURN:
      interror("return() still left in code.");
      break;
    case OUTPUT:
    case OUTBUS:
    case INSTR:
    case SPATIALIZE:
      for (el = b->st->params;el && el->p; el=el->next)
	walk_expr_mark_opcall(el->p,ct);
      break;
    case SFSYNTH:
      for (el = b->st->params;el && el->p; el=el->next)
	walk_expr_mark_opcall(el->p,ct);
      for (el = b->st->sfextra;el && el->p; el=el->next)
	walk_expr_mark_opcall(el->p,ct);
      break;
  }
}
  
void walk_expr_mark_opcall(expr *p, int *ct) {
  exprlist *el;

  switch(p->op) {
    
  case IDENT:
  case NUMBER:
  case STRCONST:
    break;
  case ARRAYREF: 
  case UMINUS:
  case LP:
  case NOT:
    walk_expr_mark_opcall(p->left,ct);
    break;
  case OPARRAY:
    walk_expr_mark_opcall(p->left,ct);
    for (el = p->params;el && el->p; el = el->next)
      walk_expr_mark_opcall(el->p,ct);
    break;
  case OPCALL:
    p->op_offset = (*ct)++;
    for (el = p->params;el && el->p; el = el->next)
      walk_expr_mark_opcall(el->p,ct);
    break;
  case Q:
    walk_expr_mark_opcall(p->left,ct);
    walk_expr_mark_opcall(p->right,ct);
    walk_expr_mark_opcall(p->extra,ct);
    break;
  case LEQ:
  case GEQ:
  case EQEQ:
  case NEQ:
  case GT:
  case LT:
  case AND:
  case OR:
  case PLUS:
  case MINUS:
  case STAR:
  case SLASH:
    walk_expr_mark_opcall(p->left,ct);
    walk_expr_mark_opcall(p->right,ct);
    break;
  }
}

expr *number(int x) {
  expr *newe;
  terminal *newt;
  char s[100];

  newe = new_expr(NULL,NULL,NULL,NUMBER);
  newe->width = 1;
  sprintf(s,"%d",x);
  newt = new_terminal(NUMBER,s);
  set_expr_data(newe,newt);
  return(newe);
}
