/* $Id */
/* $Log */
/*********************************************************************

This software module was originally developed by

Eric D. Scheirer (MIT Media Laboratory)

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard.  ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation.

This software module is hereby released into the public domain.

***********************************************************************/

/***********************************************************************\
*	fft.h								*
*   Fast Fourier Transform C library - header file			*
*   Based on RECrandell's						*
*   dpwe 22jan90							*
*   08apr90 With experimental FFT2torl - converse of FFT2real		*
\***********************************************************************/

/*  
    To call an FFT, one must first assign the complex exponential factors:
    A call such as
	e = AssignBasis(NULL, size)
    will set up the complex *e to be the array of cos, sin pairs corresponding
    to total number of complex data = size.   This call allocates the
    (cos, sin) array memory for you.  If you already have such memory
    allocated, pass the allocated pointer instead of NULL.
 */

/*** how can it be so hard to get PI *?***/
#ifndef PI
#ifdef M_PI
#define PI M_PI
#else
#define PI 3.1415926535
#endif
#endif

typedef double real;

/*** yukky ansi bodge ***/
#ifndef FLOATARG
#define FLOATARG double /* some prototype checkers get funny about promotion */
#endif

typedef struct {
    real re, im;
    } complex;

typedef struct lnode
    {
    struct lnode *next;
    long		 size;
    complex	 *table;
    } LNODE;

int scancomplexdata(complex *);
void putcomplexdata(complex *, long);
void ShowCpx(complex *, long, char *);
int PureReal(complex *, long);
int IsPowerOfTwo(long);
complex *FindTable(long);	/* search our list of existing LUT's */
complex *AssignBasis(complex *, long);
void reverseDig(complex *, long, int);
void FFT2dimensional(complex *, long, long, complex *);
void FFT2torl(complex *, long, int, FLOATARG, complex *);
void ConjScale(complex *, long, FLOATARG);
void FFT2real(complex *, long, int, complex *);
void Reals(complex *, long, int, int, complex *);
void FFT2(complex *, long, int, complex *);
void FFT2raw(complex *, long, int, int, complex *);
void FFTarb(complex *, complex *, long, complex *);
void DFT(complex *, complex *, long, complex *);

