/*****************************************************************************/
/* This software module was originally developed by                          */
/*   Akio Jin (NTT)                                                          */
/* and edited by                                                             */
/*   Naoki Iwakami (NTT) on 1997-04-18,                                      */
/*   Akio Jin (NTT),                                                         */
/*   Mineo Tsushima, (Matsushita Electric Industrial Co Ltd.)                */
/*   and Tomokazu Ishikawa (Matsushita Electric Industrial Co Ltd.)          */
/*   on 1997-10-23,                                                          */
/* in the course of development of the                                       */
/* MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 14496-1,2 and 3.        */
/* This software module is an implementation of a part of one or more        */
/* MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 Audio */
/* standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio standards   */
/* free license to this software module or modifications thereof for use in  */
/* hardware or software products claiming conformance to the MPEG-2 NBC/     */
/* MPEG-4 Audio  standards. Those intending to use this software module in   */
/* hardware or software products are advised that this use may infringe      */
/* existing patents. The original developer of this software module and      */
/* his/her company, the subsequent editors and their companies, and ISO/IEC  */
/* have no liability for use of this software module or modifications        */
/* thereof in an implementation. Copyright is not released for non           */
/* MPEG-2 NBC/MPEG-4 Audio conforming products. The original developer       */
/* retains full right to use the code for his/her  own purpose, assign or    */
/* donate the code to a third party and to inhibit third party from using    */
/* the code for non MPEG-2 NBC/MPEG-4 Audio conforming products.             */
/* This copyright notice must be included in all copies or derivative works. */
/* Copyright (c)1997.                                                        */
/*****************************************************************************/

#include "tf_main.h"
#include "ntt_conf.h"
#include "ntt_scale_conf.h"
#include "mat_def_ntt.h"

void ntt_scale_vq_decoder(ntt_INDEX  *indexp,
			  double *spectral_line_vector[MAX_TIME_CHANNELS],
			  int    iscl)
{
  static double flat_spectrum[ntt_T_FR_MAX], spectrum[ntt_T_FR_MAX];
  int    ismp, i_sup, top;
  double spectrum_gain;

  /*--- Requantize flattened MDCT coefficients ---*/
/*
  ntt_scale_tf_requantize_spectrum(indexp, flat_spectrum, iscl);
*/
  mat_scale_tf_requantize_spectrum(indexp, flat_spectrum, iscl);

  /*--- Decode side information */
  ntt_scale_tf_proc_spectrum_d(indexp, flat_spectrum, spectrum, iscl);

  /*--- Spectrum line normalization
    (for gain alignment of NTT & MPEG4 VM MDCT ---*/
  switch(indexp->w_type){
  case ONLY_SHORT_WINDOW:
    spectrum_gain = sqrt((double)ntt_N_FR_S*2.);
    break;
  case ONLY_MEDIUM_WINDOW:  case MEDIUM_SHORT_WINDOW:
  case SHORT_MEDIUM_WINDOW:
    spectrum_gain = sqrt((double)ntt_N_FR_M*2.);
    break;
  default: /* long */
    spectrum_gain = sqrt((double)ntt_N_FR*2.);
  }
  for (i_sup=0; i_sup<ntt_N_SUP; i_sup++){
    top = i_sup * ntt_N_FR;
    for (ismp=0; ismp<ntt_N_FR; ismp++){
      spectral_line_vector[i_sup][ismp] += spectrum[ismp+top]*spectrum_gain;
    }
  }
}
