/*****************************************************************************/
/* This software module was originally developed by                          */
/*   Naoki Iwakami (NTT)                                                     */
/* and edited by                                                             */
/*   Naoki Iwakami and Satoshi Miki (NTT) on 1996-05-01,                     */
/*   Naoki Iwakami (NTT) on 1996-08-27,                                      */
/*   Naoki Iwakami (NTT) on 1996-12-06,                                      */
/*   Naoki Iwakami (NTT) on 1997-04-18,                                      */
/*   Takehiro Moriya (NTT) on 1997-08-01,                                    */
/*   Naoki Iwakami (NTT) on 1997-08-25,                                      */
/*   Akio Jin (NTT) on 1997-10-23,                                           */
/* in the course of development of the                                       */
/* MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 14496-1,2 and 3.        */
/* This software module is an implementation of a part of one or more        */
/* MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 Audio */
/* standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio standards   */
/* free license to this software module or modifications thereof for use in  */
/* hardware or software products claiming conformance to the MPEG-2 NBC/     */
/* MPEG-4 Audio  standards. Those intending to use this software module in   */
/* hardware or software products are advised that this use may infringe      */
/* existing patents. The original developer of this software module and      */
/* his/her company, the subsequent editors and their companies, and ISO/IEC  */
/* have no liability for use of this software module or modifications        */
/* thereof in an implementation. Copyright is not released for non           */
/* MPEG-2 NBC/MPEG-4 Audio conforming products. The original developer       */
/* retains full right to use the code for his/her  own purpose, assign or    */
/* donate the code to a third party and to inhibit third party from using    */
/* the code for non MPEG-2 NBC/MPEG-4 Audio conforming products.             */
/* This copyright notice must be included in all copies or derivative works. */
/* Copyright (c)1996.                                                        */
/*****************************************************************************/

/* 06-dec-96   NI   provided 6 kbit/s support */
/* 25-aug-97   NI   bugfixes */

#define ntt_MAIN_ROUTINE

#include "common.h"
#include "ntt_conf.h"
#include "ntt_scale_conf.h"
#include "mat_def_ntt.h"

void ntt_TfInit(float sampling_rate,
		float bit_rate,
		float t_bit_rate_scl,
		long num_channel,
		int  *frameNumSample,
		int  *delayNumSample,
		int  *med_win_in_long,
		int  *short_win_in_long)
{
  /*--- Set sampling frequency mode ---*/
  switch((int)(sampling_rate+0.5)){
  case 48000:
    ntt_ISAMPF = 48;
    break;
  case 16000:
    ntt_ISAMPF = 16;
    break;
  case 8000:
    ntt_ISAMPF = 8;
    break;
  default:
    CommonExit(1,"NTT_EncTfFrame: sampling rate %d Hz is not supported",
	       (int)(sampling_rate+0.5));
  }

  /*--- Set bitrate mode ---*/
  ntt_IBPS = (int)((bit_rate-t_bit_rate_scl+0.5)/1000.);

  /*--- Set channel mode ---*/
  switch(num_channel){
  case 1:
    ntt_CH_MODE = 0;
    break;
  case 2:
    ntt_CH_MODE = 1;
    break;
  default:
    CommonExit(1,"NTT_EncTfFrame: number of channel %d is not supported",
	       num_channel);
  }

  ntt_init();

  *frameNumSample = ntt_N_FR;
  *delayNumSample = ntt_N_FR;
  *med_win_in_long = ntt_N_MID;
  *short_win_in_long = ntt_N_SHRT;

}
