#include <iostream.h> 
#include "JMidiType.h"
#include "assert.h"


JMidiOutType midiInToOut(JMidiInType in)
{
  switch(in.type()) {
  case JMidiInType::NOTEON:
  case JMidiInType::NOTEOFF:
    return JMidiOutType::NOTE_EFFECT;

  case JMidiInType::CONTROLLER:
    return JMidiOutType::CNTRL_EFFECT;
      
  case JMidiInType::PITCHBEND:
    return JMidiOutType::PITCHBEND_EFFECT;
      
  case JMidiInType::PROGRAM:
    return JMidiOutType::PROGRAM_EFFECT;
      
  case JMidiInType::PRESSURE:
    return JMidiOutType::CHNPRESSURE_EFFECT;

  default:
    cout << "JMidiInType " << in.type() << " unkown " << endl;
    return JMidiOutType::NO_EFFECT;
  }
}





