#include <iostream.h>

#include <sys/types.h>
#include <unistd.h>
#include <sys/soundcard.h>       

#include "JOSSMidiIn.h"

//
// Something else feeds the crack function wit raw midi data.
//

void
JOSSMidiIn::crack(unsigned char *buf,int *bufp)
{

  int cntrl;

#ifdef J_DEBUG
  cout << " MidiIn::crack " << endl;
#endif


  switch (buf[0] & 0xf0) {
  case 0x90:	/* Note on */
    if (*bufp < 3) break;
    if (buf[2])  {  // Note on case
      _midiEvent.setBuffer(buf);
      notifyObservers(_midiEvent);
    }  else   {
      _midiEvent.setBuffer(buf);
      notifyObservers(_midiEvent);
    }
    *bufp=1;
    break;
    
  case 0xb0:	/* Control change */
    if (*bufp < 3) break;
    cntrl=buf[1];
    _midiEvent.setBuffer(buf);
    notifyObservers(_midiEvent);
    *bufp=1;
    break;
    
  case 0x80:	/* Note off */
    if (*bufp < 3) break;
    _midiEvent.setBuffer(buf);
    notifyObservers(_midiEvent);
    *bufp=1;
    break;
    
  case 0xe0:	/* Pitch bender */
    if (*bufp < 3) break;
    _midiEvent.setBuffer(buf);
    notifyObservers(_midiEvent);

    // I think not
    //    value = ((buf[2] & 0x7f) << 7) | (buf[1] & 0x7f);
    //    pitch_bender(ch, value-8192);

    *bufp=1;
    break;
    
  case 0xc0:	/* Pgm change */
    if (*bufp < 2) break;
    _midiEvent.setBuffer(buf);
    notifyObservers(_midiEvent);
    *bufp=0;
    break;
    
  case 0xd0:	/* Channel pressure */
    if (*bufp < 2) break;
    _midiEvent.setBuffer(buf);
    notifyObservers(_midiEvent);
    *bufp=1;
    break;
    
  default:
    *bufp=0;
  }
}



bool
JOSSMidiIn::readMidi()
{
  static  unsigned char buf[100];
  static  int bufp=0;
  unsigned char ev[4];
  int i,n;

  //  if (_handler == 0) return FALSE;

  if((n=read(_fd, ev, sizeof(ev)))==-1) 
    return false;
  
  if ( n == 0 ) return false;

#ifdef J_DEBUG
  cout << n << " " << ev[0] << " " << ev[1] << " " << ev[2] << " " << ev[3]<< " "  << bufp << endl;
#endif

  for(i=0; i<=(n/4); i++)  {
    unsigned char *p = &ev[i*4];
    if(p[0]==SEQ_MIDIPUTC && p[2]==0) {
      if(p[1] & 0x80)  {                  /* Status */
	if(bufp) crack(buf,&bufp);
	buf[0] = p[1]; bufp=1;
      }  else if(bufp) {
	buf[bufp++] = p[1];
	if ((buf[0] & 0xf0) == 0x90 || (buf[0] & 0xf0) == 0x80 
	    || (buf[0] & 0xf0) == 0xb0 || (buf[0] & 0xf0) == 0xe0)  {
	  if(bufp==3)  crack(buf,&bufp);
	} else  if ((buf[0] & 0xf0) == 0xc0 || (buf[0] & 0xf0) == 0xd0)  {
	  if(bufp==2)  crack(buf,&bufp);
	}
      }
    }
  }
  return true;
}












