#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <iostream.h>
#include <sys/soundcard.h>       



#include "jam/JDeviceManager.h"
#include "jam/JMidiInDriver.h"


// Need to hang my midiIn off a timer interupt.

#include "it/JITScheduler.h"

#include "kmid/fmout.h"
#include "kmid/gusout.h"

#include "JOSSDeviceManager.h"
#include "JOSSMidiIn.h"
#include "JAweDevice.h"
#include "JKmidDevice.h"

#ifdef J_HAVE_AWE
#include <linux/awe_voice.h>
#include "awe_effect.h"
#endif


SEQ_DEFINEBUF (2048);

SEQ_PM_DEFINES; /* patch manager stuff */

/* global for some of the of patch stuff yuck */
int awe_dev = -1;
int seqfd   = -1;

void seqbuf_dump (void)
{
  if (_seqbufptr)
    if (write (seqfd, _seqbuf, _seqbufptr) == -1)
      {
	cerr << "write /dev/sequencer" << endl;
	exit (-1);
      }
  _seqbufptr = 0;
}

#define DEB(x)

#define SEQUENCER_PATH "/dev/sequencer"



JOSSDeviceManager::JOSSDeviceManager(JDeviceManager *manager,
	JScheduler *sched)
  : _midiInDriver(0)
{

  buildDevices(manager);

  if (_midiInDriver != 0)
    sched->setSliceClient(_midiInDriver);

}

void
JOSSDeviceManager::buildDevices(JDeviceManager *manager)
{

  struct synth_info _synthinfo[MAX_OUT_DEVICE];

  int i;

  if((seqfd = open(SEQUENCER_PATH, O_RDWR+O_NONBLOCK, 0)) == -1)   {
    cerr << "Cannot open " SEQUENCER_PATH ". \n";
    return;
  } else {
    JPolledMidiIn *midiIn;
    manager->addInDevice( midiIn = new JOSSMidiIn(seqfd) );
    _midiInDriver = new JMidiInDriver(midiIn);
  }
  
  int n;
  if (ioctl (seqfd, SNDCTL_SEQ_NRSYNTHS, &n) == -1)  {
    cerr << "ioctl (seqfd, SNDCTL_SEQ_NRSYNTHS, &n) == -1) failed " << endl;
  }

  assert(n < MAX_OUT_DEVICE);

  for (i = 0; i < n; i++) {
    _synthinfo[i].device = i;

    
    if (ioctl (seqfd, SNDCTL_SYNTH_INFO, &_synthinfo[i]) == -1)	{
      cerr << "ioctl (seqfd, SNDCTL_SYNTH_INFO, &_synthinfo[i]) failed" <<endl	;
    }

    printf("----");
    printf("Device : %d\n",i);
    printf("Name : %s\n",_synthinfo[i].name);

    midiOut * midiout=0;
    switch (_synthinfo[i].synth_type) {
    case SYNTH_TYPE_SAMPLE:
      switch(_synthinfo[i].synth_subtype) {

#ifdef J_HAVE_AWE
      case SAMPLE_TYPE_AWE32:
	awe_dev=i;
	manager->addOutDevice(new JAweDevice(i));
	cout << " AWE found with " << _synthinfo[i].nr_voices << " voices " << endl;
	AWE_SET_CHANNEL_MODE(i,1);
	break;
#endif

      case SAMPLE_TYPE_GUS:
	manager->addOutDevice(new JKmidDevice(midiout=new gusOut(i,_synthinfo[i].nr_voices)));
	break;
      default:
	assert(0);
	break;
      }
      break;
    case SYNTH_TYPE_FM:
      manager->addOutDevice(new JKmidDevice(midiout=new fmOut(i,
_synthinfo[i].nr_voices)));
      break;

    default:
      cerr << " Unkown synth type " << endl;
      break;
    }
    
    if (midiout != 0 ) {
      midiout->openDev(seqfd);
      midiout->initDev();
    }
  }

  midiOut * midiout;
  manager->addOutDevice(new JKmidDevice(midiout=new midiOut(0)));
  midiout->openDev(seqfd);
  midiout->initDev();

}


#include "JOSSDevice.h"


bool
JOSSDevice::handle(JMidiOutEvent e)
{


  switch(e.type()) {
  case  JMidiOutType::NOTE_EFFECT:
	
    if (e.value() == 0) {
      SEQ_STOP_NOTE(_devId, e.channelId(), e.index(), 0);
    }  else {
      SEQ_START_NOTE(_devId, e.channelId(), e.index(), e.value());
    }
    break;
  
  case JMidiOutType::PITCHBEND_EFFECT:
    SEQ_PITCHBEND(_devId, e.channelId(), e.value());
    break;

  case JMidiOutType::CNTRL_EFFECT:
    SEQ_CONTROL(_devId, e.channelId(), e.index(), e.value());
    break;

  case JMidiOutType::PROGRAM_EFFECT:
    SEQ_SET_PATCH(_devId, e.channelId(), e.value());
    break;

  case JMidiOutType::CHNPRESSURE_EFFECT:
    SEQ_CHN_PRESSURE(_devId, e.channelId() , e.value());
    break;

  default:
    return false;
  }
  
  SEQ_DUMPBUF();
  return true;

}






#ifdef J_HAVE_AWE

#include "JAweDevice.h"

bool
JAweDevice::handle(JMidiOutEvent e)
{

  int cval;
  switch(e.type()) {
  case JMidiOutType::AUX_EFFECT:
    if (e.index() < AWE_FX_SAMPLE_START)
      cval = awe_effects[e.index()].convert(e.value());
    else
      cval = e.value();
    
    AWE_SEND_EFFECT(_devId,e.channelId(),e.index(),cval);
    break;
    
  case JMidiOutType::RESET_EFFECT:
    AWE_TERMINATE_CHANNEL(_devId,e.channelId());
    break;
    
  case JMidiOutType::ALLNOTEOFF_EFFECT:
    AWE_NOTEOFF_ALL(_devId);
    break;

  default:
    return JOSSDevice::handle(e);    
  }

  SEQ_DUMPBUF();
  return true;
  


}
 
#endif
  


