#ifndef _JVoice_H
#define _JVoice_H

// Handles midi out events
// Also used to record output via recordEffect

#include "assert.h"
#include "base/JOSTemplate.h"
#include "JPlayer.h"
#include "command/JPlayerCommand.h"
#include "rep/JMidiInEvent.h"
#include "rep/JMidiOutEvent.h"
#include "rep/JVoiceUpdate.h"

class JMapper;
class JEvent;
class JCommand;
class JMidiInEvent;
class JMidiOut;

class JVoice : public JPlayer, public JName,
	       public JObserver<JMidiInEvent,void>,
	       public JSubject <JVoiceUpdate,void>
{

  // TODO de-hack this
friend class QJMapperWidget;
friend class QJVoiceWidget;

public:

  // Mostly called by the voice manager
  JVoice(JMapper * mapper,JMidiOut *, const char *name);


  virtual ~JVoice();

  /// CONCRETE JHandlers

  void              handle(JMidiInEvent);
  void              handle(JPlayerCommand);

  // JPlayer
  void              handle(JMidiOutEvent);

  JVoice *          voice() {return this;}
  JEffectList *     effectList();

  /// Personal stuff

  const char *      name() const { return "Voice"; }

  void              setMonitor(JMidiOut *);
  void              setProgramId(int prog);
  void              setBankId(int bank);
  void              setDeviceId(int id);
  const char *      defaultDeviceName() const;
  int               deviceId() const;
  int               programId() const;
  int               bankId() const;
  int               channelId() const; 
  void              setChannelId(int);
  void              resetVoice();
  bool              isMute() const { return _mute; }
  void              setMute(bool mute=true) {  _mute=mute; }

protected:

  JMapper *         mapper() { return _mapper; }

  JMidiOut *          _monitor;
  JMidiOut *          _midiOut;
  JMapper *           _mapper;

  int                 _prog;
  int                 _bank;
  int                 _devId;
  int                 _chnId;

  JEffectList *       _effectList;
  bool                _mute;
};



#endif






