#ifndef _JPhraseController_H
#define _JPhraseController_H

/*!
  \class JEventPhraseController JEventPhraseController.h
  \brief Interface to build a phrase

*/

#include "rep/JMidiType.h" 
#include "rep/JBeat.h"


class JPhrase;
class JEvent;
class JBeat;
class JDuration;
class JEffectNode;
class JPhraseUpdate;
class JGesture;

class JPhraseController
{

public:
  JPhraseController(JPhrase *);
  ~JPhraseController() {;}

  //! Insert in phrase at corect using g.beat to order
  void insertGesture(JGesture *g);

  //! Controller points to first event;
  JGesture * seekFirst();

  
  //! Shift focus thru to end right.
  void shiftRightOfBy(const JDuration &d);


  //! nasty stuff
  void deleteFocus();

  //! Oooops
  void rebuildEffects();

  //! Move the focus right
  JGesture * moveFocusRight();

  //!  Move the focus left
  JGesture * moveFocusLeft();

  //! Current focus
  JGesture *focus() {return _focus;}


  const JGesture *focus() const {return _focus;}

  //!  set the focus to event at beat
  JGesture * attachFocusAt(JBeat beat);
  
  //! focus becomes 0
  void detachFocus();
  
  const JPhrase * phrase() const { return _phrase;}
  void            updateFocus();

private:



//   JEffectNode * seekNodeAfter(const JBeat &,JEffectNode *head);
//   void          appendAfter(JEvent *before,JEvent *newEvent);
//   void          insertIntoHorz(JEffectNode *node);


private:
  JPhrase *               _phrase;
  JGesture *               _focus;
};




#endif
