#ifndef _JPart_H
#define _JPart_H

#include "JSequence.h"  // IS
#include "JPhraseList.h"
#include "base/JName.h"
#include "JInUse.h"

class JPhrase;
class JPhraseList;
class JComposition;
class JPlayer;

class JPart : public JSequence ,public JName ,
	       public JInUse 
{
public:
  ///
  JPart(JComposition *comp,const char *name=0);
  virtual ~JPart();

  /// CONCRETE JSequence
  JSequencer *   createSequencer(JPlayer *)const;
  JBeat          from() const;
  JBeat          till() const;
  bool           active() const { return _active; }

  /// Handle on the editable bits.

  void addPhrase(JPhrase *phrase) ;

  JPhraseList *  phraseList();
  const JPhraseList *  phraseList() const;

private:
  JPhraseList            _phraseList;
  bool                   _active;
  JComposition  *        _comp;
};


ostream & operator <<(ostream &,const JPart &);


#endif







