#ifndef _JComposition_H
#define _JComposition_H

// JCompostion
// Top level sequence
// A Composition is simply a list of tracks 

#include "JTrackList.h"
#include "base/JName.h"

class JMeter;
class JConductor;
class JVoice;

class JComposition : public JSequence,
		     public JName
{

public:
  JComposition(const char *name);
  virtual ~JComposition();

  bool       write(ostream &) const;
  bool       read(JReader &);

  /// JSequence
  JSequencer   *     createSequencer(JPlayer *player)const;

  JPartList *        partList() { return &_partList; }
  const JPartList *  partList() const { return &_partList; }

  /// ME
  JTrack  *          newTrack(JVoice *voice,
			      const char *name=0);

  JTrackList  *        trackList() { return &_trackList; }
  const JTrackList  *  trackList() const { return &_trackList; }


  JMeter *             meter()   { return _meter; }
  const JMeter *       meter() const  { return _meter; }

  //  JTrack *             findTrackOf(JPhrase *phrase);


protected:



  JTrackList       _trackList;
  JPartList        _partList;

  JMeter  *        _meter;

    
};


#endif








