#include <iostream.h>
#include "phrase.h"
#include "iterator.h"
#include "note.h"
#include "beatblk.h"
#include "rhytmblk.h"

phrase_c::phrase_c(){
  smallest_fraction_int = 1;
}

phrase_c::phrase_c(double tempo_d, int beats_inbar_i, int beat_type_i,
		   int beat_i, int numerator_i, int denominator_i, int note_i,
		   double length_d, int velocity_i)
{
  char d;
  int fraction_array_p[3] = {beat_i, numerator_i, denominator_i};

  minimise_fraction(fraction_array_p);

  cout << fraction_array_p[0]  << endl;
  cout << fraction_array_p[1]  << endl;
  cout << fraction_array_p[2]  << endl;

  note_c *note_p;

  tempo_dbl = tempo_d;
  beats_inbar_int = beats_inbar_i;
  beat_type_int = beat_type_i;
  iterator_ptr = new block_iterator_c();
  if(iterator_ptr == NULL){
	 cout << "FATAL ERROR: Cannot allocate memory..." << endl;
	 cin.get(d);
  }
  note_p = new note_c(note_i, length_d, velocity_i);
  if(note_p == NULL){
	 cout << "FATAL ERROR: Cannot allocate memory..." << endl;
	 cin.get(d);
  }
  create_start_rhythm_block(fraction_array_p, note_p);
	 // Sets iterator starting values and phrase start pointer //

  smallest_fraction_int = 1;
  update_phrase_info();
}

// ONLY USED BY MAIN PROGRAM FUNCTION FOR DELETING PHRASE !!!!!!!!//
void phrase_c::remove_all(){
  int note_i;
//  char d;

  iterator_ptr->set_iterator(start_ptr, start_ptr);
  iterator_ptr->iterate(1, 0);

  while(iterator_ptr->note_block() != start_ptr){
	 note_i = iterator_ptr->note_pntr()->note();
	 remove_note(iterator_ptr->rhythm_block()->array(), note_i, 0);
	 iterator_ptr->iterate(1, 0);
  }

  delete iterator_ptr->note_pntr();
  delete iterator_ptr->note_block();
  delete start_ptr;
  delete iterator_ptr;
}

void phrase_c::update_phrase_info(){
  int block_count_i = 0;
  int pitch_count_i = 0;
  int velocity_count_i = 0;
  int no_notes_i = 0;

  high_note_int = 0;
  low_note_int = 127;

  iterator_ptr->set_iterator(start_ptr,start_ptr);

  do{
	 if(iterator_ptr->note_block() == iterator_ptr->rhythm_block()){
		if(iterator_ptr->rhythm_block()->denominator()
			> smallest_fraction_int)
		  smallest_fraction_int = iterator_ptr->rhythm_block()->denominator();

		if(iterator_ptr->note_pntr()->note() > high_note_int)
		  high_note_int = iterator_ptr->note_pntr()->note();
		if(iterator_ptr->rhythm_block()->rRlink()->Llink()->note_pntr()->
		  note() < low_note_int)
		  low_note_int = iterator_ptr->rhythm_block()->rRlink()->Llink()->
							  note_pntr()->note();

		block_count_i++;
	 }

	 pitch_count_i = pitch_count_i + iterator_ptr->note_pntr()->note();
	 velocity_count_i = velocity_count_i + iterator_ptr->note_pntr()->velocity();
	 no_notes_i++;
	 iterator_ptr->iterate(0, 0);

  }while(iterator_ptr->note_block() != start_ptr);

  no_beat_blocks_int = block_count_i;
  average_pitch_int = pitch_count_i/no_notes_i;
  average_velocity_int = velocity_count_i/no_notes_i;
}

double phrase_c::change_tempo(double phrase_tempo_d){
  double tmp_d;
  tmp_d = tempo_dbl;
  tempo_dbl = phrase_tempo_d;

  return tmp_d;
}

int phrase_c::add_note(int beat_i, int numerator_i, int denominator_i,
								int note_i, double length_d, int velocity_i){
  int fail_i = 0;
  char d;
  int found_i;
  int fraction_array_p[3] = {beat_i, numerator_i, denominator_i};
  note_c *note_p;

  minimise_fraction(fraction_array_p);

  found_i = find_note(fraction_array_p, note_i);

  if(found_i == 0){
	 note_p = new note_c(note_i, length_d, velocity_i);
	 if(note_p == NULL){
		cout << "FATAL ERROR: Cannot allocate memory..." << endl;
		cin.get(d);
		fail_i = 1;
	 }
	 create_rhythm_block(fraction_array_p, note_p);
  }else if(found_i == 1){
		note_p = new note_c(note_i, length_d, velocity_i);
		if(note_p == NULL){
		  cout << "FATAL ERROR: Cannot allocate memory..." << endl;
		  cin.get(d);
		  fail_i = 1;
		}
		create_note_block(note_p);
		if(note_i > iterator_ptr->note_pntr()->note())
		  swap_notes();
  }else{
	 cout << "Error 1: Note already exists! Will not create...\n";
	 fail_i = 1;
  }

  return fail_i;
}

int phrase_c::add_note(int *fraction_array_p, note_c *note_p){
  int fail_i = 0;
  int found_i;
  int note_i;
  char d;

  minimise_fraction(fraction_array_p);

  note_i = note_p->note();
  found_i = find_note(fraction_array_p, note_i);

  if(found_i == 0)
	 create_rhythm_block(fraction_array_p, note_p);
  else if(found_i == 1){
	 create_note_block(note_p);
	 if(note_i > iterator_ptr->note_pntr()->note())
		swap_notes();
  }else{
	 cout << "Error 1: Note already exists! Will not create...\n";
	 fail_i = 1;
  }

  return fail_i;
}

note_c *phrase_c::remove_note(int *fraction_array_p, int note_i,
										int leave_note_i){
  int found_i;
  note_c *note_p;

  minimise_fraction(fraction_array_p);

  found_i = find_note(fraction_array_p, note_i);
  note_p = iterator_ptr->note_pntr();

  if(found_i == 2){
	 if(iterator_ptr->note_in() == 0){
		if(iterator_ptr->no_notes() == 0){
		  if(iterator_ptr->note_block() == start_ptr){
			 if(start_ptr == start_ptr->rRlink()){
				cout << "Error 11: Can't delete last rhythm block...\n";
				note_p = 0;
			 }else{
				start_ptr = (iterator_ptr->rhythm_block()->rRlink());
				delete_rhythm_block(leave_note_i);
			 }
		  }else
			 delete_rhythm_block(leave_note_i);
		}else{
		  swap_notes();
		  iterator_ptr->iterate(0, 0);
		  delete_note_block(leave_note_i);
		}
	 }else
		delete_note_block(leave_note_i);
  }else{
	 cout << "Error 5: Note not found for removing...\n";
    note_p = 0;
  }
  return note_p;
}

note_c *phrase_c::remove_note(int leave_note_i){
//  int found_i;
  note_c *note_p;

  note_p = iterator_ptr->note_pntr();

  if(iterator_ptr->note_in() == 0){
	 if(iterator_ptr->no_notes() == 0){
		if(iterator_ptr->note_block() == start_ptr){
		  if(start_ptr == start_ptr->rRlink())
			 cout << "Error 11: Can't delete last rhythm block...\n";
		  else{
			 start_ptr = iterator_ptr->rhythm_block()->rRlink();
			 delete_rhythm_block(leave_note_i);
		  }
		}else
		  delete_rhythm_block(leave_note_i);
	 }else{
		swap_notes();
		iterator_ptr->iterate(0, 0);
		delete_note_block(leave_note_i);
	 }
  }else
	 delete_note_block(leave_note_i);

  return note_p;
}

void phrase_c::swap_notes(int beat_i, int numerator_i, int denominator_i,
								  int note_i, int beat2_i, int numerator2_i,
								  int denominator2_i, int note2_i){
  //  rhythm_block_c *rhythm_block_p;
//  note_block_c *note_block_p;
  note_c *note_p;
//  note_c *note2_p;
  int found_i = 0;
  int fraction_array_p[3] = {beat_i, numerator_i, denominator_i};
  int fraction_array2_p[3] = {beat2_i, numerator2_i, denominator2_i};

  minimise_fraction(fraction_array_p);
  minimise_fraction(fraction_array2_p);

  if(compare_fractions(fraction_array_p, fraction_array2_p) != 1){

	 found_i = find_note(fraction_array_p, note_i);

	 if(found_i == 2){
		note_p = iterator_ptr->note_pntr();
		found_i = find_note(fraction_array2_p, note2_i);
		if(found_i == 2){

		  // TO BE IMPLEMENTED //
		}
		else
		  cout << "Error 3: Note 2 does not exist! Can't swap...\n";
	 }else
		cout << "Error 3: Note 1 does not exist! Can't swap...\n";
  }
}

void phrase_c::shift_note(int *fraction_array_p, int note_i,
								  int *fraction2_array_p){
  int found_i;
  note_c *note_p;

  found_i = find_note(fraction_array_p, note_i);

  if(found_i == 2){
	 note_p = remove_note(fraction_array_p, note_i, 1);
	 add_note(fraction2_array_p, note_p);
  }else
	 cout << "Error 5: Can't find the note for shifting...\n";
}

void phrase_c::shift_note(int *fraction_array_p, int note_i, int shift_num_i,
								  int shift_denom_i){
  int found_i;
  //  int new_beat_i;
  int new_numerator_i;
  int new_denominator_i;
  //  int lowest_denom_i;
  //  int reduction_value_i;
  int new_fraction_array_p[3] = {fraction_array_p[0], 0, 0};
  double value_d;
  note_c *note_p;

  if(shift_num_i != 0){
	 value_d = (1.0 * fraction_array_p[2])/shift_denom_i;

	 if(value_d >= 1){
		new_numerator_i = (int) 
	((value_d * shift_num_i) + fraction_array_p[1]);
		new_denominator_i = 
		  (int)	fraction_array_p[2];
	 }
	 else{
		new_numerator_i = (int)(fraction_array_p[1]/value_d);
		new_numerator_i = (int)(new_numerator_i + shift_num_i);
		new_denominator_i = (int)(fraction_array_p[2]/value_d);
	 }

	 new_fraction_array_p[1] = new_numerator_i;
	 new_fraction_array_p[2] = new_denominator_i;

	 minimise_fraction(fraction_array_p);

	 found_i = find_note(fraction_array_p, note_i);

	 if(found_i == 2){
		note_p = remove_note(fraction_array_p, note_i, 1);
		add_note(new_fraction_array_p, note_p);
	 }else
		cout << "Error 5: Can't find the note for shifting...\n";
  }
}

int phrase_c::shift_note(int shift_num_i, int shift_denom_i){
  int beat_i;
  int numerator_i;
  int denominator_i;
  //  int new_beat_i;
  int new_numerator_i;
  int new_denominator_i;
  //  int lowest_denom_i;
  //  int reduction_value_i;
  int not_shifted_i = 0;
  int new_fraction_array_p[3];
  double value_d;
  note_c *note_p;

  if(shift_num_i != 0){
	 beat_i = iterator_ptr->rhythm_block()->beat();
	 numerator_i = iterator_ptr->rhythm_block()->numerator();
	 denominator_i = iterator_ptr->rhythm_block()->denominator();

	 value_d = (1.0 * denominator_i)/shift_denom_i;

	 if((value_d >= 1) || (value_d <= -1)){
	  new_numerator_i = (int)((value_d * shift_num_i) + numerator_i);
	  new_denominator_i = denominator_i;
	 }else{
		new_numerator_i = (int)(numerator_i/value_d);
		new_numerator_i = new_numerator_i + shift_num_i;
		new_denominator_i = (int)(denominator_i/value_d);
	 }

	 new_fraction_array_p[0] = beat_i;
	 new_fraction_array_p[1] = new_numerator_i;
	 new_fraction_array_p[2] = new_denominator_i;

	 minimise_fraction(new_fraction_array_p);

	 if(new_fraction_array_p[0] >= 1){
		note_p = remove_note(1);

		add_note(new_fraction_array_p, note_p);
	 }else
		not_shifted_i = 1;
  }else
		not_shifted_i = 1;

  return not_shifted_i;
}

void phrase_c::display_current_note(){
  cout << "\nnote " << iterator_ptr->note_pntr()->note() << endl;
  cout << "velocity " << iterator_ptr->note_pntr()->velocity()
		 << endl;
  cout << "length " << iterator_ptr->note_pntr()->length()
		 << endl;
  cout << "block "
		 << iterator_ptr->note_in()
		 << endl;
  cout << "beat " << iterator_ptr->rhythm_block()->beat()
		 << endl;
  cout << "fraction "
		 << iterator_ptr->rhythm_block()->numerator() << "/"
		 << iterator_ptr->rhythm_block()->denominator()
		 << endl;
  cout << "contained notes "
		 << iterator_ptr->no_notes()
		 << endl;
}

void phrase_c::display_phrase(){
  char d;

  iterator_ptr->set_iterator(start_ptr, start_ptr);

  cout << "\nHit return key for succesive notes..." << endl;

  do{
	 display_current_note();
	 iterator_ptr->iterate(0, 0);

	 cin.get(d);

	 // Finds next note //
  }while(iterator_ptr->note_block() != start_ptr);
}

int phrase_c::compare_fractions(int *fraction_array_p){
  int current_beat_i = iterator_ptr->rhythm_block()->beat();
  int current_num_i = iterator_ptr->rhythm_block()->numerator();
  int current_denom_i = iterator_ptr->rhythm_block()->denominator();
  int compare_i = 0;

  if((current_denom_i *
	((fraction_array_p[0] * fraction_array_p[2]) + fraction_array_p[1])) ==
	(fraction_array_p[2] * ((current_beat_i * current_denom_i) + current_num_i)))
	 compare_i = 1;
  else if((current_denom_i *
	((fraction_array_p[0] * fraction_array_p[2]) + fraction_array_p[1])) >
	(fraction_array_p[2] * ((current_beat_i * current_denom_i) + current_num_i)))
	 compare_i = 2;

  return compare_i;
}

int phrase_c::compare_fractions(int *fraction_array_p, int *fraction_array2_p){
  int compare_i = 0;

  if((fraction_array2_p[2] *
	((fraction_array_p[0] * fraction_array_p[2]) + fraction_array_p[1])) ==
	(fraction_array_p[2] * ((fraction_array2_p[0] * fraction_array2_p[2])
									+ fraction_array2_p[1])))
	 compare_i = 1;
  else if((fraction_array2_p[2] *
	((fraction_array_p[0] * fraction_array_p[2]) + fraction_array_p[1])) >
	(fraction_array_p[2] * ((fraction_array2_p[0] * fraction_array2_p[2])
									+ fraction_array2_p[1])))
	 compare_i = 2;

  return compare_i;
}

// Will handle negative numerators (not denominators) //
// Assign_i overites new data on the first input array //
void phrase_c::add_fractions(int *fraction_array_p, int *fraction_array2_p,
									  int *fraction_array3_p, int subtract_i){
  // int tmp_num_i;
 //  int tmp_denom_i;
  int numerator2_i;
  int new_fraction_array_p[3];
  //  char c;

  if(subtract_i == 0){
	 new_fraction_array_p[0] = fraction_array_p[0] + fraction_array2_p[0];
	 numerator2_i = fraction_array2_p[1];
  }else{
	 new_fraction_array_p[0] = fraction_array_p[0] - fraction_array2_p[0];
	 numerator2_i = - fraction_array2_p[1];
  }

  if(fraction_array_p[2] == fraction_array2_p[2]){
	 new_fraction_array_p[1] = fraction_array_p[1] + numerator2_i;
	 new_fraction_array_p[2] = fraction_array_p[2];
  }else{
	 new_fraction_array_p[2] = fraction_array_p[2] * fraction_array2_p[2];
	 new_fraction_array_p[1] = (fraction_array_p[1] * fraction_array2_p[2])
									 + (fraction_array_p[2] * numerator2_i);
  }
  minimise_fraction(new_fraction_array_p);

  fraction_array3_p[0] = new_fraction_array_p[0];
  fraction_array3_p[1] = new_fraction_array_p[1];
  fraction_array3_p[2] = new_fraction_array_p[2];
/*
  int tmp_num_i;
  int tmp_denom_i;
  int numerator2_i;
  int new_fraction_array_p[3];
  char c;

  if(subtract_i == 0){
	 new_fraction_array_p[0] = fraction_array_p[0] + fraction_array2_p[0];
	 numerator2_i = fraction_array2_p[1];
  }else{
	 new_fraction_array_p[0] = fraction_array_p[0] - fraction_array2_p[0];
	 numerator2_i = - fraction_array2_p[1];
  }

  if(fraction_array_p[2] == fraction_array2_p[2]){
	 new_fraction_array_p[1] = fraction_array_p[1] + numerator2_i;
	 new_fraction_array_p[2] = fraction_array_p[2];
  }else if(fraction_array_p[2] < fraction_array2_p[2]){
	 tmp_denom_i = 2 * fraction_array_p[2];
	 tmp_num_i = 2 * fraction_array_p[1];

	 while(tmp_denom_i < fraction_array2_p[2]){
		tmp_denom_i = 2 * tmp_denom_i;
		tmp_num_i = 2 * tmp_num_i;
	 }

	 new_fraction_array_p[1] = tmp_num_i + numerator2_i;
	 new_fraction_array_p[2] = tmp_denom_i;

  }else{
	 tmp_denom_i = 2 * fraction_array2_p[2];
	 tmp_num_i = 2 * numerator2_i;

	 while(tmp_denom_i < fraction_array_p[2]){
		tmp_denom_i = 2 * tmp_denom_i;
		tmp_num_i = 2 * tmp_num_i;
	 }

	 new_fraction_array_p[1] = tmp_num_i + fraction_array_p[1];
	 new_fraction_array_p[2] = tmp_denom_i;

  }
  minimise_fraction(new_fraction_array_p);

  fraction_array3_p[0] = new_fraction_array_p[0];
  fraction_array3_p[1] = new_fraction_array_p[1];
  fraction_array3_p[2] = new_fraction_array_p[2];
  */
}

void phrase_c::minimise_fraction(int *fraction_array_p){
  //  int lowest_denom_i;
  //  int reduction_value_i;
  int integer_i;
  double tmp_num_d;
  double tmp_denom_d;

  if((fraction_array_p[1] == 0) || (fraction_array_p[2] == 0)){
	 fraction_array_p[1] = 0;
	 fraction_array_p[2] = 1;
  }else if(fraction_array_p[1] == fraction_array_p[2]){
	 fraction_array_p[0]++;
	 fraction_array_p[1] = 0;
	 fraction_array_p[2] = 1;
  }else{
	 integer_i = fraction_array_p[1]/2;
	 tmp_num_d = (fraction_array_p[1]/2.0) - integer_i;
	 integer_i = fraction_array_p[2]/2;
	 tmp_denom_d = (fraction_array_p[2]/2.0) - integer_i;

	 while((tmp_num_d == 0)&&(tmp_denom_d == 0)&&(fraction_array_p[2] > 1)){

		if((tmp_num_d == 0)&&(tmp_denom_d == 0)){
		  fraction_array_p[1] = fraction_array_p[1]/2;
		  fraction_array_p[2] = fraction_array_p[2]/2;
		}

		integer_i = fraction_array_p[1]/2;
		tmp_num_d = (fraction_array_p[1]/2.0) - integer_i;
		integer_i = fraction_array_p[2]/2;
		tmp_denom_d = (fraction_array_p[2]/2.0) - integer_i;
	 }

	 integer_i = fraction_array_p[1]/3;
	 tmp_num_d = (fraction_array_p[1]/3.0) - integer_i;
	 integer_i = fraction_array_p[2]/3;
	 tmp_denom_d = (fraction_array_p[2]/3.0) - integer_i;

	 while((tmp_num_d == 0)&&(tmp_denom_d == 0)&&(fraction_array_p[2] > 1)){

		if((tmp_num_d == 0)&&(tmp_denom_d == 0)){
		  fraction_array_p[1] = fraction_array_p[1]/3;
		  fraction_array_p[2] = fraction_array_p[2]/3;
		}

		integer_i = fraction_array_p[1]/3;
		tmp_num_d = (fraction_array_p[1]/3.0) - integer_i;
		integer_i = fraction_array_p[2]/3;
		tmp_denom_d = (fraction_array_p[2]/3.0) - integer_i;
	 }

  }

  while((fraction_array_p[1] >= fraction_array_p[2])
		  || (fraction_array_p[1] < 0)){
	 if(fraction_array_p[1] > 0){
		fraction_array_p[0]++;
		fraction_array_p[1] = fraction_array_p[1] - fraction_array_p[2];
	 }else if(fraction_array_p[1] == fraction_array_p[2])
      fraction_array_p[0]++;
    else{
		fraction_array_p[0]--;
		fraction_array_p[1] = fraction_array_p[1] + fraction_array_p[2];
	 }
  }
}

void phrase_c::swap_notes(){
  note_block_c *right_note_block_p;
  note_c *right_note_p;
  note_c *left_note_p;

  right_note_block_p = iterator_ptr->note_block()->Rlink();
  right_note_p = right_note_block_p->note_pntr();
  left_note_p = iterator_ptr->note_block()->change_note(right_note_p);
  right_note_block_p->change_note(left_note_p);
}

int phrase_c::find_rhythm_block(int *fraction_array_p){
  rhythm_block_c *tmp_p;
  int exist_i = 2;
  int compare_value_i;

  iterator_ptr->set_iterator(start_ptr, start_ptr);

  tmp_p = start_ptr;

  do{
	 compare_value_i = compare_fractions(fraction_array_p);

	 if(compare_value_i == 1)
		exist_i = 1;
	 else if(compare_value_i == 0)
		exist_i = 0;
	 else
		iterator_ptr->iterate(0, 1);
  }while((exist_i == 2) &&
			(tmp_p != iterator_ptr->rhythm_block()));

  // Note: Iterator is set either to the block specified if it exists, //
  //       or to the first block right of its supposed location specified //
  // exist 0 not found, 1 = found, 2 = not found, greater than highest block //
  return exist_i;
}

int phrase_c::find_note_block(int note_i){
  int exist_i = 0;
  rhythm_block_c *tmp_p;
  note_block_c *tmp2_p;
  note_block_c *block_for_insert_p;

  tmp_p = iterator_ptr->rhythm_block();
  tmp2_p = iterator_ptr->rhythm_block();

  iterator_ptr->set_iterator(tmp_p, tmp_p);
  block_for_insert_p = tmp2_p;

  if(tmp_p->rRlink() == tmp_p){
	 do{
		if(note_i == iterator_ptr->note_pntr()->note())
		  exist_i = 1;
		else{
		  if(note_i < iterator_ptr->note_pntr()->note())
			 block_for_insert_p = iterator_ptr->note_block();
		  iterator_ptr->iterate(0, 0);
		}
	 }while((exist_i == 0)&&
			  (tmp2_p != iterator_ptr->note_block()));
  }else{
	 do{
		if(note_i == iterator_ptr->note_pntr()->note())
		  exist_i = 1;
		else{
		  if(note_i < iterator_ptr->note_pntr()->note())
			 block_for_insert_p = iterator_ptr->note_block();
		  iterator_ptr->iterate(0, 0);
		}
	 }while((exist_i == 0)&&(tmp_p == iterator_ptr->rhythm_block()));
  }

  if(exist_i == 0)
	 iterator_ptr->set_iterator(tmp_p, block_for_insert_p);
		// Resets to the initial rhythm block pointer //

  return exist_i;
}

int phrase_c::find_note(int *fraction_array_p, int note_i){
  int exist_i;
  int found_i = 0;

  exist_i = find_rhythm_block(fraction_array_p);

  if(exist_i == 1){
	 exist_i = find_note_block(note_i);
	 found_i = 1;
	 if(exist_i == 1)
		found_i = 2;
  }
  return found_i;
}

note_block_c *phrase_c::change_left_nb_pntr(note_block_c *note_block_p){
  note_block_c *tmp_p;
  tmp_p = iterator_ptr->note_block()->change_Lblock_pntr(note_block_p);

  return tmp_p;
}

note_block_c *phrase_c::change_right_nb_pntr(note_block_c *note_block_p){
  note_block_c *tmp_p;
  tmp_p = iterator_ptr->note_block()->change_Rblock_pntr(note_block_p);

  return tmp_p;
}

rhythm_block_c *phrase_c::change_left_rb_pntr(rhythm_block_c *rhythm_block_p){
  rhythm_block_c *tmp_p;
  tmp_p = iterator_ptr->rhythm_block()->change_rLblock_pntr(rhythm_block_p);

  return tmp_p;
}

rhythm_block_c *phrase_c::change_right_rb_pntr(
															rhythm_block_c *rhythm_block_p){
  rhythm_block_c *tmp_p;
  tmp_p = iterator_ptr->rhythm_block()->change_rRblock_pntr(rhythm_block_p);

  return tmp_p;
}

void phrase_c::create_note_block(note_c *note_p){
  note_block_c *linkL_p;
  note_block_c *linkR_p;
  note_block_c *note_block_p;
  char d;

  linkL_p = iterator_ptr->note_block();
  linkR_p = iterator_ptr->note_block()->Rlink();
  note_block_p = new note_block_c(note_p, linkL_p, linkR_p);
  if(note_block_p == NULL){
	 cout << "FATAL ERROR: Cannot allocate memory..." << endl;
	 cin.get(d);
  }
  linkL_p->change_Rblock_pntr(note_block_p);
  linkR_p->change_Lblock_pntr(note_block_p);
  iterator_ptr->rhythm_block()->inc_no_notes();
  iterator_ptr->update();

  /*
  (*iterator_ptr).iterate(0, 0);
	 // iterates to the inserted note block //
  */
}

void phrase_c::create_rhythm_block(int *fraction_array_p, note_c *note_p){
  note_block_c *linkL_p;
  note_block_c *linkR_p;
  rhythm_block_c *linkrL_p;
  rhythm_block_c *linkrR_p;
  rhythm_block_c *rhythm_block_p;
  int start_i;
  char d;

  start_i = find_rhythm_block_entry(fraction_array_p);
  linkrR_p = iterator_ptr->rhythm_block();
  linkR_p = linkrR_p;
  linkrL_p = iterator_ptr->rhythm_block()->rLlink();
  linkL_p = iterator_ptr->rhythm_block()->Llink();

  rhythm_block_p = new rhythm_block_c(note_p, linkL_p, linkR_p, linkrL_p,
												  linkrR_p, fraction_array_p);
  if(rhythm_block_p == NULL){
	 cout << "FATAL ERROR: Cannot allocate memory..." << endl;
	 cin.get(d);
  }
  linkL_p = linkrR_p->change_Lblock_pntr(rhythm_block_p);
  linkrL_p = linkrR_p->change_rLblock_pntr(rhythm_block_p);
  linkL_p->change_Rblock_pntr(rhythm_block_p);
  linkrL_p->change_rRblock_pntr(rhythm_block_p);

  if(start_i == 1)
	 start_ptr = rhythm_block_p;

  iterator_ptr->iterate(1, 1);
	 // iterates to the inserted rhythm block //
}

void phrase_c::create_start_rhythm_block(int *fraction_array_p, note_c *note_p){
  char d;
  rhythm_block_c *rhythm_block_p;

  rhythm_block_p = new rhythm_block_c(note_p, fraction_array_p);
  if(rhythm_block_p == NULL){
	 cout << "FATAL ERROR: Cannot allocate memory..." << endl;
	 cin.get(d);
  }
  rhythm_block_p->change_Lblock_pntr(rhythm_block_p);
  rhythm_block_p->change_rLblock_pntr(rhythm_block_p);
  rhythm_block_p->change_Rblock_pntr(rhythm_block_p);
  rhythm_block_p->change_rRblock_pntr(rhythm_block_p);

  start_ptr = rhythm_block_p;

  iterator_ptr->set_iterator(start_ptr, start_ptr);
	 // sets all the iterator variables for the starting rhythm_block //

}

void phrase_c::delete_note_block(int leave_note_i){
  note_block_c *linkL_p;
  note_block_c *linkR_p;
  note_block_c *del_noteb_p;

  del_noteb_p = iterator_ptr->note_block();

  linkL_p = del_noteb_p->Llink();
  linkR_p = del_noteb_p->Rlink();

  linkL_p->change_Rblock_pntr(linkR_p);
  linkR_p->change_Lblock_pntr(linkL_p);

  iterator_ptr->rhythm_block()->dec_no_notes();
  iterator_ptr->iterate(1, 1);

  if(leave_note_i == 0)
	 delete del_noteb_p->note_pntr();

  delete del_noteb_p;
}

void phrase_c::delete_rhythm_block(int leave_note_i){
  note_block_c *linkL_p;
  note_block_c *linkR_p;
  rhythm_block_c *linkrL_p;
  rhythm_block_c *linkrR_p;
  rhythm_block_c *del_rhythmb_p;

  del_rhythmb_p = iterator_ptr->rhythm_block();

  linkL_p = del_rhythmb_p->Llink();
  linkR_p = del_rhythmb_p->Rlink();
  linkrL_p = del_rhythmb_p->rLlink();
  linkrR_p = del_rhythmb_p->rRlink();

  (*iterator_ptr).iterate(1, 1);

  linkL_p->change_Rblock_pntr(linkR_p);
  linkR_p->change_Lblock_pntr(linkL_p);
  linkrL_p->change_rRblock_pntr(linkrR_p);
  linkrR_p->change_rLblock_pntr(linkrL_p);

  if(leave_note_i == 0)
	 delete del_rhythmb_p->note_pntr();

  delete del_rhythmb_p;
}

int phrase_c::find_rhythm_block_entry(int *fraction_array_p){
  int assign_start_i = 0;
  int compare_value_i;

  iterator_ptr->set_iterator(start_ptr, start_ptr);

  compare_value_i = compare_fractions(fraction_array_p);

  if(compare_value_i == 0)
	 assign_start_i = 1;
  else do{
	 (*iterator_ptr).iterate(0, 1);
	 // Sets the current rhythm block ptr to right of rhythm block insert point /

	 compare_value_i = compare_fractions(fraction_array_p);
  }while((compare_value_i == 2)
			&&(start_ptr != iterator_ptr->rhythm_block()));

  return assign_start_i;
}


