// #define DEBUG

/******************************************/
/*  Simple RealTime MIDI Input Object,    */
/*  by Paul Leonard , 1997                */        
/*					  */
/*  This object takes MIDI from the input */
/*  , parses it, turns it into TSIDI      */
/******************************************/

#include "MIDIInpt.h"
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/soundcard.h>       


#define SEQUENCER_PATH "/dev/sequencer"

MIDIInpt :: MIDIInpt()
  :_seqfd(0)
{

#ifdef NONBLOCKING_MIDI
  if((_seqfd = open(SEQUENCER_PATH, O_RDONLY+O_NONBLOCK, 0)) == -1)  {
#else
  if((_seqfd = open(SEQUENCER_PATH, O_RDONLY, 0)) == -1)  {
#endif
    printf( "Cannot open " SEQUENCER_PATH ". \n");
  }

}

MIDIInpt :: ~MIDIInpt()
{
  if (_seqfd != 0) ::close(_seqfd);
}



int
MIDIInpt::crack(unsigned char *buf,int *bufp)
{

#ifdef DEBUG
  printf(" CRACK \n");
#endif

  int cntrl;

  channel = buf[0] & 0x0f;
  
  switch (buf[0] & 0xf0) {
  case 0x90:	/* Note on */
    if (*bufp < 3) return 0;
    if (buf[2]) {
      byteTwo = (float) buf[1];
      byteThree = (float) buf[2];
      messageType = 9;
    } else {
      messageType = 8;
      byteTwo = (float) buf[1];
      byteThree = 0.0;
    }
    *bufp=1;
    return 1;
    
  case 0xb0:	/* Control change */
    if (*bufp < 3) return 0;
    messageType=11;
    byteTwo = (float) buf[1];
    byteThree = (float) buf[2];
    *bufp=1;
    return 1;
    
  case 0x80:	/* Note off */
    if (*bufp < 3) return 0;
    messageType = 8;
    byteTwo = (float) buf[1];
    byteThree = 0.0;
    *bufp=1;
    return 1;
    
  case 0xe0:	/* Pitch bender */
    if (*bufp < 3) return 0;

    // TODO ???
    // pitchshift= (((_buf[2] & 0x7f) << 7) | (_buf[1] & 0x7f)) - 8192; 
    byteTwo = (float) buf[1];
    byteTwo += (float) buf[2] * NORM_7;
    messageType = 14;
    *bufp=1;
    return 1;
    
  case 0xc0:	/* Pgm change */
    if (*bufp < 2) return 0;
    messageType = 12;
    byteTwo = (float) buf[1];
    byteThree = (float) buf[2];
    *bufp=0;
    return 1;
    
  case 0xd0:	/* Channel pressure */
    if (*bufp < 2) return 0;
    byteTwo = (float) buf[1];
    messageType = 13;
    *bufp=1;
    return 1;
    
  default:
    *bufp=0;
  }
  return 0;
}



int
MIDIInpt::nextMessage()
{
  static  unsigned char buf[100];
  static  int bufp=0;
  unsigned char ev[4];
  int i,n;
  

  if((n=read(_seqfd, ev, sizeof(ev))) == -1 )   {
    return 0;
  }

  if ( n == 0 ) return 0;

#ifdef DEBUG
  printf("%d %d %d %d %d %d \n",n,ev[0],ev[1],ev[2],ev[3],bufp);
#endif

  int ret=0;

  for(i=0; i<=(n/4); i++) 
    {
      unsigned char *p = &ev[i*4];
      if( (p[0]==SEQ_MIDIPUTC) && (p[2]==0)) {
	if(p[1] & 0x80)   { /* Status */
	  if(bufp) ret=crack(buf,&bufp);
	  buf[0] = p[1]; bufp=1;
	}  else if(bufp) {
	  buf[bufp++] = p[1];
	  if ((buf[0] & 0xf0) == 0x90 || (buf[0] & 0xf0) == 0x80 
	      || (buf[0] & 0xf0) == 0xb0 || (buf[0] & 0xf0) == 0xe0)  {
	    if(bufp==3)  ret=crack(buf,&bufp);
	  } else  if ((buf[0] & 0xf0) == 0xc0 || (buf[0] & 0xf0) == 0xd0)  {
	    if(bufp==2)  ret=crack(buf,&bufp);
	  }
	}
      }
    }
  return ret;
}







#if 0


int 
MIDIInpt ::  nextMessage()
{
    int status;
    int byte1;
    int byte2;

    messageType = -1;

    mdReceive(inport, &lastEvent, 1);

//     if (onePending == 1)  {

    status = mdGetStatus(lastEvent.msg);
    byte1 = mdGetByte1(lastEvent.msg);
    byte2 = mdGetByte2(lastEvent.msg);
    channel = mdGetChannel(lastEvent.msg);

    if (status==MD_NOTEON)	{
      byteTwo = (float) byte1;
      byteThree = (float) byte2;
      if (byte2==0) 
	messageType = 8;
      else
	messageType = 9;
    }
    else if (status==MD_NOTEOFF)	{
      byteTwo = (float) byte1;
      byteThree = (float) byte2;
      messageType = 8;
    }
    else if (status==MD_CONTROLCHANGE)	{
      byteTwo = (float) byte1;
      byteThree = (float) byte2;
      messageType = 11;
    }
    else if (status==MD_PROGRAMCHANGE)	{
      byteTwo = (float) byte1;
      messageType = 12;
    }
    else if (status==MD_CHANNELPRESSURE)	{
      byteTwo = (float) byte1;
      messageType = 13;
    }
    else if (status==MD_PITCHBENDCHANGE)	{
      byteTwo = (float) byte1;
      byteTwo += (float) byte2 * NORM_7;
      messageType = 14;
    }
    else {
      messageType = -1;
    }	    
    return messageType;
}

#endif


void MIDIInpt ::  printMessage()
{
  // char buffer[128];

    // Whats this ment to do ???

    //    mdPrintEvent(buffer,&lastEvent,1);
    //    printf(buffer);
}

int MIDIInpt ::  getType()
{
    return messageType;
}

int MIDIInpt ::  getChannel()
{
    return channel;
}

MY_FLOAT MIDIInpt :: getByteTwo()
{
    return byteTwo;
}

MY_FLOAT MIDIInpt :: getByteThree()
{
    return byteThree;
}

/************   Test Main Program   *****************/
/*
void main(int argc,char *argv[])
{
    MIDIInpt testMIDI;
    
    while(1)	{
        if (testMIDI.nextMessage() > 0)
	    testMIDI.printMessage();
    }
}
*/







