/*******************************************/
/*  Wave file Output Class,                */
/*  by Perry R. Cook, 1995-96              */ 
/*  This Object opens a DOS/Windows .wav   */
/*  16bit data (signed integers) file, and */
/*  poke buffers of samples into it.       */
/*******************************************/


#include "Object.h"
#include "WvOut.h"

#if !defined(__WavWvOut_h)
#define __WavWvOut_h

#define WAV_BUFFER_SIZE 128

class WavWvOut : public WvOut
{
  protected:
    FILE *fd;
    short data[WAV_BUFFER_SIZE];
    long counter;
    long totalCount;
  public:
    WavWvOut(char *fileName);
    ~WavWvOut();
    long getCounter();
    MY_FLOAT getTime();
    void tick(MY_FLOAT sample);
};

#endif
