#include "WavWvOut.h"

/********  Wav Soundfile Header Struct   *******/
struct wavehdr {char riff[4];
		long flength;
		char wave[4];
		char fmt[4];
		long format;
		short aone;
		short numchans;
		long srate;
		long bps;
		short numchans2;
		short bps2;
		char data[4];
		long dlength;
		};


WavWvOut :: WavWvOut(char *fileName)
{
    struct wavehdr hdr = {"RIF",36,"WAV","fmt",
			  16,1,1,22050,44100,1,16,"dat",0};

    hdr.riff[3] = 'F';
    hdr.wave[3] = 'E';
    hdr.fmt[3]  = ' ';
    hdr.data[3] = 'a';
    
    fd = fopen(fileName,"wb");
    if (!fd)   {
	printf("Couldn't create soundfile %s  !!!!!!!!\n",fileName);
	exit(0);
    }
    fwrite(&hdr,11,4,fd);
    counter = 0;
    totalCount = 0;
}

WavWvOut :: ~WavWvOut()
{
    MY_FLOAT temp;
    fwrite(data,2,counter,fd);

    temp = (double) totalCount * ONE_OVER_SRATE;
    totalCount *= 2;
    fseek(fd,40,SEEK_SET);
    fwrite(&totalCount,4,1,fd);
    totalCount += 8;
    fseek(fd,4,SEEK_SET);
    fwrite(&totalCount,4,1,fd);
    fclose(fd);
    printf("%f Seconds Computed\n",temp);
}

long WavWvOut :: getCounter()
{
    return totalCount;
}

MY_FLOAT WavWvOut :: getTime()
{
    return (MY_FLOAT) totalCount * SRATE;
}

void WavWvOut :: tick(MY_FLOAT sample)
{

    data[counter++] = (short) (sample * 32000.0);
    totalCount += 1;
    if (counter == WAV_BUFFER_SIZE) {
	fwrite(data,2,WAV_BUFFER_SIZE,fd);
	counter = 0;
    }
}
