#include <X11/Xlib.h>
#include "Beeper.h"
#include <qobject.h>

Beeper::Beeper()
{
  BellFlags=(KBBellPercent | KBBellPitch | KBBellDuration);
  dsp=qt_xdisplay();
  
  XKeyboardState state; kbctrl=new XKeyboardControl;
  XGetKeyboardControl((Display*)dsp, &state);
  ((XKeyboardControl*)kbctrl)->bell_duration = state.bell_duration;
  ((XKeyboardControl*)kbctrl)->bell_percent  = state.bell_percent;
  ((XKeyboardControl*)kbctrl)->bell_pitch    = state.bell_pitch;
  //    cout << "Old Settings:" <<state.bell_duration<< "msecs , "
  //    	 << state.bell_percent << "% , " << state.bell_pitch<<"Hz" ;
}

Beeper::~Beeper() 
{ 
  NoPlay(); 
  
  XChangeKeyboardControl((Display*)dsp, BellFlags, (XKeyboardControl*)kbctrl);
  XFlush((Display*)dsp);
  
  dsp=0; delete (XKeyboardControl*)kbctrl;
  // reset Bell-settings
}

void Beeper::Play(int freq,int volume,int time)
{
  //cout<< "Beeping: " << freq << "Hz , " << volume << "dB , " << time << "Secs\n";
  
  bFreq=freq; bVolume=volume; bTime=time;
  XKeyboardControl values;
  if (volume != 0  &&  freq != 0) {
    values.bell_duration = time;
    values.bell_percent  = 100;
    values.bell_pitch    = freq;
    
    XChangeKeyboardControl((Display*)dsp, BellFlags, &values);
    XBell((Display*)dsp, volume - 100);
        XFlush((Display*)dsp);
  }
}

void Beeper::RePlay()
{
  XBell((Display*)dsp, bVolume - 100);
    XFlush((Display*)dsp);
}

void Beeper::NoPlay()
{
//cout<< "Sound stopped";
	XKeyboardControl values;
    values.bell_duration = 1;
    values.bell_percent  = 1;
    values.bell_pitch    = 1;

    XChangeKeyboardControl((Display*)dsp, BellFlags, &values);
    XBell((Display*)dsp, 1 - 100);
    XFlush((Display*)dsp);
}










