#include "JNoteSequencer.h"
#include "jam/JNoteGesture.h"
#include "jam/JPlayer.h"

JNoteSequencer::JNoteSequencer(const JNoteGesture *note,JPlayer *player)
  :_note(note),
   _player(player),
   _next(note->start())
{
  assert(_player != 0);
}
JBeat
JNoteSequencer::nextBeat()
{
  return _next;
}

JBeat 
JNoteSequencer::gotoBeat(const JBeat &when)
{
  if (when <= _note->start()) {
    _next=_note->start();
  } else if (when < _note->end()) {
    _next=when;
  } else {
    _next=JBeat::endOfTime();
  }
  return _next;
}

JBeat 
JNoteSequencer::execute()
{
  if (_next < _note->end()) {
    ((JHandler  <JMidiOutEvent, void> *)_player)->
      handle(JMidiOutEvent(JMidiOutType::NOTE_EFFECT,
			  _note->pitch(),
			  _note->velocity()));
    _next = _note->end();
  } else {
    ((JHandler  <JMidiOutEvent, void> *)_player)->
      handle(JMidiOutEvent(JMidiOutType::NOTE_EFFECT,
			  _note->pitch(),
			  0));

    _next=JBeat::endOfTime();
  }

  return _next;
}





