#ifndef _JMidiType_H
#define _JMidiType_H



class JMidiInType
{

public:

  JMidiInType(int type): _type((Type)type) {}

  enum Type {
    NOTE=0x90,
    NOTEON=0x90,
    NOTEOFF=0x80,
    CONTROLLER=0xb0,
    PITCHBEND=0xe0,
    PROGRAM=0xc0,
    PRESSURE=0xd0
  };

  Type  type() const { return _type; }

private:
  Type _type;

};



#include <limits.h>

class JMidiOutType 
{


public:

  enum Type{NO_EFFECT,
	NOTE_EFFECT,
	CNTRL_EFFECT,
	PROGRAM_EFFECT,
	PITCHBEND_EFFECT,
	ALLNOTEOFF_EFFECT,
	RESET_EFFECT,
	TEMPO_CHANGE,
	CHNPRESSURE_EFFECT,
	AUX_EFFECT};

  JMidiOutType(int i):_type((Type)i){;}

  JMidiOutType(Type type=NO_EFFECT):_type(type){;}

  Type  type() const { return _type; }
  bool  operator == (Type t) const { return t == _type; }

//  const Type & operator() () const { return _type; }
private:
  Type _type;

};


JMidiOutType midiInToOut(JMidiInType in);


static const int UNSET_EFFECT_VALUE=INT_MIN;

inline
bool isUnsetEffectValue(int val) { return val == UNSET_EFFECT_VALUE; }


#endif
