#include <qpopmenu.h>
#include <qkeycode.h>
#include <qaccel.h>
#include "QJEditor.h"
#include "QJEditCntrl.h"

QJEditCntrl::QJEditCntrl(QWidget *parent,
			   QJEditor *editor)
  : _editor(editor)
{
	
  _popup = new QPopupMenu;

  CHECK_PTR( _popup );
  
  int cutID   = _popup->insertItem( "Cut", editor,SLOT(cut()),CTRL+Key_X );
  int copyID  = _popup->insertItem( "Copy", editor,SLOT(copy()),CTRL+Key_C );
  int pasteID = _popup->insertItem( "Paste", editor,SLOT(paste()),CTRL+Key_V );

  _popup->insertSeparator();


  _popup->insertItem( "right",        editor,SLOT(right()),Key_Right );
  _popup->insertItem( "left",         editor,SLOT(left()),Key_Left );
  _popup->insertItem( "up",           editor,SLOT(up()),Key_Right );
  _popup->insertItem( "down",         editor,SLOT(down()),Key_Left );

  _popup->insertItem( "next phrase",  editor,SLOT(metaup()),ALT+Key_Up );
  _popup->insertItem( "prev phrase",  editor,SLOT(metadown()),ALT+Key_Down );

  _popup->insertItem( "insert note",  editor,SLOT(insert()));
  _popup->insertItem( "insert phrase",editor,SLOT(metainsert()));
  _popup->insertItem( "space ",       editor,SLOT(space()),Key_Space );
  _popup->insertItem( "backspace ",   editor,SLOT(backspace()),Key_Backspace );
  _popup->insertItem( "delete ",      editor,SLOT(del()),Key_Delete);
  _popup->insertItem( "attach",       editor,SLOT(enter()),Key_Enter );
  _popup->insertItem( "detach",       editor,SLOT(escape()),Key_Escape );

  _popup->setItemEnabled( cutID, FALSE );
  _popup->setItemEnabled( copyID, FALSE );
  _popup->setItemEnabled( pasteID, FALSE );



  QAccel *accel = new QAccel(parent);

  accel->connectItem(accel->insertItem(CTRL+Key_X ), editor,SLOT(cut()));
  accel->connectItem(accel->insertItem(CTRL+Key_C ), editor,SLOT(copy()));
  accel->connectItem(accel->insertItem(CTRL+Key_V ), editor,SLOT(paste()));

  accel->connectItem(accel->insertItem(Key_Right ) ,editor,SLOT(right()));
  accel->connectItem(accel->insertItem(Key_Left )  ,editor,SLOT(left()));

  accel->connectItem(accel->insertItem(Key_Up )    ,editor,SLOT(up()));
  accel->connectItem(accel->insertItem(Key_Down)  , editor,SLOT(down()));

  accel->connectItem(accel->insertItem(ALT+Key_Up )    ,editor,SLOT(metaup()));
  accel->connectItem(accel->insertItem(ALT+Key_Down)  , editor,SLOT(metadown()));


  accel->connectItem(accel->insertItem(Key_Insert ),editor,SLOT(insert()));
  accel->connectItem(accel->insertItem(ALT+Key_Insert ),editor,SLOT(metainsert()));

  accel->connectItem(accel->insertItem(Key_Space ),editor,SLOT(space()));
  accel->connectItem(accel->insertItem(Key_Backspace ),editor,SLOT(backspace()));
  accel->connectItem(accel->insertItem(Key_Delete),editor,SLOT(del()));
  accel->connectItem(accel->insertItem(Key_Enter ),editor,SLOT(enter()));
  accel->connectItem(accel->insertItem(Key_Escape ),editor,SLOT(escape()));

}

void 
QJEditCntrl::popup(const QPoint & pos, int indexAtPoint= 0)
{
  _popup->popup(pos,indexAtPoint);
}






