#include <iostream.h>

#include "JDeviceManager.h"
#include "JEffectList.h"
#include "rep/JMidiOutEvent.h"
#include "JDevice.h"



#include "assert.h"

JDeviceManager * JDeviceManager::_the=0;

JDeviceManager::JDeviceManager():_nOut(0),_nIn(0)
{
  assert(_the == 0);
  _the = this;
}

JEffectList *
JDeviceManager::newDeviceEffectList(int devId)
{
 JEffectList *list = outDevice(devId)->createEffectList();
 return list;
}

void
JDeviceManager::addOutDevice(JDevice *device)
{
  assert( _nOut < MAX_OUT_DEVICE-1 );
  _outDevice[_nOut++]=device;
}


void
JDeviceManager::addInDevice(JMidiIn *in)
{
  assert( _nIn < MAX_IN_DEVICE-1 );
  _inDevice[_nIn++]=in;
}



int          
JDeviceManager::nOutDevice() const 
{ 
  return _nOut; 
}

JDevice *    
JDeviceManager::outDevice(int i) 
{ 
  assert(i>=0 && i<_nOut);
  return _outDevice[i]; 
} 

JMidiIn *    
JDeviceManager::midiIn(int i)    
{ 
  assert(i>=0 && i<_nIn);
  return _inDevice[i]; 
}
  
int           
JDeviceManager::nInDevice() const 
{ 
  return _nIn; 
}


JDeviceManager *
JDeviceManager::the()
{
  if (_the == 0 ) _the=new JDeviceManager();
  return _the; 
}

void
JDeviceManager::handle(JMidiOutEvent e)
{
 
  // cout << "JDeviceManager: ";
  // e.debugOut(cout);

 int devId=e.deviceId();
 
 if (devId >=0 && devId < _nOut)
   if (!_outDevice[devId]->handle(e)) {
     //     cout << " Unhandled event " << endl ;
   }
 
 // cout << endl; 

}

