#include <iostream.h>
#include <unistd.h>

#include "japp/JApplication.h"
#include "jam/JDeviceManager.h"
#include "jam/JMidiIn.h"

#include "base/JOSTemplate.h"


class MyMidiObserver:public JObserver<JMidiInEvent ,void>
{
public:
  // JObserver<JMidiInEvent *,void>
  void handle(JMidiInEvent );
  const char *name() const { return " MyObserver "; }
};

void
MyMidiObserver::handle(JMidiInEvent event)
{
  cout << event << endl ;
}

int main()
{
  // Wrapper for /dev/sequencer

  JDeviceManager *manager=JDeviceManager::the();
  JApplication japp;

  assert(manager->nInDevice() > 0 );
  JMidiIn *midiIn=manager->midiIn(0);

  // some one to look at midi in events
  MyMidiObserver myObserver;

  midiIn->attach(&myObserver);

  cout << " ^C to quit " << endl;

  while(1); // tiddly pom

}










