/* --------------------------------- grmgr.c -------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Top level for display-device drivers
*/

#include "fly.h"


extern DEVICE * FAR
devices_select (char *dname)
{
	int	xmode;
	char	*p;
	DEVICE	*dev;

	if (vm_read ())
		return (0);

	if (dname == 0)			/* return default */
		return (Gr->devices);

	xmode = 0;
	p = strchr (dname, '=');
	if (p) {		/* "xx=dname" */
		if (1 != sscanf (dname, "%x=", &xmode))
			goto badret;
		dname = p+1;
	}

	for (dev = Gr->devices; dev; dev = dev->next) {
		if (!stricmp (dev->name, dname)) {
			if (xmode)
				dev->mode = xmode;
			return (dev);
		}
	}
	LogPrintf ("bad mode name \"%s\"\n", dname);
badret:
	vm_free ();
	return (0);
}

extern void FAR
devices_release (void)
{
	vm_free ();
}

extern struct GrDriver NEAR* FAR
devices_init (char *name)
{
	struct GrDriver	NEAR* FAR* p;
	char		*options;
	int		n;

	p = GrDrivers;
	if (name) {
		options = strchr (name, ':');
		if (T(options = strchr (name, ':')))
			n = options - name;
		else
			n = strlen (name);

		for (; *p; ++p)
			if (!strnicmp ((*p)->name, name, n) && !(*p)->name[n])
				break;
		if (!*p)
			LogPrintf ("bad device name \"%s\"\n", name);
	}
	return (*p);
}

extern void FAR
devices_term (void)
{
	if (!Gr)
		return;

	devices_release ();
	Gr = 0;
}
