/**********************************************************************/
/*                                                                    */
/*	CRISP - Programmable editor                                   */
/*	===========================                                   */
/*                                                                    */
/*  File:          view.cr                                            */
/*  Author:        P. D. Fox                                          */
/*  Created:       13 May 1991                     		      */
/*                                                                    */
/*  Copyright (c) 1990, 1991 Paul Fox                                 */
/*                All Rights Reserved.                                */
/*                                                                    */
/*                                                                    */
/*--------------------------------------------------------------------*/
/*  Description:  Macro to manipulate views of a buffer.              */
/*                                                                    */
/**********************************************************************/

/* SCCS ID: %Z% %M% %R%.%L% */
/**********************************************************************/
/*   The  following  list  is  used  when  the hex view is selected.  */
/*   This  displays  all  characters  in hexadecimal. This is mainly  */
/*   useful for looking at binary files.			      */
/**********************************************************************/
list	hex_view = {
	"00 ", "01 ", "02 ", "03 ", "04 ", "05 ", "06 ", "07 ", "08 ", "09 ", "0a ", "0b ", "0c ", "0d ", "0e ", "0f ", 
	"10 ", "11 ", "12 ", "13 ", "14 ", "15 ", "16 ", "17 ", "18 ", "19 ", "1a ", "1b ", "1c ", "1d ", "1e ", "1f ", 
	"20 ", "21 ", "22 ", "23 ", "24 ", "25 ", "26 ", "27 ", "28 ", "29 ", "2a ", "2b ", "2c ", "2d ", "2e ", "2f ", 
	"30 ", "31 ", "32 ", "33 ", "34 ", "35 ", "36 ", "37 ", "38 ", "39 ", "3a ", "3b ", "3c ", "3d ", "3e ", "3f ", 
	"40 ", "41 ", "42 ", "43 ", "44 ", "45 ", "46 ", "47 ", "48 ", "49 ", "4a ", "4b ", "4c ", "4d ", "4e ", "4f ", 
	"50 ", "51 ", "52 ", "53 ", "54 ", "55 ", "56 ", "57 ", "58 ", "59 ", "5a ", "5b ", "5c ", "5d ", "5e ", "5f ", 
	"60 ", "61 ", "62 ", "63 ", "64 ", "65 ", "66 ", "67 ", "68 ", "69 ", "6a ", "6b ", "6c ", "6d ", "6e ", "6f ", 
	"70 ", "71 ", "72 ", "73 ", "74 ", "75 ", "76 ", "77 ", "78 ", "79 ", "7a ", "7b ", "7c ", "7d ", "7e ", "7f ", 
	"80 ", "81 ", "82 ", "83 ", "84 ", "85 ", "86 ", "87 ", "88 ", "89 ", "8a ", "8b ", "8c ", "8d ", "8e ", "8f ", 
	"90 ", "91 ", "92 ", "93 ", "94 ", "95 ", "96 ", "97 ", "98 ", "99 ", "9a ", "9b ", "9c ", "9d ", "9e ", "9f ", 
	"a0 ", "a1 ", "a2 ", "a3 ", "a4 ", "a5 ", "a6 ", "a7 ", "a8 ", "a9 ", "aa ", "ab ", "ac ", "ad ", "ae ", "af ", 
	"b0 ", "b1 ", "b2 ", "b3 ", "b4 ", "b5 ", "b6 ", "b7 ", "b8 ", "b9 ", "ba ", "bb ", "bc ", "bd ", "be ", "bf ", 
	"c0 ", "c1 ", "c2 ", "c3 ", "c4 ", "c5 ", "c6 ", "c7 ", "c8 ", "c9 ", "ca ", "cb ", "cc ", "cd ", "ce ", "cf ", 
	"d0 ", "d1 ", "d2 ", "d3 ", "d4 ", "d5 ", "d6 ", "d7 ", "d8 ", "d9 ", "da ", "db ", "dc ", "dd ", "de ", "df ", 
	"e0 ", "e1 ", "e2 ", "e3 ", "e4 ", "e5 ", "e6 ", "e7 ", "e8 ", "e9 ", "ea ", "eb ", "ec ", "ed ", "ee ", "ef ", 
	"f0 ", "f1 ", "f2 ", "f3 ", "f4 ", "f5 ", "f6 ", "f7 ", "f8 ", "f9 ", "fa ", "fb ", "fc ", "fd ", "fe ", "ff "
	};

/**********************************************************************/
/*   The  following  is  used  to  view  a  file in hex & ascii mode  */
/*   (similar  to  od  -c). Use printable ascii where we can and hex  */
/*   other palces, but all characters are the same width	      */
/**********************************************************************/
list	hexasc_view = {
	"00 ", "01 ", "02 ", "03 ", "04 ", "05 ", "06 ", "07 ", "08 ", "09 ", "0a ", "0b ", "0c ", "0d ", "0e ", "0f ", 
	"10 ", "11 ", "12 ", "13 ", "14 ", "15 ", "16 ", "17 ", "18 ", "19 ", "1a ", "1b ", "1c ", "1d ", "1e ", "1f ", 
	"   ", "!  ", "\"  ", "#  ", "$  ", "%  ", "&  ", "'  ", "(  ", ")  ", "*  ", "+  ", ",  ", "-  ", ".  ", "/  ", 
	"0  ", "1  ", "2  ", "3  ", "4  ", "5  ", "6  ", "7  ", "8  ", "9  ", ":  ", ";  ", "<  ", "=  ", ">  ", "?  ", 
	"@  ", "A  ", "B  ", "C  ", "D  ", "E  ", "F  ", "G  ", "H  ", "I  ", "J  ", "K  ", "L  ", "M  ", "N  ", "O  ", 
	"P  ", "Q  ", "R  ", "S  ", "T  ", "U  ", "V  ", "W  ", "X  ", "Y  ", "Z  ", "[  ", "\\  ", "]  ", "^  ", "_  ", 
	"`  ", "a  ", "b  ", "c  ", "d  ", "e  ", "f  ", "g  ", "h  ", "i  ", "j  ", "k  ", "l  ", "m  ", "n  ", "o  ", 
	"p  ", "q  ", "r  ", "s  ", "t  ", "u  ", "v  ", "w  ", "x  ", "y  ", "z  ", "{  ", "|  ", "}  ", "~  ", "7f ", 
	"80 ", "81 ", "82 ", "83 ", "84 ", "85 ", "86 ", "87 ", "88 ", "89 ", "8a ", "8b ", "8c ", "8d ", "8e ", "8f ", 
	"90 ", "91 ", "92 ", "93 ", "94 ", "95 ", "96 ", "97 ", "98 ", "99 ", "9a ", "9b ", "9c ", "9d ", "9e ", "9f ", 
	"a0 ", "a1 ", "a2 ", "a3 ", "a4 ", "a5 ", "a6 ", "a7 ", "a8 ", "a9 ", "aa ", "ab ", "ac ", "ad ", "ae ", "af ", 
	"b0 ", "b1 ", "b2 ", "b3 ", "b4 ", "b5 ", "b6 ", "b7 ", "b8 ", "b9 ", "ba ", "bb ", "bc ", "bd ", "be ", "bf ", 
	"c0 ", "c1 ", "c2 ", "c3 ", "c4 ", "c5 ", "c6 ", "c7 ", "c8 ", "c9 ", "ca ", "cb ", "cc ", "cd ", "ce ", "cf ", 
	"d0 ", "d1 ", "d2 ", "d3 ", "d4 ", "d5 ", "d6 ", "d7 ", "d8 ", "d9 ", "da ", "db ", "dc ", "dd ", "de ", "df ", 
	"e0 ", "e1 ", "e2 ", "e3 ", "e4 ", "e5 ", "e6 ", "e7 ", "e8 ", "e9 ", "ea ", "eb ", "ec ", "ed ", "ee ", "ef ", 
	"f0 ", "f1 ", "f2 ", "f3 ", "f4 ", "f5 ", "f6 ", "f7 ", "f8 ", "f9 ", "fa ", "fb ", "fc ", "fd ", "fe ", "ff "
	};
/**********************************************************************/
/*   This  view  is a fixed width ascii view. Its designed to be the  */
/*   right hand window when viewing in a kind of 'hd' display.	      */
/**********************************************************************/
list	fw_view = {
	".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", 
	".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", 
	" ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",",  "-", ".", "/", 
	"0", "1", "2",  "3", "4", "5", "6", "7", "8", "9", ":", ";", "<",  "=", ">", "?", 
	"@", "A", "B",  "C", "D", "E", "F", "G", "H", "I", "J", "K", "L",  "M", "N", "O", 
	"P", "Q", "R",  "S", "T", "U", "V", "W", "X", "Y", "Z", "[", "\\", "]", "^", "_", 
	"`", "a", "b",  "c", "d", "e", "f", "g", "h", "i", "j", "k", "l",  "m", "n", "o", 
	"p", "q", "r",  "s", "t", "u", "v", "w", "x", "y", "z", "{", "|",  "}", "~", ".", 
	".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", 
	".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", 
	".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", 
	".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", 
	".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", 
	".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", 
	".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", 
	".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", 
	};
/**********************************************************************/
/*   View  window  using  octal  character  codes. Useful for binary  */
/*   files.							      */
/**********************************************************************/
list octal_view = {
	"000 ", "001 ", "002 ", "003 ", "004 ", "005 ", "006 ", "007 ",
	"010 ", "011 ", "012 ", "013 ", "014 ", "015 ", "016 ", "017 ",
	"020 ", "021 ", "022 ", "023 ", "024 ", "025 ", "026 ", "027 ",
	"030 ", "031 ", "032 ", "033 ", "034 ", "035 ", "036 ", "037 ",
	"040 ", "041 ", "042 ", "043 ", "044 ", "045 ", "046 ", "047 ",
	"050 ", "051 ", "052 ", "053 ", "054 ", "055 ", "056 ", "057 ",
	"060 ", "061 ", "062 ", "063 ", "064 ", "065 ", "066 ", "067 ",
	"070 ", "071 ", "072 ", "073 ", "074 ", "075 ", "076 ", "077 ",
	"100 ", "101 ", "102 ", "103 ", "104 ", "105 ", "106 ", "107 ",
	"110 ", "111 ", "112 ", "113 ", "114 ", "115 ", "116 ", "117 ",
	"120 ", "121 ", "122 ", "123 ", "124 ", "125 ", "126 ", "127 ",
	"130 ", "131 ", "132 ", "133 ", "134 ", "135 ", "136 ", "137 ",
	"140 ", "141 ", "142 ", "143 ", "144 ", "145 ", "146 ", "147 ",
	"150 ", "151 ", "152 ", "153 ", "154 ", "155 ", "156 ", "157 ",
	"160 ", "161 ", "162 ", "163 ", "164 ", "165 ", "166 ", "167 ",
	"170 ", "171 ", "172 ", "173 ", "174 ", "175 ", "176 ", "177 ",
	"200 ", "201 ", "202 ", "203 ", "204 ", "205 ", "206 ", "207 ",
	"210 ", "211 ", "212 ", "213 ", "214 ", "215 ", "216 ", "217 ",
	"220 ", "221 ", "222 ", "223 ", "224 ", "225 ", "226 ", "227 ",
	"230 ", "231 ", "232 ", "233 ", "234 ", "235 ", "236 ", "237 ",
	"240 ", "241 ", "242 ", "243 ", "244 ", "245 ", "246 ", "247 ",
	"250 ", "251 ", "252 ", "253 ", "254 ", "255 ", "256 ", "257 ",
	"260 ", "261 ", "262 ", "263 ", "264 ", "265 ", "266 ", "267 ",
	"270 ", "271 ", "272 ", "273 ", "274 ", "275 ", "276 ", "277 ",
	"300 ", "301 ", "302 ", "303 ", "304 ", "305 ", "306 ", "307 ",
	"310 ", "311 ", "312 ", "313 ", "314 ", "315 ", "316 ", "317 ",
	"320 ", "321 ", "322 ", "323 ", "324 ", "325 ", "326 ", "327 ",
	"330 ", "331 ", "332 ", "333 ", "334 ", "335 ", "336 ", "337 ",
	"340 ", "341 ", "342 ", "343 ", "344 ", "345 ", "346 ", "347 ",
	"350 ", "351 ", "352 ", "353 ", "354 ", "355 ", "356 ", "357 ",
	"360 ", "361 ", "362 ", "363 ", "364 ", "365 ", "366 ", "367 ",
	"370 ", "371 ", "372 ", "373 ", "374 ", "375 ", "376 ", "377 ",
	};
/**********************************************************************/
/*   This  mode  lets  you  see  the  buffer with control characters  */
/*   being   visible,   and  Tabs  being  displayed  as  a  printing  */
/*   sequence of characters. Useful for makefiles.		      */
/**********************************************************************/
list literal_view = {
	"<NUL>", "<SOH>", "<STX>", "<ETX>", 
	"<EOT>", "<ENQ>", "<ACK>", "<BEL>", 
	"<BS>",  "<TAB>",  "<NL>",  "<VT>",  
	"<FF>",  "<CR>",  "<SO>",  "<SI>", 
	"<DLE>", "<DC1>", "<DC2>", "<DC3>", 
	"<DC4>", "<NAK>", "<SYN>", "<ETB>", 
	"<CAN>", "<EM>",  "<SUB>", "<ESC>", 
	"<FS>",  "<GS>",  "<RS>",  "<US>" 
	};

/**********************************************************************/
/*   Following  variables  store  the  character map. We create them  */
/*   when we need them to save some memory space.		      */
/**********************************************************************/
int	hex_cmap = -1;
int	fw_cmap = -1;
int	hexasc_cmap = -1;
int	octal_cmap = -1;
int	literal_cmap = -1;
/**********************************************************************/
/*   Macro  to  allow user to select a 'view' through a window. This  */
/*   is  a  way  of looking at the data, e.g. to make all characters  */
/*   in hex or put window in EDT mode, etc.			      */
/**********************************************************************/
void
view(string arg)
{
	switch (arg) {
	  case "hex":
	  	if (hex_cmap < 0)
			hex_cmap = create_char_map(NULL, NULL, hex_view);
		set_window_cmap(hex_cmap, inq_window());
	  	break;
	  case "fwasc":
	  	if (fw_cmap < 0)
			fw_cmap = create_char_map(NULL, NULL, fw_view);
		set_window_cmap(fw_cmap, inq_window());
	  	break;
	  case "hexasc":
	  	if (hexasc_cmap < 0)
			hexasc_cmap = create_char_map(NULL, NULL, hexasc_view);
		set_window_cmap(hexasc_cmap, inq_window());
	  	break;
	  case "octal":
	  	if (octal_cmap < 0)
			octal_cmap = create_char_map(NULL, NULL, octal_view);
		set_window_cmap(octal_cmap, inq_window());
	  	break;
	  case "literal":
	  	literal();
	  	break;
	  case "normal":
		set_window_cmap(NULL, inq_window());
	  	break;
	  }
}
/**********************************************************************/
/*   Function  to  toggle  between  literal  display mode and normal  */
/*   mode.							      */
/**********************************************************************/
void
literal()
{
  	if (literal_cmap < 0) {
		literal_cmap = create_char_map(NULL, NULL, literal_view);
		/***********************************************/
		/*   Set  the  257th  entry  for  the  end of  */
		/*   line character.			       */
		/***********************************************/
		create_char_map(literal_cmap, 256, quote_list("$"));
		}
	else if (inq_char_map() == literal_cmap) {
		/***********************************************/
		/*   If  we're  already  in literal mode then  */
		/*   turn it off.			       */
		/***********************************************/
		set_window_cmap(NULL, inq_window());
		return;
		}
	set_window_cmap(literal_cmap, inq_window());
}
