/**********************************************************************/
/*   Header file for self-organising integer library.		      */
/**********************************************************************/

# define	SINT_INCR	32 /* Size to increase size of array by */

/**********************************************************************/
/*   Number of longs to allocate for bitmap.			      */
/**********************************************************************/
# define	SB_BITMAP_SIZE	8

# define	SB_SET(b, p)	p->sb_bits[b >> 5] |= 1 << (b & 0x1f)
# define	SB_ISSET(b, p)	(p->sb_bits[b >> 5] & (1 << (b & 0x1f)))
/**********************************************************************/
/*   Convert a key to lowest value in the range.		      */
/**********************************************************************/
# define	SB_RANGE(x)	((x) & ~0xff)
typedef struct sentry_t {
	unsigned long se_key;	/* Key value.				*/
	char	*se_ptr;	/* Pointer to value.			*/
	} sentry_t;

/**********************************************************************/
/*   The bitmap structure used for fast lookups and fast inserts.     */
/**********************************************************************/
typedef struct sbitmap_t {
	unsigned long	sb_start;
	long		sb_bits[SB_BITMAP_SIZE];
	} sbitmap_t;

typedef struct stype_t {
	short		st_need_sort;	/* TRUE when we insert into the object. */
	short		st_bsize;	/* Bitmap size.				*/
	sbitmap_t	*st_bitmaps;	/* Bitmap structure.			*/
	int		st_size;	/* Number of entries available.		*/
	int		st_used;	/* Number entries used so far.		*/
	sentry_t 	*st_block;	/* Array allocated to entry.		*/
	} stype_t;
	
stype_t		*st_alloc PROTO((void));
void		st_free PROTO((stype_t *));
void		st_insert PROTO((stype_t *, unsigned long, char *));
void		st_sort PROTO((stype_t *));
sentry_t	*st_lookup PROTO((stype_t *, unsigned long));
void		st_replace PROTO((stype_t *, sentry_t *, char *));
