/**************************************************************
 *
 *	CRISP - Custom Reduced Instruction Set Programmers Editor
 *
 *	(C) Paul Fox, 1989
 *
 *    Please See COPYRIGHT notice.
 *
 **************************************************************/
# define	CM_MAGIC	((')' << 8) | ')')

typedef	struct CM	{
	u_int16		cm_magic;	/* Magic file number.		*/
	u_int16		cm_version;	/* .cm version number.		*/

	u_int16		cm_num_macros;	/* Number of macro sections.	*/
	u_int16		cm_num_atoms;	/* Number of atoms in all macros*/

	u_int32		cm_globals;	/* Offset to start of globals table*/

	u_int16		cm_num_globals;	/* Size of globals array.	*/
	u_int16		cm_num_strings;	/* Number of strings.		*/

	} CM;

/**********************************************************************/
/*   Followed by:						      */
/*   								      */
/*   u_int32 cm_moffsets[cm_num_macros];			      */
/*   								      */
/*   u_int32 cm_string_offset;					      */
/*   								      */
/*   MACROS							      */
/*   								      */
/*   u_int32 cm_soffsets[cm_string_offset];			      */
/*   								      */
/*   STRINGS							      */
/**********************************************************************/


/**********************************************************************/
/*   The  following  are the atom types we recognize and generate in  */
/*   the cm files.						      */
/**********************************************************************/
# ifdef OPCODE
# define	F_ERROR		-1	/* Non-existant case.		*/
# define	F_HALT		0	/* End of List.			*/
# define	F_INT		1	/* 32-bit integer.		*/
# define	F_STR		2	/* Unquoted string.		*/
# define	F_LIST		3	/* List.			*/
# define	F_NULL		4	/* Used as destination of loops.*/
# define	F_ID		5	/* 16-bit keyword.		*/
# define	F_END		6	/* End of list.			*/
# define	F_POLY		7	/* Symbol is polymorphic.	*/
# define	F_LIT		8	/* Pointer to literal string.	*/
# define	F_RSTR		9	/* Pointer to reference string.	*/
# define	F_FLOAT		10      /* Floating point number.	*/
# define	F_RLIST		11	/* A Reference list.    	*/
# else
typedef enum opcodes {
		F_ERROR		= -1,	/* Non-existant case.		*/
		F_HALT		= 0,	/* End of List.			*/
		F_INT		= 1,	/* 32-bit integer.		*/
		F_STR		= 2,	/* Unquoted string.		*/
		F_LIST		= 3,	/* List.			*/
		F_NULL		= 4,	/* Used as destination of loops.*/
		F_ID		= 5,	/* 16-bit keyword.		*/
		F_END		= 6,	/* End of list.			*/
		F_POLY		= 7,	/* Symbol is polymorphic.	*/
		F_LIT		= 8,	/* Pointer to literal string.	*/
		F_RSTR		= 9,	/* Pointer to reference string.	*/
		F_FLOAT		= 10,   /* Floating point number.	*/
		F_RLIST		= 11	/* A Reference list.     	*/
		} OPCODE;
# endif

