/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	stattxt.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_static_text class header
 *
 *	RCSid = "$Id: stattxt.H,v 4.13.1.1 1993/06/01 22:56:55 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_stattxt_H
#define OI_stattxt_H

#ifndef OI_wdtech_H
#include <OI/wdtech.H>
#endif /* OI_wdtech_H */

	class	OI_tabstops;

 /* ctl_bits private bits */
#define		OI_STATIC_TEXT_CUT_PASTE	0x1	/* 1 => cut & paste allowed */
#define		OI_STATIC_TEXT_MOUSE_SELECT	0x2	/* 1 => doing a mouse select */
#define		OI_STATIC_TEXT_CLICK_SELECT	0x4	/* 1 => selection by clicking allowed */
#define		OI_STATIC_TEXT_ALIGN_RIGHT	0x8	/* 1 => alignment loc is right edge */
#define		OI_STATIC_TEXT_MOD		0x10	/* 1 => text modified since last clear_modified() */

 /* model dependent aspects of OI_static_text */
// GA There are none currently needed; translations are handled specifically in constructor
//	class	OI_mdl_static_text : public OI_mdl {
//		protected:
//			class	OI_static_text	*gen_objp;
//		public:
//						OI_mdl_static_text(OI_static_text *stp, OI_class *clsp) : OI_mdl(clsp)
//							{gen_objp = stp;}
//	};

	class OI_static_text : public OI_w_d_tech {
// GA			OI_mdl_static_text	*mdl_dep;	/* pointer to the model dependent aspect of the object. */
		static	char		*drag_text;	/* text being dragged and dropped */
			unsigned long	ctl_bits ;	/* class private control bits */
			OI_string	*plytxt;	// pointer to converted text string
			char		*enctxt;	// pointer to encoded text string, for text() function
			OI_number	pri_start ;	/* start chr psn for completed selection */
			OI_number	pri_end ;	/* ending chr psn for completed selection */
			char		*pri_bufp ;	/* ptr to PRIMARY selection buffer */
			OI_number	pri_nchrs ;	/* # chars used in *pri_bufp */
			OI_number	pri_maxchrs ;	/* max # chars in *pri_bufp */
			OI_number	btn ;		/* button number used for click */
			OI_number	n_click ;	/* # clicks which have occurred */
			Time		tim ;		/* time of last button press/release event */
			OI_enhance	enhancement;	// what type of enhancement to use
			OI_tabstops	*tabs;		// ptr to tabstops table
	 public:
		static	OI_class	*clsp ;		/* ptr to class record */
	 protected:
		static	XrmQuark	q_cbClick ;	/* quark for click callback */

	 private:
			void		construct(const char *textp) ;

			void		allow_align_right()	{ ctl_bits |= OI_STATIC_TEXT_ALIGN_RIGHT; }
			void		allow_mouse_select()	{ctl_bits |= OI_STATIC_TEXT_MOUSE_SELECT;}
			void		disallow_align_right()	{ ctl_bits &= ~OI_STATIC_TEXT_ALIGN_RIGHT; }
			void		disallow_mouse_select()	{ctl_bits &= ~OI_STATIC_TEXT_MOUSE_SELECT;}
			OI_number	gen_boundary(OI_bool fwd, OI_number pos) ;	/* find general boundary */
			OI_bool		is_mouse_select()	{return((ctl_bits&OI_STATIC_TEXT_MOUSE_SELECT)?OI_YES:OI_NO);}
			void		refresh_my_callback(OI_cb_inf*) ;
			void		res_alignment(void *);
			void		save_select(Atom,OI_number,OI_number) ;		/* save current selection */
			OI_bool		selection_convert(OI_d_tech *, void *, const XEvent *);
			OI_bool		send_select_data(Window,Atom,Atom,Atom) ;	/* send data to requestor */
			void		select_line();					/* select entire line of text */
			void		select_word(OI_number);				/* select single word from text */
			void		set_modified()		{ ctl_bits |= OI_STATIC_TEXT_MOD; }
			void		void_select() ;					/* cancel current selection */
			OI_number	word_boundary(OI_bool fwd, OI_number pos) ;	/* find word boundary */

	 protected:
					OI_static_text(OI_class *clsp, const char *usr_namp, const char *textp) ;
		virtual	void		new_connection(OI_connection*);
		virtual	void		new_model(OI_model_type) ;

	 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
					OI_static_text(const char *usr_namp, const char *textp) ;
					~OI_static_text() ;
		virtual	OI_number	alignment_loc_x(OI_alignment=OI_alignment_default);
			OI_stat		create() ;
			void		disable() ;
		friend	void		dmpOI_static_text(OI_static_text*) ;		/* diagnostic dump procedure */
			void		dragdrop_start(OI_dnd_operation, const XEvent *);
			void		enable() ;
			void		font_resize() ;					/* resize object for font change */
		static	OI_bool		init(OI_connection*) ;
			OI_bool		is_write_resq(XrmQuark);
		static	OI_static_text	*make_minimal(const char *usr_namp, OI_minimal_type) ;
			void		new_alignment(OI_alignment) ;
			OI_stat		new_text(const char *textp, OI_char_encode_type) ;
											/* set text from new text */
		virtual	void		paint(const XEvent*, void* =NULL) ;		/* draw contents after mapping X window (GA should be private, but st_events table needs to point to these) */
			OI_string	*ply_text()		{ return (plytxt); }
		virtual	void		post_get_resources();
			char		*res_get_text();				/* callback for text resource */
			void		res_is_click_select(void *);
			void		res_is_cut_paste(void *);
			void		res_set_text(void *);				/* callback for text resource */
			void		select(const XEvent*) ;				/* selection operations (GA should be private, but st_events table needs to point to these) */
		virtual	OI_tabstops	*tabstops() ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE MEMBER FUNCTIONS	
		//		Functions in this section were previously documented, but have been marked as
		//		obsolete.  These functions have been removed from the programmer's manual.
		//		These functions are subject to removal from the toolkit and should NEVER be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		
			void		enhance(OI_number,OI_number) ;			/* enhance portion of text */
			void		unenhance(OI_number,OI_number) ;		/* unenhance portion of text */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	char		*alpha_value() ;
		virtual	void		clone_adjust(OI_d_tech*) ;
		virtual	void		drag_end(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
		virtual	void		drag_copy_start(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
		virtual	void		drag_move_start(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
		virtual char		*selection_data(Atom) ;				/* get selection's data */
		virtual	char		*selection_data(const char *) ;			/* get selection's data */
		virtual	OI_stat		set_state(OI_state) ;				/* change state */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			OI_alignment	alignment() ;
			void		allow_click_select() 	{ ctl_bits |= OI_STATIC_TEXT_CLICK_SELECT; }
			void		allow_cut_paste() ;
			OI_stat		change_char(OI_number pos, char) ;		/* change a single char in text */
			OI_stat		change_chars(OI_number pos, OI_number len, const char *textp) ;	/* change substring in text */
			void		clear_enhance() ;				/* clear all enhancements */
			void		clear_modified()	{ ctl_bits &= ~OI_STATIC_TEXT_MOD; }
			void		disallow_click_select()	{ ctl_bits &= ~OI_STATIC_TEXT_CLICK_SELECT; }
			void		disallow_cut_paste() ;
			OI_enhance	get_enhance(OI_number) ;			/* get enhance for a character */
			OI_bool		is_click_select()	{ return((ctl_bits & OI_STATIC_TEXT_CLICK_SELECT) ? OI_yes : OI_no); }
			OI_bool		is_cut_paste()		{ return((ctl_bits & OI_STATIC_TEXT_CUT_PASTE) ? OI_yes : OI_no); }
			OI_bool		is_modified()		{ return((ctl_bits & OI_STATIC_TEXT_MOD) ? OI_yes : OI_no);}
			OI_number	length() ;
			void		remove_enhance(OI_number,OI_number,OI_enhance) ;/* unenhance portion of text */
			OI_bool		selection_coords(OI_number *strt, OI_number *end)
								{ *strt = pri_start; *end = pri_end-1; return (OI_bool)(pri_start >= 0); }
			void		set_alignment(OI_alignment) ;
			void		set_enhance(OI_number,OI_number,OI_enhance,const char*,const char*,const char* =NULL) ;
											/* enhance portion of text */
			void		set_enhance(OI_number,OI_number,OI_enhance,PIXEL=OI_unknown_pixel,PIXEL=OI_unknown_pixel,
						const char* =NULL) ;			/* enhance portion of text */
			void		set_tab_width(OI_number) ;
			void		set_tabs_custom(OI_number *, OI_number, OI_number =8) ;
			OI_stat		set_text(const char *textp) ;
			char		*text() ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED TRANSLATIONS FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under the
		//		translations available for this object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void		cancel_select(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		click_down(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void		click_up(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void		copy_start(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		extend_start(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void		secondary_adjust(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void		secondary_end(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void		secondary_start(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void		select_adjust(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		select_end(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		select_start(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	OI_static_text	*oi_create_static_text(const char *usr_namp, const char *textp) ;	/* create static text object */

#endif /* OI_stattxt_H */
