#include <math.h>
#include <OI/oi.H>
#include <OI/plystr.H>
#include "vumeter.H"


static float pi = 3.14159265;

void
reg_VuMeter()
{
	VuMeter::clsp = OI_register_class(
		"VuMeter", "OI_display_1d",
		(OI_class_init_memfnp)&VuMeter::init,
		(OI_make_minimal_memfnp)&VuMeter::make_minimal);
}
VuMeter*
create_VuMeter(
	const char	*np,
	OI_number	w,
	OI_number	h,
	OI_number	arc,
	OI_number	nticks,
	long		mx,
	long		mn )
{
	VuMeter		*p;

	p = new VuMeter( np, w, h, arc, nticks, mx, mn );
	if (p && (p->error_status() < 0)) {
		p->del();
		p = NULL;
	}
	return( p );
}
OI_bool
VuMeter::init(
	OI_connection *conp)
{
	static OI_resource resources[] = {
		{ "arc", "Arc", OI_r_Int, sizeof(int), NULL,
			0, 0,
			OI_RESOURCE_MEMFN_CAST(&VuMeter::res_arc), NULL,
			OI_RESOURCE_GET_MEMFN_CAST(&VuMeter::arc), NULL,
			OI_RM_MDL_ALL },
		};
	if (!clsp->class_initialized()) {
		clsp->set_resources(resources, OI_count(resources));
	}
	clsp->mark_initialized(conp) ;
	return ( OI_YES );
}
VuMeter::VuMeter(
	OI_class			*classp,
	const char			*usr_namp,
	OI_number			width,
	OI_number			height,
	OI_number			arc,
	OI_number			nticks,
	long			mx,
	long			mn )
	: OI_display_1d(classp, usr_namp, mx, mn,
		NULL, OI_DISPLAY_1D_ENDS_NONE, NULL, NULL, OI_DISPLAY_1D_CURRENT_NONE,
		nticks, OI_DISPLAY_1D_TICKS_ALL, NULL )
{
	construct(width, height, arc);
}
VuMeter::VuMeter(
	const char			*usr_namp,
	OI_number			width,
	OI_number			height,
	OI_number			arc,
	OI_number			nticks,
	long			mx,
	long			mn )
	: OI_display_1d(clsp, usr_namp, mx, mn,
		NULL, OI_DISPLAY_1D_ENDS_NONE, NULL, NULL, OI_DISPLAY_1D_CURRENT_NONE,
		nticks, OI_DISPLAY_1D_TICKS_ALL, NULL )
{
	construct( width, height, arc );
}
VuMeter::~VuMeter()
{
}
void
VuMeter::construct(
	OI_number width,
	OI_number height,
	OI_number arc )
{
	extent.x = width;
	extent.y = height;
	new_arc( arc );

	resize();

	set_resize(this, (OI_resize_memfnp)&VuMeter::resize);
}
VuMeter *
VuMeter::make_minimal(const char *name, OI_minimal_type)
{
	return (new VuMeter(name, 64, 64, 90, 11, 10 ));
}

/**********************************************************************
 *
 * "arc" resource:
 * res_arc				handle resource fetch
 * set_arc				set programatically
 * new_arc				generic attribute update
 *
 **********************************************************************
 */
int		VuMeter::arc()				{ return( ndegrees ); }
void		VuMeter::res_arc(void *ptr)				{ new_arc(*(int *)ptr); }
void		VuMeter::set_arc(int upd)				{ new_arc(upd); }
void
VuMeter::new_arc( int upd )
{
	ndegrees = upd ;
	calculate_constants();
	if (x_window_id())
		XClearArea(connection()->display(), x_window_id(), 0,0,0,0, True);
}
OI_stat
VuMeter::create()
{
	if (!x_window_id()) {
		OI_display_1d::create();
		if (OI_status == OI_OK)
			conp->dispatch_insert(X_window_id,Expose,ExposureMask,this,(
				OI_event_memfnp)&VuMeter::paint);
	}
	else
		OI_status = OI_win_exists ;
	return(OI_status) ;
}
void
VuMeter::calculate_constants()
{
	inner_radius = diameter/3.;
	nradians = (ndegrees/180.) * pi;
	start = (3.*pi - nradians)/2.;
	delta = nradians/(num_ticks() - 1);
	ox = oy = 0;
}

void
VuMeter::resize()
{
	diameter = (size_x() < size_y()) ? size_x() : size_y();
	xo = 0;
	yo = 0;
	if (size_x() > diameter)
		xo = (size_x() - diameter)/2;
	if (size_y() > diameter)
		yo = (size_y() - diameter)/2;
	xo += diameter/2;
	yo += (2 * diameter)/3;
	calculate_constants();
	if (is_visible())
		repaint(OI_YES);
}

void
VuMeter::paint( const XEvent*, void * )
{
	set_gc();
	paint_ticks();
	paint_tick_labels();
	paint_value( value() );
}

void
VuMeter::paint_value(
	long 			val)
{
	int 			x1, y1 ;
	double 			rad ;
	double 			angle ;
	GC 			gc;
	XGCValues 			gcv;
	Display 			*dpy;

	if (x_window_id()) {
		set_gc();

		gc = connection()->gc();
		dpy = connection()->display();

		if (ox || oy) {
			set_gc(bkg_pixel());
			XDrawLine(dpy, X_window(), gc, xo, yo, ox, oy );
		}

		set_gc(fg_pixel());
		XChangeGC(dpy, gc, GCForeground, &gcv);

		angle = start + nradians * ( val - minimum()) / (maximum() - minimum()) ;
		rad = (5./6.)*inner_radius ;
		x1 = (int) rint( rad*cos( angle ) );
		y1 = (int) rint( rad*sin( angle ) );
		ox = x1 + xo;
		oy = y1 + yo;

		XDrawLine(dpy, X_window(), gc, xo, yo, ox, oy );
	}
}
void
VuMeter::paint_ticks()
{
	Display			 *dpy;
	GC			 gc;
	int			 i;
	int			 nt;
	double			 ticklen ;	 /* length of tick mark */
	double			 cs ;	 /* cos( start ); */
	double			 sn ;	 /* sin( start ); */
	double			 angle ;	 /* current angle being computed */
	int			 x1, y1 ;
	int			 x2, y2 ;

	gc = connection()->gc();
	dpy = connection()->display();
	set_gc(fg_pixel());

	nt = num_ticks();
	for (angle=start, i=0; i<nt; i++, angle += delta) {
		ticklen = diameter/12. ;
		if (i%5)
			ticklen /= 2.;

		ticklen += inner_radius;
		cs = cos( angle );
		sn = sin( angle );

		x1 = (int) rint( inner_radius*cs );
		y1 = (int) rint( inner_radius*sn );
		x2 = (int) rint( ticklen*cs );
		y2 = (int) rint( ticklen*sn );

		XDrawLine(dpy, X_window(), gc, x1+xo, y1+yo, x2+xo, y2+yo );
	}
}
void
VuMeter::paint_tick_labels()
{
	int				 i; 	/* tick loop counter */
	OI_number				 nt ; 	/* number of tick marks */
	OI_number				 x, y;	/* position of painting */
	OI_number				 fh ; 	/* font height */
	OI_number				 fyb ;	/* font y base */
	OI_display_1d_ticks				 lt ; 	/* type of tick labeling */
	OI_string				 *tick_lblp ; 	/* label to paint on tick mark */
	double				 tk ; 	/* where the tick ends */
	double				 angle ; 	/* current angle being computed */
	double				 cs, sn ; 	/* cos and sin of this angle */

	nt = num_ticks() ;
	lt = tick_type() ;
	tk = 11./24. * diameter;
	for (angle=start, i=0; i<nt; i++, angle += delta) {
		if (i%5)
			continue ;

		if (lt == OI_DISPLAY_1D_TICKS_ENDS || lt == OI_DISPLAY_1D_TICKS_ENDS_CUSTOM) {
			if (i == 0)
				tick_lblp = ply_tick_label(0) ;
			else if (i == (nt-1))
				tick_lblp = ply_tick_label(1) ;
			else
				tick_lblp = NULL;
		}
		else
			tick_lblp = ply_tick_label(i) ;
		if (tick_lblp) {
			cs = cos( angle );
			sn = sin( angle );
			fh = tick_lblp->font_height();
			fyb = tick_lblp->font_y_base();
			/*
			 * find x and y on the circle bounding the largest
			 * tick marks. and then angularly shift the text
			 * outwards so that the text sits outside.
			 */
			x = ((int) rint( (tk * cs) + (tick_lblp->width()*(cs - 1)/2) ));
			y = ((int) rint( (tk * sn) - ((fh - fyb)*sn/2) ));
			tick_lblp->draw_image_text( this, x + xo, y + yo );
		}
	}
	return ;
}
