/*
 * @(#)mem.c	1.5 91/09/05
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/ptrace.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/mman.h>

#include "defs.h"

int
sys_brk(tcp)
struct tcb *tcp;
{
	if (entering(tcp)) {
		fprintf(outf, "%x", tcp->u_args[0]);
	}
#ifdef linux
	return RVAL_HEX;
}
#else
	return 0;
}

int
sys_sbrk(tcp)
struct tcb *tcp;
{
	if (entering(tcp)) {
		fprintf(outf, "%u", tcp->u_args[0]);
	}
	return RVAL_HEX;
}
#endif

static Xlat mmap_prot[] = {
	PROT_READ,	"READ",
	PROT_WRITE,	"WRITE",
	PROT_EXEC,	"EXEC",
	PROT_NONE,	"NONE",
	0,		NULL,
};
static Xlat mmap_flags[] = {
	MAP_SHARED, 	"SHARED",
	MAP_PRIVATE, 	"PRIVATE",
	MAP_FIXED, 	"FIXED",
#ifndef linux
	MAP_RENAME, 	"RENAME",
	MAP_NORESERVE, 	"NORESERVE",
#endif
	0,		NULL,
};

#ifndef linux
int
sys_smmap(tcp)
struct tcb *tcp;
{
	Xlat *x;

	if (entering(tcp)) {
		/* addr */
		fprintf(outf, "%#x, ", tcp->u_args[0]);
		/* len */
		fprintf(outf, "%u, ", tcp->u_args[1]);
		/* prot */
		printflags(mmap_prot, tcp->u_args[2]);
		fprintf(outf, ", ");
		/* flags */
		printxval(mmap_flags, tcp->u_args[3] & MAP_TYPE, "MAP_???");
		addflags(mmap_flags,
				tcp->u_args[3] & (~_MAP_NEW & ~MAP_TYPE));
		/* fd */
		fprintf(outf, ", %u, ", tcp->u_args[4]);
		/* offset */
		fprintf(outf, "%#x", tcp->u_args[5]);
	}
	return RVAL_HEX;
}

#else
int
sys_mmap(tcp)
struct tcb *tcp;
{
	Xlat *x;
	int args[6];

	if (entering(tcp)) {
		if (umove(tcp->pid, tcp->u_args[0], sizeof args, (char *) args) == -1)
			return 0;
		/* addr */
		fprintf(outf, "%#x, ", args[0]);
		/* len */
		fprintf(outf, "%u, ", args[1]);
		/* prot */
		printflags(mmap_prot, args[2]);
		fprintf(outf, ", ");
		/* flags */
		printxval(mmap_flags, args[3] & MAP_TYPE, "MAP_???");
		addflags(mmap_flags, args[3] & ~MAP_TYPE);
		/* fd */
		fprintf(outf, ", %u, ", args[4]);
		/* offset */
		fprintf(outf, "%#x", args[5]);
	}
	return RVAL_HEX;
}
#endif

int
sys_munmap(tcp)
struct tcb *tcp;
{
	if (entering(tcp)) {
		/* addr */
		fprintf(outf, "%#x, ", tcp->u_args[0]);
		/* len */
		fprintf(outf, ", %u, ", tcp->u_args[1]);
	}
	return 0;
}

#ifndef linux
int
sys_mprotect(tcp)
struct tcb *tcp;
{
	if (entering(tcp)) {
		/* addr */
		fprintf(outf, "%#x", tcp->u_args[0]);
		/* len */
		fprintf(outf, ", %u, ", tcp->u_args[1]);
		/* prot */
		printflags(mmap_prot, tcp->u_args[2]);
	}
	return 0;
}

static Xlat mctl_funcs[] = {
	MC_LOCK,	"LOCK",
	MC_LOCKAS,	"LOCKAS",
	MC_SYNC,	"SYNC",
	MC_UNLOCK,	"UNLOCK",
	MC_UNLOCKAS,	"UNLOCKAS",
	0,		NULL,
};

int
sys_mctl(tcp)
struct tcb *tcp;
{
	int arg, function;

	if (entering(tcp)) {
		/* addr */
		fprintf(outf, "%#x", tcp->u_args[0]);
		/* len */
		fprintf(outf, ", %u, ", tcp->u_args[1]);
		/* function */
		function = tcp->u_args[2];
		printflags(mctl_funcs, function);
		/* arg */
		arg = tcp->u_args[3];
		if (function == MC_SYNC)
			fprintf(outf, ", %s", arg==MS_ASYNC?"ASYNC":(
						arg==MS_INVALIDATE?"INVALIDATE":
							"MS_???"
						)
			);
		else
			fprintf(outf, ", %#x", arg);
	}
	return 0;
}
#endif
