/* This file contains system-specific functions for MS-DOS.
 * and the Manx Aztec C compiler.
 * The program pfdisk.c calls these routines.
 */
#include <stdio.h>
#include <fcntl.h>
/* #include <sys/types.h>
#include <sys/stat.h> */

#define extern
#include "sysdep.h"
#undef extern

int usage(prog)	/* print a usage message */
char	*prog;	/* program name */
{
  fprintf(stderr,"Usage: %s <disk>\n", prog);
  fprintf(stderr,"\twhere <disk> is a digit [0-9]\n");
}


void getGeometry(name, c, h, s)
char	*name;		/* device name */
unsigned *c,*h,*s;	/* cyls, heads, sectors */
{
  int dev;	/* hard disk number */
  unsigned cflag;
 struct h {
 	unsigned char al;
	unsigned char ah;
	unsigned char bl;
	unsigned char bh;
	unsigned char cl;
	unsigned char ch;
	unsigned char dl;
	unsigned char dh;
	int SI;
	int DI;
	int DS;
	int ES;
	} reg;
  
  if (name[0] < '0' ||
      name[0] > '9' ||
      name[1] != 0  )
    {
      fprintf(stderr,"%s: device name must be a digit\n", name);
      return;
    }
  dev = (name[0] - '0');
  
  reg.ah = 8;		/* get param.	*/
  reg.dl = dev | 0x80;
  
  cflag=0x1&(unsigned)sysint(0x13,&reg,&reg);
  
  /* Are that many drives responding? */
  if (reg.dl <= dev ) {
    fprintf(stderr,"%s: drive not found\n", name);
    return;
  }
  if (cflag) {
    fprintf(stderr,"%s: can't get disk parameters\n", name);
    return;
  }
  *c = ((((unsigned int) reg.cl << 2) & 0x300) | reg.ch) + 1;
  *h = reg.dh + 1;
  *s = reg.cl & 0x3F;
}

int getFile(name, buf, len)	/* read file into buffer */
char	*name, *buf;
int	len;
{	/* (open, read, close) */
  int devfd, retval;
  
  devfd = open(name, O_RDONLY);
  if (devfd < 0) {
    fprintf(stderr,"%s: can't open for reading\n", name);
    return(devfd);
  }
  retval = read(devfd, buf, len);
  if (retval < 0)
    fprintf(stderr,"%s: read failed\n", name);
  close(devfd);
  return(retval);
}

int putFile(name, buf, len)	/* write buffer to file */
char	*name, *buf;
int	len;
{	/* (open, write, close) */
  int devfd, retval;
  
  devfd = open(name, O_WRONLY|O_TRUNC);
  if (devfd < 0) {
    fprintf(stderr,"%s: can't open for writing\n", name);
    return(devfd);
  }
  retval = write(devfd, buf, len);
  if (retval < 0)
    fprintf(stderr,"%s: write failed\n", name);
  close(devfd);
  return(retval);
}

int getBBlk(name, buf)	/* read boot block into buffer */
char	*name, *buf;
{	/* BIOS absolute disk read */
  int cflag, dev;
struct regs {
	int AX;
	int BX;
	int CX;
	int DX;
	int SI;
	int DI;
	int DS;
	int ES;
	} reg;
  unsigned ptr[4];
  
  if (name[0] < '0' ||
      name[0] > '9' ||
      name[1] != 0  )
    {
      fprintf(stderr,"%s: device name must be a digit\n",name);
      return(-1);
    }
  dev = (name[0] - '0');
  
  segread(ptr);	/* get ds; ptr[2] = ds */
  reg.ES = ptr[2];	/* segment part of buffer address */
  reg.BX = (int) buf;
  
  reg.AX = 0x201;
  /* regs.h.ah = 2;		/* read		*/
  /* regs.h.al = 1;		/* sector count	*/

  reg.CX = 0x1;
/*   regs.h.ch = 0;		/* track	*/
/*   regs.h.cl = 1;		/* start sector	*/

  reg.DX = dev|0x80;
/*   regs.h.dh = 0;		/* head		*/
/*   regs.h.dl = dev|0x80;	/* drive	*/
  
  cflag = 0x1 & (unsigned)sysint(0x13,&reg,&reg);
  if (cflag) {
    fprintf(stderr,"%s: read failed\n", name);
    return(-1);
  }
  return(SECSIZE);
}

int putBBlk(name, buf)	/* write buffer to boot block */
char	*name, *buf;
{	/* BIOS absolute disk write */
  int cflag, dev;
struct regs {
	int AX;
	int BX;
	int CX;
	int DX;
	int SI;
	int DI;
	int DS;
	int ES;
	} reg;
  unsigned ptr[4];
  
  if (name[0] < '0' ||
      name[0] > '9' ||
      name[1] != 0  )
    {
      fprintf(stderr,"%s: device name must be a digit\n",name);
      return(-1);
    }
  dev = (name[0] - '0');
  
  segread(ptr);	/* get ds; ptr[2] = ds */
  reg.ES = ptr[2];	/* segment part of buffer address */
  reg.BX = (int) buf;
  
  reg.AX = 0x301;
  /* regs.h.ah = 3;		/* write		*/
  /* regs.h.al = 1;		/* sector count	*/

  reg.CX = 0x1;
/*   regs.h.ch = 0;		/* track	*/
/*   regs.h.cl = 1;		/* start sector	*/

  reg.DX = dev|0x80;
/*   regs.h.dh = 0;		/* head		*/
/*   regs.h.dl = dev|0x80;	/* drive	*/
  
  cflag = 0x1 & (unsigned)sysint(0x13,&reg,&reg);
  if (cflag) {
    fprintf(stderr,"%s: read failed\n", name);
    return(-1);
  }
  return(SECSIZE);
}
